<?php
$hudson_edge_icon_collections = hudson_edge_return_icon_collections();


/*** Removing shortcodes ***/

vc_remove_element("vc_widget_sidebar");
vc_remove_element("vc_wp_search");
vc_remove_element("vc_wp_meta");
vc_remove_element("vc_wp_recentcomments");
vc_remove_element("vc_wp_calendar");
vc_remove_element("vc_wp_pages");
vc_remove_element("vc_wp_tagcloud");
vc_remove_element("vc_wp_custommenu");
vc_remove_element("vc_wp_text");
vc_remove_element("vc_wp_posts");
vc_remove_element("vc_wp_links");
vc_remove_element("vc_wp_categories");
vc_remove_element("vc_wp_archives");
vc_remove_element("vc_wp_rss");
vc_remove_element("vc_teaser_grid");
vc_remove_element("vc_button");
vc_remove_element("vc_cta_button");
vc_remove_element("vc_cta_button2");
vc_remove_element("vc_message");
vc_remove_element("vc_tour");
vc_remove_element("vc_progress_bar");
vc_remove_element("vc_pie");
vc_remove_element("vc_posts_slider");
vc_remove_element("vc_toggle");
vc_remove_element("vc_images_carousel");
vc_remove_element("vc_posts_grid");
vc_remove_element("vc_carousel");
vc_remove_element("vc_gmaps");
vc_remove_element("vc_cta");
vc_remove_element("vc_round_chart");
vc_remove_element("vc_line_chart");
vc_remove_element("vc_tta_accordion");
vc_remove_element("vc_tta_tour");
vc_remove_element("vc_tta_tabs");
vc_remove_element("vc_section");


/***Remove Grid Elements if disabled ***/

if (!hudson_edge_vc_grid_elements_enabled() && version_compare(hudson_edge_get_vc_version(), '4.4.2') >= 0) {
	vc_remove_element('vc_basic_grid');
	vc_remove_element('vc_media_grid');
	vc_remove_element('vc_masonry_grid');
	vc_remove_element('vc_masonry_media_grid');
	vc_remove_element('vc_icon');
	vc_remove_element('vc_button2');
	vc_remove_element("vc_custom_heading");
	vc_remove_element("vc_btn");
}


/*** Remove unused parameters ***/

if (function_exists('vc_remove_param')) {
	vc_remove_param('vc_single_image', 'css_animation');
	vc_remove_param('vc_single_image', 'title');
	vc_remove_param('vc_gallery', 'title');
	vc_remove_param('vc_column_text', 'css_animation');
	vc_remove_param('vc_row', 'video_bg');
	vc_remove_param('vc_row', 'video_bg_url');
	vc_remove_param('vc_row', 'video_bg_parallax');
	vc_remove_param('vc_row', 'full_height');
	vc_remove_param('vc_row', 'content_placement');
	vc_remove_param('vc_row', 'full_width');
	vc_remove_param('vc_row', 'bg_image');
	vc_remove_param('vc_row', 'bg_color');
	vc_remove_param('vc_row', 'font_color');
	vc_remove_param('vc_row', 'margin_bottom');
	vc_remove_param('vc_row', 'bg_image_repeat');
	vc_remove_param( "vc_row", "css" );
	vc_remove_param( "vc_row_inner", "css" );
	vc_remove_param('vc_tabs', 'interval');
	vc_remove_param('vc_tabs', 'title');
	vc_remove_param('vc_separator', 'style');
	vc_remove_param('vc_separator', 'color');
	vc_remove_param('vc_separator', 'accent_color');
	vc_remove_param('vc_separator', 'el_width');
	vc_remove_param('vc_text_separator', 'style');
	vc_remove_param('vc_text_separator', 'color');
	vc_remove_param('vc_text_separator', 'accent_color');
	vc_remove_param('vc_text_separator', 'el_width');
	vc_remove_param('vc_text_separator', 'title_align');
	vc_remove_param('vc_accordion', 'title');
	vc_remove_param('vc_row', 'gap');
    vc_remove_param('vc_row', 'columns_placement');
    vc_remove_param('vc_row', 'equal_height');
    vc_remove_param('vc_row_inner', 'gap');
    vc_remove_param('vc_row_inner', 'columns_placement');
    vc_remove_param('vc_row_inner', 'equal_height');
    vc_remove_param('vc_row_inner', 'content_placement');
    vc_remove_param('vc_row_inner', 'disable_element');
	vc_remove_param('vc_row', 'disable_element');
	vc_remove_param('vc_row', 'css_animation');


    //remove vc parallax functionality
    vc_remove_param('vc_row', 'parallax');
    vc_remove_param('vc_row', 'parallax_image');
	vc_remove_param('vc_row', 'parallax_speed_video');
	vc_remove_param('vc_row', 'parallax_speed_bg');

	if(version_compare(hudson_edge_get_vc_version(), '4.4.2') >= 0) {
		vc_remove_param('vc_accordion', 'disable_keyboard');
		vc_remove_param('vc_separator', 'align');
		vc_remove_param('vc_separator', 'border_width');
		vc_remove_param('vc_text_separator', 'align');
		vc_remove_param('vc_text_separator', 'border_width');
	}

	if(version_compare(hudson_edge_get_vc_version(), '4.7.4') >= 0) {
		add_action( 'init', 'hudson_edge_remove_vc_image_zoom',11);
		function hudson_edge_remove_vc_image_zoom() {
			//Remove zoom from click action on single image
			$param = WPBMap::getParam( 'vc_single_image', 'onclick' );
			unset($param['value']['Zoom']);
			vc_update_shortcode_param( 'vc_single_image', $param );
		}
		vc_remove_param('vc_text_separator', 'css');
		vc_remove_param('vc_separator', 'css');
	}

}


/*** Remove unused parameters from grid elements ***/

if (function_exists('vc_remove_param') && hudson_edge_vc_grid_elements_enabled() && version_compare(hudson_edge_get_vc_version(), '4.4.2') >= 0) {
	vc_remove_param('vc_basic_grid', 'button_style');
	vc_remove_param('vc_basic_grid', 'button_color');
	vc_remove_param('vc_basic_grid', 'button_size');
	vc_remove_param('vc_basic_grid', 'filter_color');
	vc_remove_param('vc_basic_grid', 'filter_style');
	vc_remove_param('vc_media_grid', 'button_style');
	vc_remove_param('vc_media_grid', 'button_color');
	vc_remove_param('vc_media_grid', 'button_size');
	vc_remove_param('vc_media_grid', 'filter_color');
	vc_remove_param('vc_media_grid', 'filter_style');
	vc_remove_param('vc_masonry_grid', 'button_style');
	vc_remove_param('vc_masonry_grid', 'button_color');
	vc_remove_param('vc_masonry_grid', 'button_size');
	vc_remove_param('vc_masonry_grid', 'filter_color');
	vc_remove_param('vc_masonry_grid', 'filter_style');
	vc_remove_param('vc_masonry_media_grid', 'button_style');
	vc_remove_param('vc_masonry_media_grid', 'button_color');
	vc_remove_param('vc_masonry_media_grid', 'button_size');
	vc_remove_param('vc_masonry_media_grid', 'filter_color');
	vc_remove_param('vc_masonry_media_grid', 'filter_style');
	vc_remove_param('vc_basic_grid', 'paging_color');
	vc_remove_param('vc_basic_grid', 'arrows_color');
	vc_remove_param('vc_media_grid', 'paging_color');
	vc_remove_param('vc_media_grid', 'arrows_color');
	vc_remove_param('vc_masonry_grid', 'paging_color');
	vc_remove_param('vc_masonry_grid', 'arrows_color');
	vc_remove_param('vc_masonry_media_grid', 'paging_color');
	vc_remove_param('vc_masonry_media_grid', 'arrows_color');
}


/*** Remove frontend editor ***/

// if(function_exists('vc_disable_frontend')){
// 	vc_disable_frontend();
// }

$animations = array(
	esc_html__( "No animations", 'hudson' ) => "",
	esc_html__( "Elements Shows From Left Side", 'hudson' ) => "element_from_left",
	esc_html__( "Elements Shows From Right Side", 'hudson' ) => "element_from_right",
	esc_html__( "Elements Shows From Top Side", 'hudson' ) => "element_from_top",
	esc_html__( "Elements Shows From Bottom Side", 'hudson' ) => "element_from_bottom",
	esc_html__( "Elements Shows From Fade", 'hudson' ) => "element_from_fade"
);
$font_weight_array = array(
	esc_html__( "Default", 'hudson' ) => "",
	esc_html__( "Thin 100", 'hudson' ) => "100",
	esc_html__( "Extra-Light 200", 'hudson' ) => "200",
	esc_html__( "Light 300", 'hudson' ) => "300",
	esc_html__( "Regular 400", 'hudson' ) => "400",
	esc_html__( "Medium 500", 'hudson' ) => "500",
	esc_html__( "Semi-Bold 600", 'hudson' ) => "600",
	esc_html__( "Bold 700", 'hudson' ) => "700",
	esc_html__( "Extra-Bold 800", 'hudson' ) => "800",
	esc_html__( "Ultra-Bold 900", 'hudson' ) => "900"
);
$social_icons_array = array(
	"" => "",
	"ADN" => "fa-adn",
	"Android" => "fa-android",
	"Apple" => "fa-apple",
	"Bitbucket" => "fa-bitbucket",
	"Bitbucket-Sign" => "fa-bitbucket-sign",
	"Bitcoin" => "fa-bitcoin",
	"BTC" => "fa-btc",
	"CSS3" => "fa-css3",
	"Dribbble" => "fa-dribbble",
	"Dropbox" => "fa-dropbox",
	"Facebook" => "fa-facebook",
	"Facebook-Sign" => "fa-facebook-sign",
	"Flickr" => "fa-flickr",
	"Foursquare" => "fa-foursquare",
	"GitHub" => "fa-github",
	"GitHub-Alt" => "fa-github-alt",
	"GitHub-Sign" => "fa-github-sign",
	"Gittip" => "fa-gittip",
	"Google Plus" => "fa-google-plus",
	"Google Plus-Sign" => "fa-google-plus-sign",
	"HTML5" => "fa-html5",
	"Instagram" => "fa-instagram",
	"LinkedIn" => "fa-linkedin",
	"LinkedIn-Sign" => "fa-linkedin-sign",
	"Linux" => "fa-linux",
	"MaxCDN" => "fa-maxcdn",
	"Paypal" => "fa-paypal",
	"Pinterest" => "fa-pinterest",
	"Pinterest-Sign" => "fa-pinterest-sign",
	"Renren" => "fa-renren",
	"Skype" => "fa-skype",
	"StackExchange" => "fa-stackexchange",
	"Trello" => "fa-trello",
	"Tumblr" => "fa-tumblr",
	"Tumblr-Sign" => "fa-tumblr-sign",
	"Twitter" => "fa-twitter",
	"Twitter-Sign" => "fa-twitter-sign",
	"VK" => "fa-vk",
	"Weibo" => "fa-weibo",
	"Windows" => "fa-windows",
	"Xing" => "fa-xing",
	"Xing-Sign" => "fa-xing-sign",
	"YouTube" => "fa-youtube",
	"YouTube Play" => "fa-youtube-play",
	"YouTube-Sign" => "fa-youtube-sign"
);

/*** Accordion ***/

vc_add_param("vc_accordion", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Style", 'hudson' ),
	"param_name" => "style",
	"value" => array(
		esc_html__( "Accordion", 'hudson' ) => "accordion",
		esc_html__( "Toggle", 'hudson' ) => "toggle",
        esc_html__( "Boxed Accordion", 'hudson' ) => "boxed_accordion",
        esc_html__( "Boxed Toggle", 'hudson' ) => "boxed_toggle"
	),
	"save_always" => true,
	"description" => ""
));

vc_add_param("vc_accordion", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Accordion Title Border Radius", 'hudson' ),
	"param_name" => "accordion_section_border_radius",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "style", 'value' => array('boxed_accordion', 'boxed_toggle'))
));

vc_add_param("vc_accordion", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Accordion Mark Border Radius", 'hudson' ),
	"param_name" => "accordion_border_radius",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "style", 'value' => array('accordion', 'toggle'))
));

vc_add_param("vc_accordion", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Accordion Title Height", 'hudson' ),
	"param_name" => "accordion_section_height",
	"value" => "",
	"description" => ""
));

vc_add_param("vc_accordion", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Hide Icon", 'hudson' ),
	"param_name" => "hide_icon",
	"value" => array(
		esc_html__( "Yes", 'hudson' ) => "yes",
		esc_html__( "No", 'hudson' ) => "no"),
	"save_always" => true,
	"description" => ""
));
vc_add_param("vc_accordion", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Title Alignment", 'hudson' ),
	"param_name" => "title_alignment",
	"value" => array(
		"" => "",
		esc_html__( "Left", 'hudson' ) => "left",
		esc_html__( "Right", 'hudson' ) => "right",
		esc_html__( "Center", 'hudson' ) => "center",
		),
	"description" => "",
	"dependency" => Array('element' => "hide_icon", 'value' => "yes")
));

vc_add_param("vc_accordion", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Title and Icon Alignment", 'hudson' ),
	"param_name" => "title_icon_alignment",
	"value" => array(
		"" => "",
		esc_html__( "Icon on Left", 'hudson' ) => "icon_left",
		esc_html__( "Text on Left", 'hudson' ) => "text_left"
		),
	"description" => esc_html__( "This option is only used for boxed accordions.", 'hudson' ),
	"dependency" => Array('element' => "hide_icon", 'value' => "no")
));

vc_add_param("vc_accordion_tab", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Title Color", 'hudson' ),
	"param_name" => "title_color",
	"value" => "",
	"description" => ""
));

vc_add_param("vc_accordion_tab", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Title Hover Color", 'hudson' ),
	"param_name" => "title_hover_color",
	"value" => "",
	"description" => ""
));

vc_add_param("vc_accordion_tab", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Mark Icon Color", 'hudson' ),
	"param_name" => "mark_icon_color",
	"value" => "",
	"description" => ""
));

vc_add_param("vc_accordion_tab", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Mark Icon Hover Color", 'hudson' ),
	"param_name" => "mark_icon_color_hover",
	"value" => "",
	"description" => ""
));

vc_add_param("vc_accordion_tab", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Title Background Color", 'hudson' ),
	"param_name" => "background_color",
	"value" => "",
	"description" => esc_html__( "This option is only used for boxed accordions", 'hudson' )
));

vc_add_param("vc_accordion_tab", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Title Background Hover Color", 'hudson' ),
	"param_name" => "background_hover_color",
	"value" => "",
	"description" => esc_html__( "This option is only used for boxed accordions", 'hudson' )
));

vc_add_param("vc_accordion_tab", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Title Border Color", 'hudson' ),
	"param_name" => "border_color",
	"value" => "",
	"description" => esc_html__( "This option is only used for boxed accordions", 'hudson' )
));

vc_add_param("vc_accordion_tab", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Title Border Hover Color", 'hudson' ),
	"param_name" => "border_hover_color",
	"value" => "",
	"description" => esc_html__( "This option is only used for boxed accordions", 'hudson' )
));

vc_add_param("vc_accordion_tab", array(
	"type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Title Tag", 'hudson' ),
    "param_name" => "title_tag",
    "value" => array(
        ""   => "",
		"p"  => "p",
        "h2" => "h2",
        "h3" => "h3",
        "h4" => "h4",	
        "h5" => "h5",
        "h6" => "h6",
    ),
    "description" => ""
));


/*** Tabs ***/

vc_add_param("vc_tabs", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Style", 'hudson' ),
	"param_name" => "style",
	"value" => array(
		esc_html__( "Horizontal Center", 'hudson' ) => "horizontal",
		esc_html__( "Horizontal Center With Icons", 'hudson' ) => "horizontal_with_icons",
		esc_html__( "Horizontal Center With Text And Icons", 'hudson' ) => "horizontal_with_text_and_icons",
		esc_html__( "Horizontal Left", 'hudson' ) => "horizontal_left",
		esc_html__( "Horizontal Left With Icons", 'hudson' ) => "horizontal_left_with_icons",
		esc_html__( "Horizontal Left With Text And Icons", 'hudson' ) => "horizontal_left_with_text_and_icons",
		esc_html__( "Horizontal Right", 'hudson' ) => "horizontal_right",
		esc_html__( "Horizontal Right With Icons", 'hudson' ) => "horizontal_right_with_icons",
		esc_html__( "Horizontal Right With Text And Icons", 'hudson' ) => "horizontal_right_with_text_and_icons",
		esc_html__( "Vertical Left", 'hudson' ) => "vertical_left",
		esc_html__( "Vertical Left With Icons", 'hudson' ) => "vertical_left_with_icons",
        esc_html__( "Vertical Left With Text and Icons", 'hudson' ) => "vertical_left_with_text_and_icons",
		esc_html__( "Vertical Right", 'hudson' ) => "vertical_right",
        esc_html__( "Vertical Right With Icons", 'hudson' ) => "vertical_right_with_icons",
        esc_html__( "Vertical Right With Text and Icons", 'hudson' ) => "vertical_right_with_text_and_icons",
	),
	"save_always" => true,
	"description" => ""
));

vc_add_param("vc_tabs", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Tab Type", 'hudson' ),
	"param_name" => "tab_type_default",
	"value" => array(
		esc_html__( "Default", 'hudson' ) => "default",
		esc_html__( "With Borders", 'hudson' ) => "with_borders"
	),
	"save_always" => true,
	"dependency" => Array('element' => "style", 'value' => array('horizontal','horizontal_left','horizontal_right', 'vertical_left', 'vertical_right','horizontal_with_text_and_icons','horizontal_left_with_text_and_icons','horizontal_right_with_text_and_icons','vertical_left_with_text_and_icons','vertical_right_with_text_and_icons'))
));

vc_add_param("vc_tabs", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Tab Type", 'hudson' ),
	"param_name" => "tab_type_icons",
	"value" => array(
		esc_html__( "Default", 'hudson' ) => "default",
		esc_html__( "With Borders", 'hudson' ) => "with_borders",
		esc_html__( "With Lines", 'hudson' ) => "with_lines"
	),
	"save_always" => true,
	"dependency" => Array('element' => "style", 'value' => array('horizontal_with_icons','horizontal_left_with_icons','horizontal_right_with_icons', 'vertical_left_with_icons', 'vertical_right_with_icons'))
));

vc_add_param("vc_tabs", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Border Type", 'hudson' ),
	"param_name" => "border_type_default",
	"value" => array(
		esc_html__( "Border Arround Tabs", 'hudson' ) => "border_arround_element",
		esc_html__( "Border Arround Active Tab", 'hudson' ) => "border_arround_active_tab"
	),
	"save_always" => true,
	"dependency" => Array('element' => "tab_type_default", 'value' => array('with_borders'))
));

vc_add_param("vc_tabs", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Border Type", 'hudson' ),
	"param_name" => "border_type_icons",
	"value" => array(
		esc_html__( "Border Around Tabs", 'hudson' ) => "border_arround_element",
		esc_html__( "Border Around Active Tab", 'hudson' ) => "border_arround_active_tab"
	),
	"save_always" => true,
	"dependency" => Array('element' => "tab_type_icons", 'value' => array('with_borders'))
));

vc_add_param("vc_tabs", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Margin Between Tabs", 'hudson' ),
	"param_name" => "margin_between_tabs",
	"value" => array(
		esc_html__( "Yes", 'hudson' ) => "enable_margin",
		esc_html__( "No", 'hudson' ) => "disable_margin"
	),
	"save_always" => true,
	"description" => "",
    "dependency" => Array('element' => "tab_type_default", 'value' => array('with_borders'))
));

vc_add_param("vc_tabs", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Margin Between Tabs", 'hudson' ),
	"param_name" => "icons_margin_between_tabs",
	"value" => array(
		esc_html__( "Yes", 'hudson' ) => "enable_margin",
		esc_html__( "No", 'hudson' ) => "disable_margin"
	),
	"save_always" => true,
	"description" => "",
	"dependency" => Array('element' => "border_type_icons", 'value' => array('border_arround_element'))
));

vc_add_param("vc_tabs", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Enable Pattern Stripe", 'hudson' ),
	"param_name" => "pattern_stripe",
	"value" => array(
		esc_html__( "No", 'hudson' ) => "no",
		esc_html__( "Yes", 'hudson' ) => "yes"
	),
	"save_always" => true,
	"description" => "",
	"dependency" => Array('element' => "style", 'value' => array('horizontal', 'horizontal_left', 'horizontal_right'))
));

vc_add_param("vc_tabs",  array(
        "type" => "attach_image",
        "holder" => "div",
        "heading" => esc_html__( "Pattern Image", 'hudson' ),
        "param_name" => "pattern_image",
        "value" => "",
        "description" => "",
		"dependency" => Array('element' => "pattern_stripe", 'value' => 'yes')
    )
);

vc_add_param("vc_tabs", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Space Between Tab and Content (px)", 'hudson' ),
    "param_name" => "space_between_tab_and_content",
    "value" => "",
    "description" => esc_html__( "Insert value for space between Tab and Content (default value is 18px)", 'hudson' ),
    "dependency" => Array('element' => "style", 'value' => array('horizontal_with_icons','horizontal_left_with_icons','horizontal_right_with_icons','horizontal','horizontal_left','horizontal_right','horizontal_with_text_and_icons','horizontal_left_with_text_and_icons','horizontal_right_with_text_and_icons','vertical_left_with_text_and_icons','vertical_right_with_text_and_icons'))
));


vc_add_param("vc_tabs", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Border Radius (px)", 'hudson' ),
    "param_name" => "tab_border_radius",
    "value" => "",
    "description" => ""    
));

vc_add_param("vc_tabs", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Icon Position", 'hudson' ),
    "param_name" => "tab_icon_position",
    "value" => array(
        esc_html__( "Left", 'hudson' ) => "left",
        esc_html__( "Right", 'hudson' ) => "right"
    ),
	"save_always" => true,
    "dependency" => Array('element' => "style", 'value' => array('horizontal_with_text_and_icons','horizontal_left_with_text_and_icons','horizontal_right_with_text_and_icons','vertical_left_with_text_and_icons','vertical_right_with_text_and_icons'))
));

vc_add_param("vc_tab", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Icon Pack", 'hudson' ),
    "param_name" => $hudson_edge_icon_collections->iconPackParamName,
    "value" => $hudson_edge_icon_collections->getIconCollectionsVC()
));

foreach ($hudson_edge_icon_collections->iconCollections as $collection_key => $collection ) {
    vc_add_param("vc_tab", array(
        "type" => "dropdown",
        "class" => "",
        "heading" => esc_html__( "Icon", 'hudson' ),
        "param_name" => $collection->param,
        "value" => $collection->getIconsArray(),
        "dependency" => Array('element' => $hudson_edge_icon_collections->iconPackParamName, 'value' => array($collection_key))
    ));
}


/*** Flickr Widget ***/

vc_add_param("vc_flickr", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Columns", 'hudson' ),
    "param_name" => "columns",
    "value" => array(
        esc_html__( "Two", 'hudson' ) => "two",
        esc_html__( "Three", 'hudson' ) => "three",
        esc_html__( "Four", 'hudson' ) => "four"
    ),
	"save_always" => true,
    "description" => ""
));


/*** Empty Space ***/

vc_add_param("vc_empty_space",  array(
        "type" => "attach_image",
        "holder" => "div",
        'heading' => esc_html__( 'Background Image', 'hudson' ),
        'param_name' => 'background_image',
        'value' => '',
        'description' => esc_html__( 'Select image from media library.', 'hudson' )
    )
);
vc_add_param("vc_empty_space",  array(
        "type" => "dropdown",
        'heading' => esc_html__( 'Image Repeat', 'hudson' ),
        'param_name' => 'image_repeat',
        "value" => array(
            esc_html__( 'No Repeat', 'hudson' ) => 'no-repeat',
            esc_html__( 'Repeat x', 'hudson' ) => 'repeat-x',
            esc_html__( 'Repeat y', 'hudson' ) => 'repeat-y',
            esc_html__( 'Repeat (x y)', 'hudson' ) => 'repeat'
        ),
		"save_always" => true,
        'description' =>( '')
    )
);

/*** Gallery ***/

vc_add_param("vc_gallery", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Column Number", 'hudson' ),
	"param_name" => "column_number",
	 "value" => array(2, 3, 4, 5, "Disable" => 0),
	 "save_always" => true,
	 "dependency" => Array('element' => "type", 'value' => array('image_grid'))
));

vc_add_param("vc_gallery", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Grayscale Images", 'hudson' ),
    "param_name" => "grayscale",
    "value" => array(
        esc_html__( 'No', 'hudson' ) => 'no',
        esc_html__( 'Yes', 'hudson' ) => 'yes'),
	"save_always" => true,
    "dependency" => Array('element' => "type", 'value' => array('image_grid'))
));
vc_add_param("vc_gallery", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Border With Pattern", 'hudson' ),
    "param_name" => "border_pattern",
    "value" => array(
        esc_html__( 'No', 'hudson' ) => '',
        esc_html__( 'Yes', 'hudson' ) => 'yes'
    ),
    "description" => "",
	"save_always" => true,
    "dependency" => Array('element' => "type", 'value' => array('flexslider_fade'))
));

vc_add_param("vc_gallery", array(
    "type" => "attach_image",
    "class" => "",
    "heading" => esc_html__( "Border Pattern Image", 'hudson' ),
    "param_name" => "border_pattern_image",
    "value" => "",
    "description" => "",
    "dependency" => Array('element' => "border_pattern", 'value' => array('yes'))
));

vc_add_param("vc_gallery", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Border Width (px)", 'hudson' ),
    "param_name" => "border_pattern_width",
    "value" => "",
    "description" => "",
    "dependency" => Array('element' => "border_pattern", 'value' => array('yes'))
));

vc_add_param("vc_gallery", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Frame", 'hudson' ),
    "param_name" => "frame",
	"value" => array("Use frame?" => "use_frame"),
	"value" => array(
		'' => '',
		esc_html__( 'Yes', 'hudson' ) => 'use_frame',
		esc_html__( 'No', 'hudson' ) => 'no'
	),
    "description" => "",
    "dependency" => Array('element' => "type", 'value' => array('flexslider_slide'))
));

vc_add_param("vc_gallery", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Choose Frame", 'hudson' ),
	"param_name" => "choose_frame",
	"value" => array(
		esc_html__( 'Default', 'hudson' ) => 'default',
		esc_html__( 'Frame 1', 'hudson' ) => 'frame1',
		esc_html__( 'Frame 2', 'hudson' ) => 'frame2',
		esc_html__( 'Frame 3', 'hudson' ) => 'frame3',
		esc_html__( 'Frame 4', 'hudson' ) => 'frame4'
	),
	"save_always" => true,
	"dependency" => Array('element' => "frame", 'value' => array('use_frame'))
));

vc_add_param("vc_gallery", array(
    "type" => "checkbox",
    "class" => "",
    "heading" => esc_html__( "Show image title?", 'hudson' ),
    "param_name" => "show_image_title",
    "value" => array("Show image title in the bottom of image" => "show_image_title"),
    "description" => "",
    "dependency" => Array('element' => "type", 'value' => array('flexslider_slide', 'flexslider_fade'))
));

vc_add_param("vc_gallery", array(
    "type" => "checkbox",
    "class" => "",
    "heading" => esc_html__( "Disable navigation arrows?", 'hudson' ),
    "param_name" => "disable_navigation_arrows",
    "value" => array("Disable navigation arrows" => "yes"),
    "description" => "",
    "dependency" => Array('element' => "type", 'value' => array('flexslider_slide', 'flexslider_fade'))
));

vc_add_param("vc_gallery", array(
    "type" => "checkbox",
    "class" => "",
    "heading" => esc_html__( "Show navigation controls?", 'hudson' ),
    "param_name" => "show_navigation_controls",
    "value" => array("Show navigation controls" => "yes"),
    "description" => "",
    "dependency" => Array('element' => "type", 'value' => array('flexslider_slide', 'flexslider_fade'))
));

vc_add_param("vc_gallery", array(
    "type" => "dropdown",
    "holder" => "div",
    "class" => "",
    "heading" => esc_html__( "Title Alignment", 'hudson' ),
    "param_name" => "title_alignment",
    "value" => array(
        esc_html__( "Left", 'hudson' ) => "left",
        esc_html__( "Center", 'hudson' ) => "center",
        esc_html__( "Right", 'hudson' ) => "right"
    ),
	"save_always" => true,
    "description" => "",
    "dependency" => Array('element' => "show_image_title", 'value' => array('show_image_title'))
));

vc_add_param("vc_gallery", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Title Font Family", 'hudson' ),
    "param_name" => "title_font_family",
    "value" => "",
    "description" => "",
    "dependency" => Array('element' => "show_image_title", 'value' => array('show_image_title'))
));

vc_add_param("vc_gallery", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Title Font Size (px)", 'hudson' ),
    "param_name" => "title_font_size",
    "value" => "",
    "description" => "",
    "dependency" => Array('element' => "show_image_title", 'value' => array('show_image_title'))
));

vc_add_param("vc_gallery", array(
    "type" => "dropdown",
    "holder" => "div",
    "class" => "",
    "heading" => esc_html__( "Title Font Weight", 'hudson' ),
    "param_name" => "title_font_weight",
    "value" => array(
        esc_html__( "Default", 'hudson' ) => "",
        esc_html__( "Thin 100", 'hudson' ) => "100",
        esc_html__( "Extra-Light 200", 'hudson' ) => "200",
        esc_html__( "Light 300", 'hudson' ) => "300",
        esc_html__( "Regular 400", 'hudson' ) => "400",
        esc_html__( "Medium 500", 'hudson' ) => "500",
        esc_html__( "Semi-Bold 600", 'hudson' ) => "600",
        esc_html__( "Bold 700", 'hudson' ) => "700",
        esc_html__( "Extra-Bold 800", 'hudson' ) => "800",
        esc_html__( "Ultra-Bold 900", 'hudson' ) => "900"
    ),
    "description" => "",
    "dependency" => Array('element' => "show_image_title", 'value' => array('show_image_title'))
));

vc_add_param("vc_gallery", array(
    "type" => "dropdown",
    "holder" => "div",
    "class" => "",
    "heading" => esc_html__( "Title Font Style", 'hudson' ),
    "param_name" => "title_font_style",
    "value" => array(
        "" 		   => "",
        esc_html__( "Normal", 'hudson' ) => "normal",
        esc_html__( "Italic", 'hudson' ) => "italic"
    ),
    "description" => "",
    "dependency" => Array('element' => "show_image_title", 'value' => array('show_image_title'))
));

vc_add_param("vc_gallery", array(
    "type" => "colorpicker",
    "holder" => "div",
    "class" => "",
    "heading" => esc_html__( "Title Layer Color", 'hudson' ),
    "param_name" => "title_layer_color",
    "value" => "",
    "description" => "",
    "dependency" => Array('element' => "show_image_title", 'value' => array('show_image_title'))
));

vc_add_param("vc_gallery", array(
    "type" => "colorpicker",
    "holder" => "div",
    "class" => "",
    "heading" => esc_html__( "Background hover color", 'hudson' ),
    "param_name" => "background_hover_color",
    "value" => "",
    "description" => "",
    "dependency" => Array('element' => "grayscale", 'value' => array("no"))
));

vc_add_param("vc_gallery", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Choose hover icon", 'hudson' ),
    "param_name" => "hover_icon",
    "value" => array(
        esc_html__( 'None', 'hudson' ) => 'none',
        esc_html__( 'Magnifier', 'hudson' ) => 'magnifier',
        esc_html__( 'Plus', 'hudson' ) => 'plus'),
	"save_always" => true,
    "dependency" => Array('element' => "grayscale", 'value' => array("no"))
));

vc_add_param("vc_gallery", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Spaces between images", 'hudson' ),
    "param_name" => "images_space",
    "value" => array(
        esc_html__( 'No', 'hudson' ) => 'gallery_without_space',
        esc_html__( 'Yes', 'hudson' ) => 'gallery_with_space'),
	"save_always" => true,
    "dependency" => Array('element' => "type", 'value' => array('image_grid'))
));



/*** Row ***/

vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"show_settings_on_create"=>true,
	"heading" => esc_html__( "Row Type", 'hudson' ),
	"param_name" => "row_type",
	"value" => array(
		esc_html__( "Row", 'hudson' ) => "row",
		esc_html__( "Parallax", 'hudson' ) => "parallax",
		esc_html__( "Expandable", 'hudson' ) => "expandable",
		esc_html__( "Content menu", 'hudson' ) => "content_menu"
	),
	"save_always" => true
));

vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"show_settings_on_create"=>true,
	"heading" => esc_html__( "Use Row as Full Screen Section", 'hudson' ),
	"param_name" => "use_row_as_full_screen_section",
	"value" => array(
		esc_html__( "No", 'hudson' ) => "no",
		esc_html__( "Yes", 'hudson' ) => "yes"
	),
	"save_always" => true,
	"description" => esc_html__( "This option works only for Full Screen Sections Template", 'hudson' ),
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Type", 'hudson' ),
	"param_name" => "type",
	"value" => array(
		esc_html__( "Full Width", 'hudson' ) => "full_width",
		esc_html__( "In Grid", 'hudson' ) => "grid"
	),
	"save_always" => true,
	"dependency" => Array('element' => "row_type", 'value' => array('row','parallax','content_menu'))
));

vc_add_param("vc_row", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Header Style", 'hudson' ),
    "param_name" => "header_style",
    "value" => array(
        "" => "",
        esc_html__( "Light", 'hudson' ) => "light",
        esc_html__( "Dark", 'hudson' ) => "dark"
    ),
    "dependency" => Array('element' => "row_type", 'value' => array('row','parallax','expandable'))
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Anchor ID (Example home)", 'hudson' ),
	"param_name" => "anchor",
	"value" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row','parallax','expandable'))
));
vc_add_param("vc_row", array(
	"type" => "checkbox",
	"class" => "",
	"heading" => esc_html__( "Row in content menu", 'hudson' ),
	"value" => array("Use row for content menu?" => "in_content_menu"),
	"param_name" => "in_content_menu",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row','parallax','expandable', 'expandable_with_background'))
));
vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Content menu title", 'hudson' ),
	"value" => "",
	"param_name" => "content_menu_title",
	"description" => "",
	"dependency" => Array('element' => "in_content_menu", 'value' => array('in_content_menu'))
));

vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Content menu icon pack", 'hudson' ),
	"param_name" => $hudson_edge_icon_collections->iconPackParamName,
	"value" => $hudson_edge_icon_collections->getIconCollectionsVC(),
	"description" => "",
	"dependency" => Array('element' => "in_content_menu", 'value' => array('in_content_menu'))
));

foreach($hudson_edge_icon_collections->iconCollections as $collection_key => $collection) {
    vc_add_param("vc_row", array(
        "type" => "dropdown",
        "class" => "",
        "heading" => esc_html__( "Content menu icon", 'hudson' ),
        "param_name" => "content_menu_".$collection->param,
        "value" => $collection->getIconsArray(),
        "description" => "",
        "dependency" => Array('element' => $hudson_edge_icon_collections->iconPackParamName, 'value' => array($collection_key))
    ));
}

vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Text Align", 'hudson' ),
	"param_name" => "text_align",
	"value" => array(
		esc_html__( "Left", 'hudson' ) => "left",
		esc_html__( "Center", 'hudson' ) => "center",
		esc_html__( "Right", 'hudson' ) => "right"
	),
	"save_always" => true,
	"dependency" => Array('element' => "row_type", 'value' => array('row','parallax','expandable'))
));


vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Video background", 'hudson' ),
	"value" => array(
		esc_html__( "No", 'hudson' ) => "",
		esc_html__( "Yes", 'hudson' ) => "show_video"
	),
	"param_name" => "video",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Video overlay", 'hudson' ),
	"value" => array(
		esc_html__( "No", 'hudson' ) => "",
		esc_html__( "Yes", 'hudson' ) => "show_video_overlay"
	),
	"param_name" => "video_overlay",
	"description" => "",
	"dependency" => Array('element' => "video", 'value' => array('show_video'))
));

vc_add_param("vc_row", array(
	"type" => "attach_image",
	"class" => "",
	"heading" => esc_html__( "Video overlay image (pattern)", 'hudson' ),
	"value" => "",
	"param_name" => "video_overlay_image",
	"description" => "",
	"dependency" => Array('element' => "video_overlay", 'value' => array('show_video_overlay'))
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Video background (webm) file url", 'hudson' ),
	"value" => "",
	"param_name" => "video_webm",
	"description" => "",
	"dependency" => Array('element' => "video", 'value' => array('show_video'))
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Video background (mp4) file url", 'hudson' ),
	"value" => "",
	"param_name" => "video_mp4",
	"description" => "",
	"dependency" => Array('element' => "video", 'value' => array('show_video'))
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Video background (ogv) file url", 'hudson' ),
	"value" => "",
	"param_name" => "video_ogv",
	"description" => "",
	"dependency" => Array('element' => "video", 'value' => array('show_video'))
));

vc_add_param("vc_row", array(
	"type" => "attach_image",
	"class" => "",
	"heading" => esc_html__( "Video preview image", 'hudson' ),
	"value" => "",
	"param_name" => "video_image",
	"description" => "",
	"dependency" => Array('element' => "video", 'value' => array('show_video'))
));

vc_add_param("vc_row", array(
	"type" => "attach_image",
	"class" => "",
	"heading" => esc_html__( "Background image", 'hudson' ),
	"value" => "",
	"param_name" => "background_image",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('parallax', 'row','expandable'))
));

vc_add_param("vc_row", array(
	"type" => "checkbox",
	"class" => "",
	"heading" => esc_html__( "Pattern background", 'hudson' ),
	"value" => array("Use background image as pattern?" => "pattern_background"),
	"param_name" => "pattern_background",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Full Screen Height", 'hudson' ),
    "param_name" => "full_screen_section_height",
    "value" => array(
        esc_html__( "No", 'hudson' ) => "no",
        esc_html__( "Yes", 'hudson' ) => "yes"
    ),
	"save_always" => true,
    "dependency" => Array('element' => "row_type", 'value' => array('parallax'))
));

vc_add_param("vc_row", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Vertically Align Content In Middle", 'hudson' ),
    "param_name" => "vertically_align_content_in_middle",
    "value" => array(
        esc_html__( "No", 'hudson' ) => "no",
        esc_html__( "Yes", 'hudson' ) => "yes"
    ),
	"save_always" => true,
    "dependency" => array('element' => 'full_screen_section_height', 'value' => 'yes')
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Section height", 'hudson' ),
	"param_name" => "section_height",
	"value" => "",
	"dependency" => Array('element' => "full_screen_section_height", 'value' => array('no'))
));

vc_add_param("vc_row", array(
	"type" => "checkbox",
	"class" => "",
	"heading" => esc_html__( "Use as box", 'hudson' ),
	"value" => array("Use row as box" => "use_row_as_box" ),
	"param_name" => "use_as_box",
	"description" => '',
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Parallax speed", 'hudson' ),
    "param_name" => "parallax_speed",
    "value" => "",
    "dependency" => Array('element' => "row_type", 'value' => array('parallax'))
));

vc_add_param("vc_row", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Background color", 'hudson' ),
	"param_name" => "background_color",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row','expandable','content_menu'))
));

vc_add_param("vc_row", array(
	"type" => "checkbox",
	"class" => "",
	"heading" => esc_html__( "Show logo", 'hudson' ),
	"value" => array("Show logo in content menu" => "logo_in_content_menu"),
	"param_name" => "logo_in_content_menu",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('content_menu'))
));

vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Custom widget area", 'hudson' ),
	"param_name" => "custom_widget_area",
	"value" => array_merge(array('' => ''), array_flip(hudson_edge_get_custom_sidebars())),
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('content_menu'))
));

vc_add_param("vc_row", array(
	"type" => "checkbox",
	"class" => "",
	"heading" => esc_html__( "Show Border Bottom", 'hudson' ),
	"value" => array("Show border bottom on content menu?" => "yes"),
	"param_name" => "content_menu_border_bottom",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('content_menu'))
));

vc_add_param("vc_row", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Content Menu Border Color", 'hudson' ),
	"param_name" => "content_menu_border_color",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "content_menu_border_bottom", 'value' => array('yes'))
));

vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Content Menu Border Style", 'hudson' ),
	"param_name" => "content_menu_border_style",
	"value" => array(
		esc_html__( "Solid", 'hudson' ) => "solid",
		esc_html__( "Dashed", 'hudson' ) => "dashed",
		esc_html__( "Dotted", 'hudson' ) => "dotted"
		),
	"save_always" => true,
	"description" => "",
	"dependency" => Array('element' => "content_menu_border_bottom", 'value' => array('yes'))
));

vc_add_param("vc_row", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Border Top Color", 'hudson' ),
	"param_name" => "border_top_color",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Border Bottom Color", 'hudson' ),
	"param_name" => "border_color",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Padding", 'hudson' ),
	"value" => "",
	"param_name" => "side_padding",
	"description" => esc_html__( "Padding (left/right in pixels or percentage. Put number and px or %. Ex. 30% or 30px)", 'hudson' ),
	"dependency" => Array('element' => "type", 'value' => array('full_width'))
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
    "heading" => esc_html__( "Padding Top (px)", 'hudson' ),
	"value" => "",
	"param_name" => "padding_top",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
    "heading" => esc_html__( "Padding Bottom (px)", 'hudson' ),
	"value" => "",
	"param_name" => "padding_bottom",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Label Color", 'hudson' ),
	"param_name" => "color",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));

vc_add_param("vc_row", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Label Hover Color", 'hudson' ),
	"param_name" => "hover_color",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "More Label", 'hudson' ),
	"param_name" => "more_button_label",
	"value" =>  "",
	"description" => esc_html__( "Default label is Expand Section", 'hudson' ),
	"dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));

vc_add_param("vc_row", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Less Label", 'hudson' ),
	"param_name" => "less_button_label",
	"value" =>  "",
	"description" => esc_html__( "Default label is Contract Section", 'hudson' ),
	"dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));
vc_add_param("vc_row", array(
    "type" => "checkbox",
    "class" => "",
    "heading" => esc_html__( "Expanded", 'hudson' ),
    "value" => array("Set as expanded section?" => "set_as_expanded" ),
    "param_name" => "set_as_expanded",
    "description" => '',
    "dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));
vc_add_param("vc_row", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Label Position", 'hudson' ),
	"param_name" => "button_position",
	"value" => array(
		"" => "",
		esc_html__( "Left", 'hudson' ) => "left",
		esc_html__( "Right", 'hudson' ) => "right",
		esc_html__( "Center", 'hudson' ) => "center"
	),
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));

vc_add_param("vc_row",  array(
  "type" => "dropdown",
  "heading" => esc_html__( "CSS Animation", 'hudson' ),
  "param_name" => "css_animation",
  "admin_label" => true,
  "value" => $animations,
  "description" => "",
  "dependency" => Array('element' => "row_type", 'value' => array('row'))
  
));

vc_add_param("vc_row",  array(
	"type" => "textfield",
	"heading" => esc_html__( "Transition delay (ms)", 'hudson' ),
	"param_name" => "transition_delay",
	"admin_label" => true,
	"value" => "",
	"description" => "",
	"dependency" => array("element" => "css_animation", "not_empty" => true)
  
));

vc_add_param("vc_row",  array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Box Shadow on Row", 'hudson' ),
    "param_name" => "box_shadow_on_row",
    "value" => array(
        esc_html__( "No", 'hudson' ) => "no",
        esc_html__( "Yes", 'hudson' ) => "yes"
    ),
	"save_always" => true,
    "dependency" => array("element" => "row_type", "value" => array("row")) 
));

vc_add_param("vc_row",  array(
    "type" => "colorpicker",
    "heading" => esc_html__( "Box Shadow Color", 'hudson' ),
    "param_name" => "box_shadow_color",
    "value" => "",
    "description" => "",
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes")
  
));

vc_add_param("vc_row",  array(
    "type" => "textfield",
    "heading" => esc_html__( "Horizontal Offset (px)", 'hudson' ),
    "param_name" => "horizontal_offset",
    "value" => "",
    "description" => esc_html__( "Default value is 1", 'hudson' ),
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes")
));

vc_add_param("vc_row",  array(
    "type" => "textfield",
    "heading" => esc_html__( "Vertical Offset (px)", 'hudson' ),
    "param_name" => "vertical_offset",
    "value" => "",
    "description" => esc_html__( "Default value is 1", 'hudson' ),
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes")
));

vc_add_param("vc_row",  array(
    "type" => "textfield",
    "heading" => esc_html__( "Box Shadow Blur (px)", 'hudson' ),
    "param_name" => "box_shadow_blur",
    "value" => "",
    "description" => esc_html__( "Default value is 1", 'hudson' ),
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes") 
));

vc_add_param("vc_row",  array(
    "type" => "textfield",
    "heading" => esc_html__( "Box Shadow Spread (px)", 'hudson' ),
    "param_name" => "box_shadow_spread",
    "value" => "",
    "description" => esc_html__( "Default value is 1", 'hudson' ),
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes")  
));


/*** Row Inner ***/

vc_add_param("vc_row_inner", array(
	"type" => "dropdown",
	"class" => "",
	"show_settings_on_create"=>true,
	"heading" => esc_html__( "Row Type", 'hudson' ),
	"param_name" => "row_type",
	"value" => array(
		esc_html__( "Row", 'hudson' ) => "row",
		esc_html__( "Parallax", 'hudson' ) => "parallax",
		esc_html__( "Expandable", 'hudson' ) => "expandable"
	),
	"save_always" => true
));

vc_add_param("vc_row_inner", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Type", 'hudson' ),
	"param_name" => "type",
	"value" => array(
		esc_html__( "Full Width", 'hudson' ) => "full_width",
		esc_html__( "In Grid", 'hudson' ) => "grid"
	),
	"save_always" => true,
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row_inner", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Use Row as Full Screen Section Slide", 'hudson' ),
    "param_name" => "use_row_as_full_screen_section_slide",
    "value" => array(
        esc_html__( "No", 'hudson' ) => "no",
        esc_html__( "Yes", 'hudson' ) => "yes"
    ),
	"save_always" => true,
    "description" => esc_html__( "This option works only for Full Screen Sections Template", 'hudson' ),
    "dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row_inner", array(
    "type" => "checkbox",
    "class" => "",
    "heading" => esc_html__( "Use as box", 'hudson' ),
    "value" => array("Use row as box" => "use_row_as_box" ),
    "param_name" => "use_as_box",
    "description" => '',
    "dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row_inner", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Border Radius(px)", 'hudson' ),
	"param_name" => "row_box_border_radius",
	"value" => "",
	"dependency" => Array('element' => "use_as_box", 'value' => array('use_row_as_box'))
));

vc_add_param("vc_row_inner", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Border Width(px)", 'hudson' ),
	"param_name" => "row_box_border_width",
	"value" => "",
	"dependency" => Array('element' => "use_as_box", 'value' => array('use_row_as_box'))
));

vc_add_param("vc_row_inner", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Anchor ID", 'hudson' ),
	"param_name" => "anchor",
	"value" => ""
));

vc_add_param("vc_row_inner", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Text Align", 'hudson' ),
	"param_name" => "text_align",
	"value" => array(
		esc_html__( "Left", 'hudson' ) => "left",
		esc_html__( "Center", 'hudson' ) => "center",
		esc_html__( "Right", 'hudson' ) => "right"
	),
	"save_always" => true
	
));

vc_add_param("vc_row_inner", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Background color", 'hudson' ),
	"param_name" => "background_color",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row','expandable'))
));

vc_add_param("vc_row_inner", array(
	"type" => "attach_image",
	"class" => "",
	"heading" => esc_html__( "Background image", 'hudson' ),
	"value" => "",
	"param_name" => "background_image",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('parallax', 'row'))
));

vc_add_param("vc_row_inner", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Border color", 'hudson' ),
	"param_name" => "border_color",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row','expandable'))
));

vc_add_param("vc_row_inner", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Padding", 'hudson' ),
	"value" => "",
	"param_name" => "side_padding",
	"description" => esc_html__( "Left and right spacing in pixels", 'hudson' ),
	"dependency" => Array('element' => "type", 'value' => array('full_width'))
));

vc_add_param("vc_row_inner", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Padding Top", 'hudson' ),
	"value" => "",
	"param_name" => "padding_top",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row_inner", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Padding Bottom", 'hudson' ),
	"value" => "",
	"param_name" => "padding_bottom",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
));

vc_add_param("vc_row_inner", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "More Button Label", 'hudson' ),
	"param_name" => "more_button_label",
	"value" =>  "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));

vc_add_param("vc_row_inner", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Less Button Label", 'hudson' ),
	"param_name" => "less_button_label",
	"value" =>  "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));

vc_add_param("vc_row_inner", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Button Position", 'hudson' ),
	"param_name" => "button_position",
	"value" => array(
		"" => "",
		esc_html__( "Left", 'hudson' ) => "left",
		esc_html__( "Right", 'hudson' ) => "right",
		esc_html__( "Center", 'hudson' ) => "center"
	),
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));

vc_add_param("vc_row_inner", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Color", 'hudson' ),
	"param_name" => "color",
	"value" => "",
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('expandable'))
));

vc_add_param("vc_row_inner",  array(
	"type" => "dropdown",
	"heading" => esc_html__( "CSS Animation", 'hudson' ),
	"param_name" => "css_animation",
	"admin_label" => true,
	"value" => $animations,
	"description" => "",
	"dependency" => Array('element' => "row_type", 'value' => array('row'))
  
));

vc_add_param("vc_row_inner",  array(
  "type" => "textfield",
  "heading" => esc_html__( "Transition delay (ms)", 'hudson' ),
  "param_name" => "transition_delay",
  "admin_label" => true,
  "value" => "",
  "description" => "",
  "dependency" => Array('element' => "row_type", 'value' => array('row'))
  
));

vc_add_param("vc_row_inner",  array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Box Shadow on Row", 'hudson' ),
    "param_name" => "box_shadow_on_row",
    "value" => array(
        esc_html__( "No", 'hudson' ) => "no",
        esc_html__( "Yes", 'hudson' ) => "yes"
    ),
	"save_always" => true,
    "dependency" => array("element" => "row_type", "value" => array("row")) 
));

vc_add_param("vc_row_inner",  array(
    "type" => "colorpicker",
    "heading" => esc_html__( "Box Shadow Color", 'hudson' ),
    "param_name" => "box_shadow_color",
    "value" => "",
    "description" => "",
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes")
  
));

vc_add_param("vc_row_inner",  array(
    "type" => "textfield",
    "heading" => esc_html__( "Horizontal Offset (px)", 'hudson' ),
    "param_name" => "horizontal_offset",
    "value" => "",
    "description" => esc_html__( "Default value is 1", 'hudson' ),
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes")
));

vc_add_param("vc_row_inner",  array(
    "type" => "textfield",
    "heading" => esc_html__( "Vertical Offset (px)", 'hudson' ),
    "param_name" => "vertical_offset",
    "value" => "",
    "description" => esc_html__( "Default value is 1", 'hudson' ),
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes")
));

vc_add_param("vc_row_inner",  array(
    "type" => "textfield",
    "heading" => esc_html__( "Box Shadow Blur (px)", 'hudson' ),
    "param_name" => "box_shadow_blur",
    "value" => "",
    "description" => esc_html__( "Default value is 1", 'hudson' ),
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes") 
));

vc_add_param("vc_row_inner",  array(
    "type" => "textfield",
    "heading" => esc_html__( "Box Shadow Spread (px)", 'hudson' ),
    "param_name" => "box_shadow_spread",
    "value" => "",
    "description" => esc_html__( "Default value is 1", 'hudson' ),
    "dependency" => array("element" => "box_shadow_on_row", "value" => "yes")  
));


/*** Separator ***/

$separator_setting = array (
  'show_settings_on_create' => true,
  "controls"	=> '',
);
vc_map_update('vc_separator', $separator_setting);

vc_add_param("vc_separator", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Type", 'hudson' ),
	"param_name" => "type",
	"value" => array(
		esc_html__( "Normal", 'hudson' ) => "normal",
		esc_html__( "Transparent", 'hudson' ) => "transparent",
		esc_html__( "Small", 'hudson' ) => "small",
	),
	"save_always" => true,
	"description" => ""
));

vc_add_param("vc_separator", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Position", 'hudson' ),
	"param_name" => "position",
	"value" => array(
		esc_html__( "Center", 'hudson' ) => "center",
		esc_html__( "Left", 'hudson' ) => "left",
		esc_html__( "Right", 'hudson' ) => "right",
		esc_html__( "Inherit from Elements Holder", 'hudson' ) => "inherit"
	),
	"save_always" => true,
    "dependency" => array("element" => "type", "value" => array("small")),
	"description" => ""
));

vc_add_param("vc_separator", array(
	"type" => "colorpicker",
	"class" => "",
	"heading" => esc_html__( "Color", 'hudson' ),
	"param_name" => "color",
	"value" => "",
	"description" => "",
    "dependency" => array("element" => "type", "value" => array("small", "normal"))
));

vc_add_param("vc_separator", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Border Style", 'hudson' ),
	"param_name" => "border_style",
	"value" => array(
		"" => "",
		esc_html__( "Dashed", 'hudson' ) => "dashed",
		esc_html__( "Solid", 'hudson' ) => "solid",
        esc_html__( "Dotted", 'hudson' ) => "dotted"
    ),
	"description" => ""
));

vc_add_param("vc_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Width (px)", 'hudson' ),
    "param_name" => "width",
    "value" => "",
    "description" => "",
	"dependency" => array("element" => "type", "value" => array("small"))
));

vc_add_param("vc_separator", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Thickness (px)", 'hudson' ),
	"param_name" => "thickness",
	"value" => "",
	"description" => ""
));

vc_add_param("vc_separator", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Top Margin", 'hudson' ),
	"param_name" => "up",
	"value" => "",
	"description" => ""
));

vc_add_param("vc_separator", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Top Margin Measuring Unit", 'hudson' ),
	"param_name" => "up_style",
	"value" => array(
		esc_html__( "Pixels", 'hudson' ) => "px",
		esc_html__( "Percentages", 'hudson' ) => "%",
    ),
	"save_always" => true,
	"description" => ""
));

vc_add_param("vc_separator", array(
	"type" => "textfield",
	"class" => "",
	"heading" => esc_html__( "Bottom Margin", 'hudson' ),
	"param_name" => "down",
	"value" => "",
	"description" => ""
));

vc_add_param("vc_separator", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => esc_html__( "Bottom Margin Measuring Unit", 'hudson' ),
	"param_name" => "down_style",
	"value" => array(
		esc_html__( "Pixels", 'hudson' ) => "px",
		esc_html__( "Percentages", 'hudson' ) => "%",
    ),
	"save_always" => true,
	"description" => ""
));


/*** Separator With Text ***/

vc_add_param("vc_text_separator", array(
    "type" => "colorpicker",
    "class" => "",
    "heading" => esc_html__( "Title Color", 'hudson' ),
    "param_name" => "title_color",
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Title Font size (px)", 'hudson' ),
    "param_name" => 'title_size',
    "value" => "",
    "description" => ""
));

vc_add_param("vc_text_separator", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Text In Box", 'hudson' ),
    "param_name" => "text_in_box",
    "value" => array(
        esc_html__( "Yes", 'hudson' ) => "yes",
        esc_html__( "No", 'hudson' ) => "no"
    ),
	"save_always" => true
));

vc_add_param("vc_text_separator", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Text Position", 'hudson' ),
    "param_name" => "text_position",
    "value" => array(
        esc_html__( "Center", 'hudson' ) => "center",
        esc_html__( "Left", 'hudson' ) => "left",
        esc_html__( "Right", 'hudson' ) => "right"
    ),
	"save_always" => true
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Height (px)", 'hudson' ),
    "param_name" => 'box_height',
    "value" => "",
    "description" => esc_html__( "Insert height for a shape around the text", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Left/right Padding (px)", 'hudson' ),
    "param_name" => 'box_padding',
    "value" => "",
    "description" => esc_html__( "Insert size for a padding on left and right side of text", 'hudson' ),
));

vc_add_param("vc_text_separator", array(
    "type" => "colorpicker",
    "class" => "",
    "heading" => esc_html__( "Box Background Color", 'hudson' ),
    "param_name" => "box_background_color",
    "dependency" => Array('element' => "text_in_box", 'value' => array('yes'))
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "holder" => "div",
    "class" => "",
    "heading" => esc_html__( "Box Border Width (px)", 'hudson' ),
    "param_name" => "box_border_width",
    "value" => "",
    "description" => esc_html__( "Insert width for the separator line", 'hudson' ),
    "dependency" => Array('element' => "text_in_box", 'value' => array('yes'))
));

vc_add_param("vc_text_separator", array(
    "type" => "colorpicker",
    "class" => "",
    "heading" => esc_html__( "Box Border Color", 'hudson' ),
    "param_name" => "box_border_color",
    "dependency" => Array('element' => "text_in_box", 'value' => array('yes'))
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Box Border radius (px)", 'hudson' ),
    "param_name" => "box_border_radius",
    "description" => esc_html__( 'Insert border radius(Rounded corners) in px. For example: 4. Leave empty for default.', 'hudson' ),
    "dependency" => Array('element' => "text_in_box", 'value' => array('yes'))
));

vc_add_param("vc_text_separator", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Box Border Style", 'hudson' ),
    "param_name" => "box_border_style",
    "value" => array(
        esc_html__( "Solid", 'hudson' ) => "solid",
        esc_html__( "Dashed", 'hudson' ) => "dashed",
        esc_html__( "Dotted", 'hudson' ) => "dotted",
        esc_html__( "Transparent", 'hudson' ) => "transparent"
    ),
	"save_always" => true,
    "description" => esc_html__( "Choose a style for the separator line", 'hudson' ),
    "dependency" => Array('element' => "text_in_box", 'value' => array('yes'))
));

vc_add_param("vc_text_separator", array(
    "type" => "colorpicker",
    "class" => "",
    "heading" => esc_html__( "Line Color", 'hudson' ),
    "param_name" => "line_color",
    "value" => "",
    "description" => esc_html__( "Choose a color for the separator line", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Line Width (px)", 'hudson' ),
    "param_name" => "line_width",
    "value" => "",
    "description" => esc_html__( "Insert width for the separator line", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Line Thickness (px)", 'hudson' ),
    "param_name" => "line_thickness",
    "value" => "",
    "description" => esc_html__( "Insert thickness for the separator line", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Separator Line Style", 'hudson' ),
    "param_name" => "line_border_style",
    "value" => array(
        esc_html__( "Solid", 'hudson' ) => "solid",
        esc_html__( "Dashed", 'hudson' ) => "dashed",
        esc_html__( "Dotted", 'hudson' ) => "dotted",
        esc_html__( "Transparent", 'hudson' ) => "transparent"
    ),
	"save_always" => true,
    "description" => esc_html__( "Choose a style for the separator line", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Top Margin (px)", 'hudson' ),
    "param_name" => "up",
    "value" => "",
    "description" => esc_html__( "Insert top margin for the separator", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Bottom Margin (px)", 'hudson' ),
    "param_name" => "down",
    "value" => "",
    "description" => esc_html__( "Insert bottom margin for the separator", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Animation", 'hudson' ),
    "param_name" => "animation",
    "value" => array(
        esc_html__( "Default", 'hudson' ) => "",
        esc_html__( "Animate Width", 'hudson' ) => "animate_width"
    ),
    "description" => esc_html__( "Choose animation for separator", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Box Margins (px)", 'hudson' ),
    "param_name" => "box_margin",
    "description" => esc_html__( "Insert left and right line margins", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Dots on line end ", 'hudson' ),
    "param_name" => "line_dots",
    "value" => array(
        esc_html__( "No", 'hudson' ) => "no",
        esc_html__( "Yes", 'hudson' ) => "yes"
    ),
	"save_always" => true,
    "description" => esc_html__( "Insert icons on the end of the border", 'hudson' )
));

vc_add_param("vc_text_separator", array(
    "type" => "colorpicker",
    "class" => "",
    "heading" => esc_html__( "Dots Color", 'hudson' ),
    "param_name" => "line_dots_color",
    "description" => esc_html__( "Insert dots color (default value is #b2b2b2)", 'hudson' ),
    "dependency" => Array('element' => "line_dots", 'value' => array('yes'))
));

vc_add_param("vc_text_separator", array(
    "type" => "textfield",
    "class" => "",
    "heading" => esc_html__( "Dots Size (px)", 'hudson' ),
    "param_name" => "line_dots_size",
    "description" => esc_html__( "Insert dots size", 'hudson' ),
    "dependency" => Array('element' => "line_dots", 'value' => array('yes'))
));


/*** Single Image ***/

vc_add_param("vc_single_image",  array(
	"type" => "dropdown",
	"heading" => esc_html__( "Hover Animation", 'hudson' ),
	"param_name" => "hover_animation",
	"admin_label" => true,
	"value" => array(
	    esc_html__( "No", 'hudson' ) => 'no',
        esc_html__( "Yes", 'hudson' ) => 'yes'),
	"save_always" => true,
	"description" => "" 
));

vc_add_param("vc_single_image",array(
		"type" => "colorpicker",
		"class" => "",
		"heading" => esc_html__( "Overlay Hover Color", 'hudson' ),
		"param_name" => "overlay_image_color",
		"value" => "",
		"description" => esc_html__( "Choose color for Hover Image Overlay", 'hudson' ),
		"dependency" => array('element' => "hover_animation", 'value' => 'yes')
	));

vc_add_param("vc_single_image",  array(
	"type" => "dropdown",
	"heading" => esc_html__( "Show Border", 'hudson' ),
	"param_name" => "show_border",
	"admin_label" => true,
	"value" => array(
	    esc_html__( "No", 'hudson' ) => 'no',
        esc_html__( "Yes", 'hudson' ) => 'yes'),
	"save_always" => true,
	"description" => "",
	"dependency" => array('element' => "hover_animation", 'value' => 'yes')
));

vc_add_param("vc_single_image",  array(
    "type" => "dropdown",
    "class" => "",
    "heading" => esc_html__( "Border Animation", 'hudson' ),
    "admin_label" => true,
    "param_name" => "border_hover_animation",
    "value" => array(
    	esc_html__( "Scale Line", 'hudson' ) => "edgt_box_scale_line",
        esc_html__( "Simultaneous Line", 'hudson' ) => "edgt_box_simultaneous_line",
        esc_html__( "Continue Line", 'hudson' ) => "edgt_box_continue_line",
        esc_html__( "Corner Line", 'hudson' ) => "edgt_box_corner_line",
    ),
	"save_always" => true,
    "description" => esc_html__( 'Choose Animation for Border Hover', 'hudson' ),
    "dependency" => array('element' => "show_border", 'value' => 'yes')
));

vc_add_param("vc_single_image",array(
		"type" => "colorpicker",
		"class" => "",
		"heading" => esc_html__( "Border Color", 'hudson' ),
		"param_name" => "animated_border_color",
		"value" => "",
		"description" => esc_html__( "Choose color for Animated Border", 'hudson' ),
		"dependency" => array('element' => "show_border", 'value' => 'yes')
	));

vc_add_param("vc_single_image",  array(
	"type" => "textfield",
	"heading" => esc_html__( "Inner Border Top/Bottom Offset (%)", 'hudson' ),
	"param_name" => "inner_border_offset",
	"admin_label" => true,
	"value" => "",
	"description" => "",
	"dependency" => array('element' => "show_border", 'value' => 'yes')
));

vc_add_param("vc_single_image",  array(
	"type" => "textfield",
	"heading" => esc_html__( "Inner Border Left/Right Offset (%)", 'hudson' ),
	"param_name" => "inner_border_lr_offset",
	"admin_label" => true,
	"value" => "",
	"description" => "",
	"dependency" => array('element' => "show_border", 'value' => 'yes')
));

vc_add_param("vc_single_image",  array(
	"type" => "dropdown",
	"heading" => esc_html__( "CSS Animation", 'hudson' ),
	"param_name" => "edgt_css_animation",
	"admin_label" => true,
	"value" => $animations,
	"description" => "" 
));

vc_add_param("vc_single_image",  array(
	"type" => "textfield",
	"heading" => esc_html__( "Transition delay (s)", 'hudson' ),
	"param_name" => "transition_delay",
	"admin_label" => true,
	"value" => "",
	"description" => "",
	"dependency" => array("element" => "edgt_css_animation", "not_empty" => true)
));

//function edgt_add_open_prettyphoto() {
//    //Get current values stored in the Link Target in "Single Image" element
//    $param = WPBMap::getParam('vc_single_image', 'img_link_target');
//    //Append new value to the 'value' array
//    $param['value'][esc_html__('Open prettyPhoto', 'hudson')] = 'open_prettyphoto';
//    //Finally "mutate" param with new values
//    WPBMap::mutateParam('vc_single_image', $param);
//}
//add_action('vc_after_init', 'edgt_add_open_prettyphoto',11);



/*************************************
 	Mapping Shortcodes
 *************************************/


/*** Elements Holder ***/

class WPBakeryShortCode_No_Elements_Holder  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" =>  esc_html__( 'Elements Holder', 'hudson' ),
	"base" => "no_elements_holder",
	"as_parent" => array('only' => 'no_elements_holder_item'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-elements-holder extended-custom-icon",
	"show_settings_on_create" => true,
	"js_view" => 'VcColumnView',
	"params" => array(
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background Color", 'hudson' ),
			"param_name" => "background_color",
			"value" => "",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Columns", 'hudson' ),
			"param_name" => "number_of_columns",
			"value" => array(
				esc_html__( "1 Column", 'hudson' ) => "one_column",
				esc_html__( "2 Columns", 'hudson' ) => "two_columns",
				esc_html__( "2 Columns(66%+33%)", 'hudson' ) => "two_columns grid_66_33",
				esc_html__( "2 Columns(33%+66%)", 'hudson' ) => "two_columns grid_33_66",
				esc_html__( "3 Columns", 'hudson' ) => "three_columns",
				esc_html__( "4 Columns", 'hudson' ) => "four_columns",
				esc_html__( "5 Columns", 'hudson' ) => "five_columns",
				esc_html__( "6 Columns", 'hudson' ) => "six_columns"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "checkbox",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Items Float Left", 'hudson' ),
			"param_name" => "items_float_left",
			"value" => array("Make Items Float Left?" => "yes"),
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"group" => esc_html__( "Width & Responsiveness", 'hudson' ),
			"heading" => esc_html__( "Switch to One Column", 'hudson' ),
			"param_name" => "switch_to_one_column",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Below 1300px", 'hudson' ) => "1300",
				esc_html__( "Below 1000px", 'hudson' ) => "1000",
				esc_html__( "Below 768px", 'hudson' ) => "768",
				esc_html__( "Below 600px", 'hudson' ) => "600",
				esc_html__( "Below 480px", 'hudson' ) => "480",
				esc_html__( "Never", 'hudson' ) => "never"
			),
			"description" => esc_html__( "Choose on which stage item will be in one column", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"group" => esc_html__( "Width & Responsiveness", 'hudson' ),
			"heading" => esc_html__( "Choose Alignment In Responsive Mode", 'hudson' ),
			"param_name" => "alignment_one_column",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Left", 'hudson' ) => "left",
				esc_html__( "Center", 'hudson' ) => "center",
				esc_html__( "Right", 'hudson' ) => "right"
			),
			"description" => esc_html__( "Alignment When Items are in One Column", 'hudson' )
		)
	)
) );


/*** Elements Holder Item ***/

class WPBakeryShortCode_No_Elements_Holder_Item  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" =>  esc_html__( 'Elements Holder Item', 'hudson' ),
	"base" => "no_elements_holder_item",
	"as_parent" => array('except' => 'vc_accordion, no_cover_boxes, no_portfolio_list, no_portfolio_slider'),
	"as_child" => array('only' => 'no_elements_holder'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-elements-holder-item extended-custom-icon",
	"show_settings_on_create" => true,
	"js_view" => 'VcColumnView',
	"params" => array(
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background Color", 'hudson' ),
			"param_name" => "background_color",
			"value" => "",
			"description" => ""
		),
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background Image", 'hudson' ),
			"param_name" => "background_image",
			"value" => "",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Padding", 'hudson' ),
			"param_name" => "item_padding",
			"value" => "",
			"description" => esc_html__( "Please insert padding in format 0px 10px 0px 10px", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Alignment", 'hudson' ),
			"param_name" => "aligment",
			"value" => array(
				esc_html__( "Left", 'hudson' ) => "left",
				esc_html__( "Right", 'hudson' ) => "right",
				esc_html__( "Center", 'hudson' ) => "center"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Vertical Alignment", 'hudson' ),
			"param_name" => "vertical_alignment",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Top", 'hudson' ) => "top",
				esc_html__( "Middle", 'hudson' ) => "middle",
				esc_html__( "Bottom", 'hudson' ) => "bottom"
			),
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Animation Name", 'hudson' ),
			"param_name" => "animation_name",
			"value" => array(
				esc_html__( "No Animation", 'hudson' ) => "",
				esc_html__( "Flip In", 'hudson' ) => "flip_in",
				esc_html__( "Grow In", 'hudson' ) => "grow_in",
				esc_html__( "X Rotate", 'hudson' ) => "x_rotate",
				esc_html__( "Z Rotate", 'hudson' ) => "z_rotate",
				esc_html__( "Y Translate", 'hudson' ) => "y_translate",
				esc_html__( "Fade In", 'hudson' ) => "fade_in",
				esc_html__( "Fade In Down", 'hudson' ) => "fade_in_down",
				esc_html__( "Fade In Left X Rotate", 'hudson' ) => "fade_in_left_x_rotate"
			),
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Animation Delay (ms)", 'hudson' ),
			"param_name" => "animation_delay",
			"value" => "",
			"description" => "",
			"dependency" => array('element' => "animation_name", 'value' => array('flip_in', 'grow_in', 'x_rotate','z_rotate','y_translate','fade_in', 'fade_in_down', 'fade_in_left_x_rotate'))
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Advanced Animations", 'hudson' ),
			"param_name" => "advanced_animations",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Animation Start Position", 'hudson' ),
			"param_name" => "start_position",
			"value" => array(
				esc_html__( 'Bottom of Page', 'hudson' ) => 'bottom-top',
				esc_html__( 'Center of Page', 'hudson' ) => 'center'
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array("element" => "advanced_animations", "value" => array("yes"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Start Animation Style", 'hudson' ),
			"param_name" => "start_animation_style",
			"description" => "",
			"dependency" => array("element" => "advanced_animations", "value" => array("yes"))
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Animation End Position", 'hudson' ),
			"param_name" => "end_position",
			"value" => array(
				esc_html__( "Center of Page", 'hudson' ) => "center",
				esc_html__( "Top of Page", 'hudson' ) => "top-bottom"
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array("element" => "advanced_animations", "value" => array("yes"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "End Animation Style", 'hudson' ),
			"param_name" => "end_animation_style",
			"description" => "",
			"dependency" => array("element" => "advanced_animations", "value" => array("yes"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"group" => esc_html__( "Width & Responsiveness", 'hudson' ),
			"heading" => esc_html__( "Padding on screen size between 1300px-1600px", 'hudson' ),
			"param_name" => "item_padding_1300_1600",
			"value" => "",
			"description" => esc_html__( "Please insert padding in format 0px 10px 0px 10px", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"group" => esc_html__( "Width & Responsiveness", 'hudson' ),
			"heading" => esc_html__( "Padding on screen size between 1000px-1300px", 'hudson' ),
			"param_name" => "item_padding_1000_1300",
			"value" => "",
			"description" => esc_html__( "Please insert padding in format 0px 10px 0px 10px", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"group" => esc_html__( "Width & Responsiveness", 'hudson' ),
			"heading" => esc_html__( "Padding on screen size between 768px-1000px", 'hudson' ),
			"param_name" => "item_padding_768_1000",
			"value" => "",
			"description" => esc_html__( "Please insert padding in format 0px 10px 0px 10px", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"group" => esc_html__( "Width & Responsiveness", 'hudson' ),
			"heading" => esc_html__( "Padding on screen size between 600px-768px", 'hudson' ),
			"param_name" => "item_padding_600_768",
			"value" => "",
			"description" => esc_html__( "Please insert padding in format 0px 10px 0px 10px", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"group" => esc_html__( "Width & Responsiveness", 'hudson' ),
			"heading" => esc_html__( "Padding on screen size between 480px-600px", 'hudson' ),
			"param_name" => "item_padding_480_600",
			"value" => "",
			"description" => esc_html__( "Please insert padding in format 0px 10px 0px 10px", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"group" => esc_html__( "Width & Responsiveness", 'hudson' ),
			"heading" => esc_html__( "Padding on Screen Size Bellow 480px", 'hudson' ),
			"param_name" => "item_padding_480",
			"value" => "",
			"description" => esc_html__( "Please insert padding in format 0px 10px 0px 10px", 'hudson' )
		)
	)
) );

/*** Bordered Elements Holder ***/

class WPBakeryShortCode_No_Bordered_Elements_Holder extends WPBakeryShortCodesContainer {}
vc_map( array(
	'name' => esc_html__( 'Bordered Elements Holder', 'hudson' ),
	'base' => 'no_bordered_elements_holder',
	'as_parent' => array('except' => 'vc_row'),
	'content_element' => true,
	'category' => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-bordered-elements-holder-item extended-custom-icon",
	'show_settings_on_create' => true,
	'js_view' => 'VcColumnView',
	'params' => array(
		array(
			'type' => 'dropdown',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Border Animation Type', 'hudson' ),
			'param_name' => 'animation_type',
			'value' => array(
				esc_html__( 'No Animation', 'hudson' ) => '',
				esc_html__( 'Continue Line', 'hudson' ) => 'edgt_box_continue_line',
				esc_html__( 'Corner Line', 'hudson' ) => 'edgt_box_corner_line',
				esc_html__( 'Simultaneous Line', 'hudson' ) => 'edgt_box_simultaneous_line'
			),
			'description' => esc_html__( 'Choose type of animation', 'hudson' )
		),
		array(
			'type' => 'dropdown',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Border Hover Animation', 'hudson' ),
			'param_name' => 'hover_animation',
			'value' => array(
				esc_html__( 'No Animation', 'hudson' ) => '',
				esc_html__( 'Scale In on Hover', 'hudson' ) => 'edgt_box_scale_in'
				),
			'description' => esc_html__( 'Choose type of animation on hover', 'hudson' )
		),
		array(
			'type' => 'colorpicker',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Border Color', 'hudson' ),
			'param_name' => 'border_color',
			'value' => '',
			'description' => ''
		),
		array(
			'type' => 'textfield',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Border Width (px)', 'hudson' ),
			'param_name' => 'border_width',
			'value' => '',
			'description' => ''
		),
		array(
			'type' => 'textfield',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Duration of the Animation (s)', 'hudson' ),
			'param_name' => 'animation_time',
			'value' => '',
			'description' => esc_html__( 'Default is 2 sec', 'hudson' ),
			'dependency' => array('element' => 'animation_type', 'value' => array('edgt_box_continue_line', 'edgt_box_corner_line', 'edgt_box_simultaneous_line'))
		),
		array(
			'type' => 'textfield',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Holder Padding', 'hudson' ),
			'param_name' => 'holder_padding',
			'value' => '',
			'description' => esc_html__( 'Please insert padding in format 0px 10px 0px 10px', 'hudson' )
		)
	)
) );

/*** Ribbon Holder ***/

class WPBakeryShortCode_No_Ribbon_Holder  extends WPBakeryShortCodesContainer {}
vc_map( array(
    "name" =>  esc_html__( 'Ribbon Holder', 'hudson' ),
    "base" => "no_ribbon_holder",
    "as_parent" => array('except' => 'vc_row'),
    "content_element" => true,
    "category" => esc_html__( 'by EDGE', 'hudson' ),
    "icon" => "icon-wpb-ribbon-holder extended-custom-icon",
    "show_settings_on_create" => true,
    "js_view" => 'VcColumnView',
    "params" => array(
        array(
            "type" => "colorpicker",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Background Color", 'hudson' ),
            "param_name" => "background_color",
            "value" => "",
            "description" => ""
        ),
        array(
            "type" => "colorpicker",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Border Color", 'hudson' ),
            "param_name" => "border_color",
            "value" => "",
            "description" => ""
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Padding", 'hudson' ),
            "param_name" => "padding",
            "value" => "",
            "description" => esc_html__( "Please insert padding in format 0px 10px 0px 10px", 'hudson' )
        ),
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Active", 'hudson' ),
            "param_name" => "active",
            "value" => array(
                esc_html__( "No", 'hudson' ) => "no",
                esc_html__( "Yes", 'hudson' ) => "yes"
            ),
			"save_always" => true,
            "description" => esc_html__( "Enabling this option will place tag new on holder", 'hudson' )
        ),
        array(
            "type" => "colorpicker",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Active Text Color", 'hudson' ),
            "param_name" => "active_text_color",
            "value" => "",
            "description" => "",
            'dependency' => array('element' => 'active', 'value' => array('yes'))
        ),
        array(
            "type" => "colorpicker",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Active Background Color", 'hudson' ),
            "param_name" => "active_background_color",
            "value" => "",
            "description" => "",
            'dependency' => array('element' => 'active', 'value' => array('yes'))
        ),
        array(
            "type" => "checkbox",
            "class" => "",
            "heading" => esc_html__( "Animation", 'hudson' ),
            "value" => array("Hide last element" => "yes"),
            "description" => esc_html__( "This option will hide the last element (shortcode) you add to the ribbon holder. The element will appear again on hover.", 'hudson' ),
            "param_name" => "hide_last_element"
        )
    )
) );



/*** Blog List ***/

vc_map( array(
	"name" => esc_html__( "Blog List", 'hudson' ),
	"base" => "no_blog_list",
	"icon" => "icon-wpb-blog-list extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
        array(
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__("Type", 'hudson'),
                "param_name" => "type",
                "value" => array(
                    esc_html__( "Image in left box", 'hudson' ) => "image_in_box",
                    esc_html__( "Boxes", 'hudson' ) => "boxes",
                    esc_html__( "Minimal", 'hudson' ) => "minimal",
                    esc_html__( "Masonry", 'hudson' ) => "masonry"
                ),
				"save_always" => true,
                "description" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Number of Posts", 'hudson' ),
                "param_name" => "number_of_posts",
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'minimal', 'boxes', 'masonry'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Image Size", 'hudson' ),
                "param_name" => "image_size",
                "value" => array(
                    esc_html__( "Original", 'hudson' ) => "original",
                    esc_html__( "Landscape", 'hudson' ) => "landscape",
                    esc_html__( "Square", 'hudson' ) => "square"
                ),
				"save_always" => true,
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('boxes'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Show Thumbnail", 'hudson' ),
                "param_name" => "show_thumbnail",
                "value" => array(
                    esc_html__( "Yes", 'hudson' ) => "yes",
                    esc_html__( "No", 'hudson' ) => "no",
                ),
				"save_always" => true,
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('boxes'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Number of Columns", 'hudson' ),
                "param_name" => "number_of_columns",
                "value" => array(
                    esc_html__( "One", 'hudson' ) => "1",
                    esc_html__( "Two", 'hudson' ) => "2",
                    esc_html__( "Three", 'hudson' ) => "3",
                    esc_html__( "Four", 'hudson' ) => "4"
                ),
				"save_always" => true,
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('boxes'))
            ),

            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Overlay Color", 'hudson' ),
                "param_name" => "overlay_color",
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('boxes','masonry'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Display Overlay Icon", 'hudson' ),
                "param_name" => "overlay_icon",
                "value" => array(
                    esc_html__( "No", 'hudson' ) => "0",
                    esc_html__( "Yes", 'hudson' ) => "1"
                ),
				"save_always" => true,
                "dependency" => Array('element' => "type", 'value' => array('boxes'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Order By", 'hudson' ),
                "param_name" => "order_by",
                "value" => array(
                    esc_html__( "Title", 'hudson' ) => "title",
                    esc_html__( "Date", 'hudson' ) => "date"
                ),
				"save_always" => true,
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal', 'masonry'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Order", 'hudson' ),
                "param_name" => "order",
                "value" => array(
                    esc_html__( "ASC", 'hudson' ) => "ASC",
                    esc_html__( "DESC", 'hudson' ) => "DESC"
                ),
				"save_always" => true,
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal', 'masonry'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Category Slug", 'hudson' ),
                "param_name" => "category",
                "description" => esc_html__( "Leave empty for all or use comma for list", 'hudson' )
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Text length", 'hudson' ),
                "param_name" => "text_length",
                "description" => esc_html__( "Number of characters", 'hudson' )
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__( "Title Tag", 'hudson' ),
                "param_name" => "title_tag",
                "value" => array(
                    ""   => "",
                    "h2" => "h2",
                    "h3" => "h3",
                    "h4" => "h4",
                    "h5" => "h5",
                    "h6" => "h6",
                ),
                "description" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title Size (px)", 'hudson' ),
                "param_name" => "title_size",
                "description" => ""
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title Color", 'hudson' ),
                "param_name" => "title_color",
                "description" => ""
            ),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Enable Pattern", 'hudson' ),
				"param_name" => "enable_pattern",
				"value" => array(
					esc_html__( "Default", 'hudson' ) => "",
					esc_html__( "No", 'hudson' ) => "no",
					esc_html__( "Yes", 'hudson' ) => "yes"
				),
				"description" => esc_html__( "Enable pattern for date and comments/share holders", 'hudson' ),
				"dependency" => array('element' => 'type', 'value' => array('boxes'))
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Pattern", 'hudson' ),
				"param_name" => "pattern",
				"value" => "",
				"description" => "",
				"dependency" => array('element' => 'enable_pattern', 'value' => array('','yes'))
			),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Display excerpt", 'hudson' ),
                "param_name" => "display_excerpt",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Yes", 'hudson' ) => "1",
                    esc_html__( "No", 'hudson' ) => "0"
                ),
                "description" => ''
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Excerpt Color", 'hudson' ),
                "param_name" => "excerpt_color",
                "dependency" => Array('element' => "display_excerpt", 'value' => array('1', ''))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Info Position", 'hudson' ),
                "param_name" => "info_position",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Top", 'hudson' ) => "top",
                    esc_html__( "Bottom", 'hudson' ) => "bottom"
                ),
                "dependency" => array('element' => "type", 'value' => array('image_in_box', 'minimal','boxes'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Post info font size (px)", 'hudson' ),
                "param_name" => "post_info_font_size",
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal'))
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Post info color", 'hudson' ),
                "param_name" => "post_info_color",
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal'))
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Post info link color", 'hudson' ),
                "param_name" => "post_info_link_color",
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Post info font family", 'hudson' ),
                "param_name" => "post_info_font_family",
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Post info text transform", 'hudson' ),
                "param_name" => "post_info_text_transform",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "None", 'hudson' ) => "none",
                    esc_html__( "Capitalize", 'hudson' ) => "capitalize",
                    esc_html__( "Uppercase", 'hudson' ) => "uppercase",
                    esc_html__( "Lowercase", 'hudson' ) => "lowercase"
                ),
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Post info font weight", 'hudson' ),
                "param_name" => "post_info_font_weight",
                "value" => $font_weight_array,
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Post info font style", 'hudson' ),
                "param_name" => "post_info_font_style",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Normal", 'hudson' ) => "normal",
                    esc_html__( "Italic", 'hudson' ) => "italic"
                ),
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Post info letter spacing (px)", 'hudson' ),
                "param_name" => "post_info_letter_spacing",
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Display category", 'hudson' ),
                "param_name" => "display_category",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Yes", 'hudson' ) => "1",
                    esc_html__( "No", 'hudson' ) => "0"
                ),
                "description" => '',
                "dependency" => Array('element' => "type", 'value' => array('image_in_box','boxes','minimal', 'masonry'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Display date", 'hudson' ),
                "param_name" => "display_date",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Yes", 'hudson' ) => "1",
                    esc_html__( "No", 'hudson' ) => "0"
                ),
                "description" => '',
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal', 'masonry'))
            ),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Enable Date Pattern", 'hudson' ),
				"param_name" => "enable_date_pattern",
				"value" => array(
					esc_html__( "Default", 'hudson' ) => "",
					esc_html__( "Yes", 'hudson' ) => "1",
					esc_html__( "No", 'hudson' ) => "0"
					),
				"dependency" => array('element' => "type", 'value' => array('masonry'))
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Date Pattern", 'hudson' ),
				"param_name" => "date_pattern",
				"value" => "",
				"dependency" => array('element' => "enable_date_pattern", 'value' => array('','1'))
			),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Date Position", 'hudson' ),
                "param_name" => "date_place",
                "value" => array(
                	esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Date by Title", 'hudson' ) => "by_title",
                    esc_html__( "Date by Post Info", 'hudson' ) => "by_post_info",
                    esc_html__( "Date over Title", 'hudson' ) => "over_title"
                ),
                "description" => esc_html__( 'Choose where will be date placed', 'hudson' ),
                "dependency" => Array('element' => "type", 'value' => array('boxes','image_in_box'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Date Size (px)", 'hudson' ),
                "param_name" => "date_size",
                "description" => "",
                "dependency" => array('element' => "type", 'value' => array('boxes', 'image_in_box'))
            ),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Day Color", 'hudson' ),
				"param_name" => "day_color",
				"description" => "",
				"dependency" => array('element' => "type", 'value' => array('masonry'))
			),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Display author", 'hudson' ),
                "param_name" => "display_author",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Yes", 'hudson' ) => "1",
                    esc_html__( "No", 'hudson' ) => "0"
                )
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Display comments", 'hudson' ),
                "param_name" => "display_comments",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Yes", 'hudson' ) => "1",
                    esc_html__( "No", 'hudson' ) => "0"
                ),
                "dependency" => Array('element' => "type", 'value' => array('image_in_box','boxes'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Display share", 'hudson' ),
                "param_name" => "display_share",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Yes", 'hudson' ) => "1",
                    esc_html__( "No", 'hudson' ) => "0"
                ),
                "dependency" => Array('element' => "type", 'value' => array('boxes'))
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Box Background Color", 'hudson' ),
                "param_name" => "background_color",
                "dependency" => Array('element' => "type", 'value' => array('boxes', 'image_in_box','masonry'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Box Padding", 'hudson' ),
                "param_name" => "box_info_padding",
                "description" => esc_html__( "Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson' ),
                "dependency" => Array('element' => "type", 'value' => array('boxes', 'image_in_box','masonry'))
            ),array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Border Around Post Info", 'hudson' ),
                "param_name" => "border_around_item",
                "value" => array(
                    esc_html__( "No", 'hudson' ) => "no",
                    esc_html__( "Yes", 'hudson' ) => "yes"
                ),
				"save_always" => true,
                "description" => "",
                "dependency" => Array('element' => "type", 'value' => 'masonry')
            ),array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Border Width", 'hudson' ),
                "param_name" => "item_border_width",
                "description" => "",
                "dependency" => Array('element' => "border_around_item", 'value' => 'yes')
            ),array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Border Color", 'hudson' ),
                "param_name" => "item_border_color",
                "description" => "",
                "dependency" => Array('element' => "border_around_item", 'value' => 'yes')
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Separator Between Item Color", 'hudson' ),
                "param_name" => "border_color",
                "description" => "",
                "dependency" => array('element' => "type", 'value' => array('minimal','image_in_box'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Separator Between Item Thickness (px)", 'hudson' ),
                "param_name" => "border_width",
                "description" => "",
                "dependency" => array('element' => "type", 'value' => array('minimal','image_in_box'))

            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Display Button", 'hudson' ),
                "param_name" => "display_button",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Yes", 'hudson' ) => "1",
                    esc_html__( "No", 'hudson' ) => "0"
                ),
                "description" => esc_html__( "Show button leading to post single page", 'hudson' ),
                "dependency" => Array('element' => "type", 'value' => array('image_in_box', 'boxes', 'minimal'))

            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Size", 'hudson' ),
                "param_name" => "button_size",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "Small", 'hudson' ) => "small",
                    esc_html__( "Medium", 'hudson' ) => "medium",
                    esc_html__( "Large", 'hudson' ) => "large",
                    esc_html__( "Extra Large", 'hudson' ) => "big_large"
                ),
                "description" => esc_html__( "Default value is small", 'hudson' ),
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Style", 'hudson' ),
                "param_name" => "button_style",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "White", 'hudson' ) => "white"
                ),
                "description" => "",
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Text", 'hudson' ),
                "param_name" => "button_text",
                "description" => esc_html__( "Default text is LEARN MORE", 'hudson' ),
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Text Color", 'hudson' ),
                "param_name" => "button_color",
                "description" => "",
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Text Hover Color", 'hudson' ),
                "param_name" => "button_hover_color",
                "description" => "",
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Background Color", 'hudson' ),
                "param_name" => "button_background_color",
                "description" => "",
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Hover Background Color", 'hudson' ),
                "param_name" => "button_hover_background_color",
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Border Color", 'hudson' ),
                "param_name" => "button_border_color",
                "description" => "",
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Border Width", 'hudson' ),
                "param_name" => "button_border_width",
                "description" => "",
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Hover Border Color", 'hudson' ),
                "param_name" => "button_hover_border_color",
                "description" => "",
                "dependency" => array('element' => "display_button", 'value' => '1')
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Border Radius (px)", 'hudson' ),
                "param_name" => "button_border_radius",
                "description" => esc_html__( "Border radius for button", 'hudson' ),
                "dependency" => array('element' => "display_button", 'value' => '1')
            )
        ),
        $hudson_edge_icon_collections->getVCParamsArray( array( 'element' => 'display_button', 'value' => '1' ) ),
        array(
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__( "Icon Position", 'hudson' ),
                "param_name" => "button_icon_position",
                "value" => array(
                    esc_html__( "Right", 'hudson' ) => "right",
                    esc_html__( "Left", 'hudson' ) => "left"
                ),
				"save_always" => true,
                "dependency" => Array('element' => $hudson_edge_icon_collections->iconPackParamName, 'not_empty' => true)
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Icon Color", 'hudson' ),
                "param_name" => "button_icon_color",
                "dependency" => Array('element' =>$hudson_edge_icon_collections->iconPackParamName, 'not_empty' => true)
            )
        )
	)
) );


/*** Blog Carousel ***/

vc_map( array(
	"name" => esc_html__( "Blog Carousel", 'hudson' ),
	"base" => "no_blog_carousel",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-blog-carousel extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Carousel info type", 'hudson' ),
			"param_name" => "type",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Post Info visible", 'hudson' ) => "info_always",
				esc_html__( "Post Info in Bottom", 'hudson' ) => "info_in_bottom"
			),
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Image size", 'hudson' ),
			"param_name" => "image_size",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Original Size", 'hudson' ) => "full",
				esc_html__( "Landscape", 'hudson' ) => "landscape",
				esc_html__( "Portrait", 'hudson' ) => "portrait"
			),
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Order By", 'hudson' ),
			"param_name" => "order_by",
			"value" => array(
				"" => "",
				esc_html__( "Title", 'hudson' ) => "title",
				esc_html__( "Date", 'hudson' ) => "date"
			),
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Order", 'hudson' ),
			"param_name" => "order",
			"value" => array(
				"" => "",
				esc_html__( "ASC", 'hudson' ) => "ASC",
				esc_html__( "DESC", 'hudson' ) => "DESC",
			),
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Number", 'hudson' ),
			"param_name" => "number",
			"value" => "-1",
			"description" => esc_html__( "Number of blog posts on page (-1 is all)", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Number of Blog Posts Shown", 'hudson' ),
			"param_name" => "blogs_shown",
			"value" => array(
				"" => "",
				"3" => "3",
				"4" => "4",
				"5" => "5",
				"6" => "6"
			),
			"description" => esc_html__( "Number of blog posts that are showing at the same time in full width (on smaller screens is responsive so there will be less items shown)", 'hudson' ),
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Category", 'hudson' ),
			"param_name" => "category",
			"value" => "",
			"description" => esc_html__( "Category Slug (leave empty for all)", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Selected Projects", 'hudson' ),
			"param_name" => "selected_projects",
			"value" => "",
			"description" => esc_html__( "Selected Projects (leave empty for all, delimit by comma)", 'hudson' )
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Info Box Background Color", 'hudson' ),
			"param_name" => "hover_box_color",
			"value" => "",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Enable Pattern", 'hudson' ),
			"param_name" => "enable_border_pattern",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
				),
			"save_always" => true,
			"description" => esc_html__( "Enable Pattern in info box", 'hudson' ),
			"dependency" => array('element' => 'type','value' => array('info_in_bottom'))
		),
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border Pattern", 'hudson' ),
			"param_name" => "border_pattern",
			"value" => "",
			"description" => "",
			"dependency" => array('element' => 'enable_border_pattern', 'value' => array('yes'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border Width (px)", 'hudson' ),
			"param_name" => "pattern_width",
			"value" => "",
			"description" => esc_html__( "Default value is 15px", 'hudson' ),
			"dependency" => array('element' => 'enable_border_pattern', 'value' => array('yes'))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Post Info Color", 'hudson' ),
			"param_name" => "post_info_color",
			"value" => "",
			"description" => "",
			"dependency" => array("element" => "type","value" => "info_in_bottom")
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show Author", 'hudson' ),
			"param_name" => "show_author",
			"value" => array(
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => esc_html__( "Default value is Yes", 'hudson' ),
			"dependency" => array("element" => "type", "value" => "info_in_bottom")
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Author Color", 'hudson' ),
			"param_name" => "author_color",
			"value" => "",
			"description" => "",
			"dependency" => array('element' => "show_author", 'value' => array('yes'))
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show Category Names", 'hudson' ),
			"param_name" => "show_categories",
			"value" => array(
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => esc_html__( "Default value is Yes", 'hudson' ),
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Category Name Color", 'hudson' ),
			"param_name" => "category_color",
			"value" => "",
			"description" => "",
			"dependency" => array('element' => "show_categories", 'value' => array('yes'))
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show Date", 'hudson' ),
			"param_name" => "show_date",
			"value" => array(
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => esc_html__( "Default value is Yes", 'hudson' )
		),		
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Date Position", 'hudson' ),
			"param_name" => "date_position",
			"value" => array(
				esc_html__( "Above Title", 'hudson' ) => "above",
				esc_html__( "Below Title", 'hudson' ) => "below"
			),
			"save_always" => true,
			"description" => esc_html__( "Default value is Above", 'hudson' ),
			"dependency" => array('element' => "type",'value' => array('info_always',''))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Date Color", 'hudson' ),
			"param_name" => "date_color",
			"value" => "",
			"description" => "",
			"dependency" => array('element' => "show_date", 'value' => array('yes'))
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Title Tag", 'hudson' ),
			"param_name" => "title_tag",
			"value" => array(
				""   => "",
				"h2" => "h2",
				"h3" => "h3",
				"h4" => "h4",
				"h5" => "h5",
				"h6" => "h6",
			),
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Color", 'hudson' ),
			"param_name" => "title_color",
			"value" => "",
			"description" => ""
		),
		array(
			"type" => "checkbox",
			"class" => "",
			"heading" => esc_html__( "Prev/Next navigation", 'hudson' ),
			"value" => array("Enable prev/next navigation?" => "enable_navigation"),
			"param_name" => "enable_navigation"
		),
		array(
			"type" => "checkbox",
			"class" => "",
			"heading" => esc_html__( "Bullets navigation", 'hudson' ),
			"value" => array("Show bullets navigation?" => "yes"),
			"param_name" => "pager_navigation"
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show Separator", 'hudson' ),
			"param_name" => "show_separator",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => esc_html__( "Show separator below title", 'hudson' ),
			"dependency" => array('element' => 'type', 'value' => array('info_always',''))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Color", 'hudson' ),
			"param_name" => "separator_color",
			"description" => "",
			"dependency" => array('element' => "show_separator", 'value' => array('yes'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Thickness (px)", 'hudson' ),
			"param_name" => "separator_thickness",
			"description" => "",
			"dependency" => array('element' => "show_separator", 'value' => array('yes'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Width (px)", 'hudson' ),
			"param_name" => "separator_width",
			"description" => "",
			"dependency" => array('element' => "show_separator", 'value' => array('yes'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Extra class name", 'hudson' ),
			"param_name" => "add_class",
			"value" => "",
			"description" => esc_html__( "If you wish to style this particular blog carousel differently, you can use this field to add an extra class name to it and then refer to that class name in your css file.", 'hudson' )
		)
	)
) );


/*** Blog Slider***/

vc_map( array(
	"name" => esc_html__( "Blog Slider", 'hudson' ),
	"base" => "no_blog_slider",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-blog-slider extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Order By", 'hudson' ),
			"param_name" => "order_by",
			"value" => array(
				"" => "",
				esc_html__( "Title", 'hudson' ) => "title",
				esc_html__( "Date", 'hudson' ) => "date"
			),
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Order", 'hudson' ),
			"param_name" => "order",
			"value" => array(
				"" => "",
				esc_html__( "ASC", 'hudson' ) => "ASC",
				esc_html__( "DESC", 'hudson' ) => "DESC",
			),
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Number", 'hudson' ),
			"param_name" => "number",
			"value" => "-1",
			"description" => esc_html__( "Number of blog posts on page (-1 is all)", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Title Tag", 'hudson' ),
			"param_name" => "title_tag",
			"value" => array(
				""   => "",
				"h2" => "h2",
				"h3" => "h3",
				"h4" => "h4",
				"h5" => "h5",
				"h6" => "h6",
			),
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Image size", 'hudson' ),
			"param_name" => "image_size",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Original Size", 'hudson' ) => "full",
				esc_html__( "Landscape", 'hudson' ) => "landscape",
				esc_html__( "Portrait", 'hudson' ) => "portrait",
				esc_html__( "Custom Size", 'hudson' ) => "custom"
			),
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Image Width", 'hudson' ),
			"param_name" => "image_width",
			"value" => "",
			"description" => esc_html__( "Set custom image width", 'hudson' ),
			"dependency" => array("element" => "image_size", "value" => array("custom"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Image Height", 'hudson' ),
			"param_name" => "image_height",
			"value" => "",
			"description" => esc_html__( "Set custom image height", 'hudson' ),
			"dependency" => array("element" => "image_size", "value" => array("custom"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Category", 'hudson' ),
			"param_name" => "category",
			"value" => "",
			"description" => esc_html__( "Category Slug (leave empty for all)", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Selected Projects", 'hudson' ),
			"param_name" => "selected_projects",
			"value" => "",
			"description" => esc_html__( "Selected Projects (leave empty for all, delimit by comma)", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show Category", 'hudson' ),
			"param_name" => "show_category",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "default",
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show Author", 'hudson' ),
			"param_name" => "show_author",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "default",
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show Date", 'hudson' ),
			"param_name" => "show_date",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "default",
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show Read More Button", 'hudson' ),
			"param_name" => "show_read_more",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "default",
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => ""
		),
	)
) );

/*** Vertical Split Slider ***/

class WPBakeryShortCode_No_Vertical_Split_Slider  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" =>  esc_html__( 'Edge Vertical Split Slider', 'hudson' ),
	"base" => "no_vertical_split_slider",
	"as_parent" => array('only' => 'no_vertical_left_sliding_panel,no_vertical_right_sliding_panel'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-vertical-split-slider extended-custom-icon",
	"show_settings_on_create" => true,
	"js_view" => 'VcColumnView',
	"params" => array(
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Preloader Background Color", 'hudson' ),
			"param_name" => "background_color",
			"value" => "",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Left Slide Panel size (%)", 'hudson' ),
			"param_name" => "left_slide_panel_size",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Right Slide Panel size (%)", 'hudson' ),
			"param_name" => "right_slide_panel_size",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Disable Dark/Light Header Skin Change", 'hudson' ),
			"param_name" => "disable_header_skin_change",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => ""
		)
	)
) );


/*** Vertical Split Slider Left Panel ***/

class WPBakeryShortCode_No_Vertical_Left_Sliding_Panel  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" =>  esc_html__( 'Left Sliding Panel', 'hudson' ),
	"base" => "no_vertical_left_sliding_panel",
	"as_parent" => array('only' => 'no_vertical_slide_content_item'),
	"as_child" => array('only' => 'no_vertical_split_slider'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-vertical-split-slider-left-panel extended-custom-icon",
	"show_settings_on_create" => false,
	"js_view" => 'VcColumnView',
	'params' => array()
) );


/*** Vertical Split Slider Right Panel ***/

class WPBakeryShortCode_No_Vertical_Right_Sliding_Panel  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" =>  esc_html__( 'Right Sliding Panel', 'hudson' ),
	"base" => "no_vertical_right_sliding_panel",
	"as_parent" => array('only' => 'no_vertical_slide_content_item'),
	"as_child" => array('only' => 'no_vertical_split_slider'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-vertical-split-slider-right-panel extended-custom-icon",
	"show_settings_on_create" => false,
	"js_view" => 'VcColumnView',
	'params' => array()
) );


/*** Vertical Split Slider Content Item ***/

class WPBakeryShortCode_No_Vertical_Slide_Content_Item  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" =>  esc_html__( 'Slide Content Item', 'hudson' ),
	"base" => "no_vertical_slide_content_item",
	"as_parent" => array('except' => 'vc_row, vc_accordion, no_cover_boxes, no_portfolio_list, no_portfolio_slider, no_carousel'),
	"as_child" => array('only' => 'no_vertical_left_sliding_panel, no_vertical_right_sliding_panel'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-vertical-split-slider-content-item extended-custom-icon",
	"show_settings_on_create" => true,
	"js_view" => 'VcColumnView',
	"params" => array(
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background Color", 'hudson' ),
			"param_name" => "background_color",
			"value" => "",
			"description" => ""
		),
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background Image", 'hudson' ),
			"param_name" => "background_image",
			"value" => "",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Padding left/right", 'hudson' ),
			"param_name" => "item_padding",
			"value" => "",
			"description" => esc_html__( "Please insert padding in format 10px", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Content Aligment", 'hudson' ),
			"param_name" => "alignment",
			"value" => array(
				esc_html__( "left", 'hudson' ) => "left",
				esc_html__( "right", 'hudson' ) => "right",
				esc_html__( "center", 'hudson' ) => "center"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Header/Bullets Style", 'hudson' ),
			"param_name" => "header_style",
			"value" => array(
				""	=>	"",
				esc_html__( "Light", 'hudson' ) => "light",
				esc_html__( "Dark", 'hudson' ) => "dark"
			),
			"description" => ""
		)

	)
) );


/*** Image slider ***/

vc_map( array(
	"name" => esc_html__( "Edge Image Slider", 'hudson' ),
	"base" => "no_image_slider_no_space",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-image-slider-no-space extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "attach_images",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Images", 'hudson' ),
			"param_name" => "images"
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "On click", 'hudson' ),
			"param_name" => "on_click",
			"value" => array(
				esc_html__( "Do nothing", 'hudson' ) => "",
				esc_html__( "Open image in prettyphoto", 'hudson' ) => "prettyphoto",
				esc_html__( "Open image in new tab", 'hudson' ) => "new_tab",
				esc_html__( "Use custom links", 'hudson' ) => "use_custom_links"
			),
			"description" => ""
		),
		array(
			"type" => "textarea",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Custom Links", 'hudson' ),
			"param_name" => "custom_links",
			"value" => "",
			"dependency" => array('element' => 'on_click', 'value' => 'use_custom_links'),
			"description" => esc_html__( "Enter links for each image here. Divide links with comma.", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Custom links target", 'hudson' ),
			"param_name" => "custom_links_target",
			"value" => array(
				"" => "",
				esc_html__( "Same window", 'hudson' ) => "_self",
				esc_html__( "New window", 'hudson' ) => "_blank"
			),
			"dependency" => array('element' => 'on_click', 'value' => 'use_custom_links'),
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show info", 'hudson' ),
			"param_name" => "show_info",
			"value" => array(
				"" => "",
				esc_html__( "On Hover", 'hudson' ) => "on_hover",
				esc_html__( "In The Bottom", 'hudson' ) => "in_bottom",
			),
			"description" => esc_html__( "Show image title and description", 'hudson' )
		),		
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background Color", 'hudson' ),
			"param_name" => "background_color",
			"dependency" => array('element' => "show_info", 'value' => array('on_hover','in_bottom'))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Color", 'hudson' ),
			"param_name" => "title_color",
			"dependency" => array('element' => "show_info", 'value' => array('on_hover','in_bottom'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title font size (px)", 'hudson' ),
			"param_name" => "title_font_size",
			"value" => "",
			"dependency" => array('element' => "show_info", 'value' => array('on_hover','in_bottom'))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Description Color", 'hudson' ),
			"param_name" => "description_color",
			"dependency" => array('element' => "show_info", 'value' => array('on_hover','in_bottom'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Description font size (px)", 'hudson' ),
			"param_name" => "description_font_size",
			"value" => "",
			"dependency" => array('element' => "show_info", 'value' => array('on_hover','in_bottom'))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Color", 'hudson' ),
			"param_name" => "separator_color",
			"dependency" => array('element' => "show_info", 'value' => 'on_hover')
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator opacity (0-1)", 'hudson' ),
			"param_name" => "separator_opacity",
			"value" => "",
			"dependency" => array('element' => "show_info", 'value' => 'on_hover')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Full Screen Height", 'hudson' ),
			"param_name" => "full_screen",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Slider height (px)", 'hudson' ),
			"param_name" => "height",
			"value" => "",
			"dependency" => array('element' => 'full_screen', 'value' => 'no')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Navigation style", 'hudson' ),
			"param_name" => "navigation_style",
			"value" => array(
				"" => "",
				esc_html__( "Light", 'hudson' ) => "light",
				esc_html__( "Dark", 'hudson' ) => "dark"
			)
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Highlight Active Image", 'hudson' ),
			"param_name" => "highlight_active_image",
			"value" => array(
				"" => "",
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			)
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Highlight Inactive Color", 'hudson' ),
			"param_name" => "highlight_inactive_color",
			"dependency" => array('element' => "highlight_active_image", 'value' => 'yes')
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Highlight Inactive Opacity (0-1)", 'hudson' ),
			"param_name" => "highlight_inactive_opacity",
			"value" => "",
			"dependency" => array('element' => "highlight_active_image", 'value' => 'yes')
		)
	)
) );


/*** Parallax Layers ***/

vc_map( array(
	"name" => esc_html__( "Parallax Layers", 'hudson' ),
	"base" => "no_parallax_layers",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-parallax-layers extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "attach_images",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Layers", 'hudson' ),
			"param_name" => "images"
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Full Screen Height", 'hudson' ),
			"param_name" => "full_screen",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Height (px)", 'hudson' ),
			"param_name" => "height",
			"value" => "",
			"dependency" => array('element' => 'full_screen', 'value' => 'no')
		),
        array(
            "type" => "textarea_html",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Content", 'hudson' ),
            "param_name" => "content",
            "value" => "",
            "description" => esc_html__( "This content will be displayed as final (top) layer over all other layers", 'hudson' )
        )
	)
) );


/*** Google Map ***/

vc_map( array(
	"name" => esc_html__( "Google Map", 'hudson' ),
	"base" => "no_google_map",
	"icon" => "icon-wpb-google-map extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Address 1", 'hudson' ),
			"param_name" => "address1",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Address 2", 'hudson' ),
			"param_name" => "address2",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Address 3", 'hudson' ),
			"param_name" => "address3",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Address 4", 'hudson' ),
			"param_name" => "address4",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Address 5", 'hudson' ),
			"param_name" => "address5",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Custom Map Style", 'hudson' ),
			"param_name" => "custom_map_style",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "false",
				esc_html__( "Yes", 'hudson' ) => "true"
			),
			"save_always" => true,
			"description" => esc_html__( "Enabling this option will allow Map editing", 'hudson' )
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Color Overlay", 'hudson' ),
			"param_name" => "color_overlay",
			"description" => esc_html__( "Choose a Map color overlay", 'hudson' ),
			"dependency" => Array('element' => "custom_map_style", 'value' => array('true'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Saturation", 'hudson' ),
			"param_name" => "saturation",
			"description" => esc_html__( "Choose a level of saturation (-100 = least saturated, 100 = most saturated)", 'hudson' ),
			"dependency" => Array('element' => "custom_map_style", 'value' => array('true'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Lightness", 'hudson' ),
			"param_name" => "lightness",
			"description" => esc_html__( "Choose a level of lightness (-100 = darkest, 100 = lightest)", 'hudson' ),
			"dependency" => Array('element' => "custom_map_style", 'value' => array('true'))
		),
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Pin", 'hudson' ),
			"param_name" => "pin",
			"description" => esc_html__( "Select a pin image to be used on Google Map", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Map Zoom", 'hudson' ),
			"param_name" => "zoom",
			"description" => esc_html__( "Enter a zoom factor for Google Map (0 = whole worlds, 19 = individual buildings)", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Zoom Map on Mouse Wheel", 'hudson' ),
			"param_name" => "google_maps_scroll_wheel",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "false",
				esc_html__( "Yes", 'hudson' ) => "true"
			),
			"save_always" => true,
			"description" => esc_html__( "Enabling this option will allow users to zoom in on Map using mouse wheel", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Map Height", 'hudson' ),
			"param_name" => "map_height",
			"description" => ""
		) ,
		array(
			"type" => "checkbox",
			"class" => "",
			"heading" => esc_html__( "Fullscreen Map Height", 'hudson' ),
			"param_name" => "full_screen_map_height",
			"value" => array("Enable Fullscreen Map Height?" => "yes"),
			"description" => esc_html__( "Use only with Vertical Split Slider", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Show address info box on page load", 'hudson' ),
			"param_name" => "address_info_box",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true
		)
	)
));



/*** Team ***/

$team_social_icons_array = array();
for ($x = 1; $x<6; $x++) {
	$teamIconCollections = $hudson_edge_icon_collections->getCollectionsWithSocialIcons();
	foreach($teamIconCollections as $collection_key => $collection) {

		$team_social_icons_array[] = array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Social Icon ", 'hudson' ).$x,
			"param_name" => "team_social_".$collection->param."_".$x,
			"value" => $collection->getSocialIconsArrayVC(),
			"dependency" => Array('element' => "team_social_icon_pack", 'value' => array($collection_key))
		);

	}

	$team_social_icons_array[] = array(
		"type" => "textfield",
		"holder" => "div",
		"class" => "",
		"heading" => esc_html__("Social Icon ", "hudson").$x.esc_html__(" Link", "hudson"),
		"param_name" => "team_social_icon_".$x."_link",
		"dependency" => array('element' => 'team_social_icon_pack', 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
	);

	$team_social_icons_array[] = array(
		"type" => "dropdown",
		"holder" => "div",
		"class" => "",
		"heading" => esc_html__("Social Icon ", "hudson").$x.esc_html__(" Target", "hudson"),
		"param_name" => "team_social_icon_".$x."_target",
		"value" => array(
			"" => "",
			esc_html__( "Self", 'hudson' ) => "_self",
			esc_html__( "Blank", 'hudson' ) => "_blank"
		),
		"dependency" => Array('element' => "team_social_icon_".$x."_link", 'not_empty' => true)
	);

}

vc_map( array(
	"name" => esc_html__( "Team", 'hudson' ),
	"base" => "no_team",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-team extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
		array(
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Type", 'hudson' ),
				"param_name" => "team_type",
				"value" => array(
					esc_html__( "Main Info on Hover", 'hudson' ) => "on_hover",
					esc_html__( "Main Info Below Image", 'hudson' ) => "below_image"
				),
				"save_always" => true
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Image", 'hudson' ),
				"param_name" => "team_image"
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Image hover color", 'hudson' ),
				"param_name" => "team_image_hover_color"
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Hover Type", 'hudson' ),
				"param_name" => "team_hover_type",
				"value" => array(
					esc_html__( "Text In Center", 'hudson' ) => "in_center",
					esc_html__( "Text in Left Corner", 'hudson' ) => "in_corner"
				),
				"save_always" => true,
				"dependency" => array('element' => "team_type", 'value' => array('on_hover'))
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Image Bottom Margin", 'hudson' ),
				"param_name" => "team_info_margin_top",
				"dependency" => array('element' => "team_type", 'value' => array('below_image'))
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Hover Inner Border", 'hudson' ),
				"param_name" => "info_border",
				"value" => array(
					esc_html__( "Yes", 'hudson' ) => "yes",
					esc_html__( "No", 'hudson' ) => "no"
				),
				"save_always" => true,
				"description" => esc_html__( "Inner Border will not work with Main Info on Hover - Text in Left Corner type", 'hudson' )
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Inner Border Animation", 'hudson' ),
				"param_name" => "border_animation",
				"value" => array(
					esc_html__( "No Animation", 'hudson' ) => "",
					esc_html__( "Simultaneous Line", 'hudson' ) => "edgt_box_simultaneous_line",
					esc_html__( "Continue Line", 'hudson' ) => "edgt_box_continue_line",
					esc_html__( "Corner Line", 'hudson' ) => "edgt_box_corner_line",
					esc_html__( "Scale Line", 'hudson' ) => "edgt_box_scale_line"
				),
				"dependency" => array('element' => "info_border", 'value' => array('yes'))
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Name", 'hudson' ),
				"param_name" => "team_name"
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Name Tag", 'hudson' ),
				"param_name" => "team_name_tag",
				"value" => array(
					""   => "",
					"h2" => "h2",
					"h3" => "h3",
					"h4" => "h4",
					"h5" => "h5",
					"h6" => "h6",
				),
				"dependency" => array('element' => 'team_name', 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Margin bottom(px)", 'hudson' ),
				"param_name" => "team_name_bottom_margin",
				"dependency" => array('element' => 'team_name', 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Name font size(px)", 'hudson' ),
				"param_name" => "team_name_font_size",
				"dependency" => array('element' => 'team_name', 'not_empty' => true)
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Name color", 'hudson' ),
				"param_name" => "team_name_color",
				"dependency" => array('element' => 'team_name', 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Name font weight", 'hudson' ),
				"param_name" => "team_name_font_weight",
				"value" => $font_weight_array,
				"description" => "",
				"dependency" => array('element' => 'team_name', 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Name text transform", 'hudson' ),
				"param_name" => "team_name_text_transform",
				"value" => array(
					esc_html__( "Default", 'hudson' ) => "",
					esc_html__( "None", 'hudson' ) => "none",
					esc_html__( "Capitalize", 'hudson' ) => "capitalize",
					esc_html__( "Uppercase", 'hudson' ) => "uppercase",
					esc_html__( "Lowercase", 'hudson' ) => "lowercase"
				),
				"dependency" => array('element' => 'team_name', 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Show Separator", 'hudson' ),
				"param_name" => "team_show_separator",
				"value" => array(
					esc_html__( "Yes", 'hudson' ) => "yes",
					esc_html__( "No", 'hudson' ) => "no"
				),
				"save_always" => true,
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Separator color", 'hudson' ),
				"param_name" => "team_separator_color",
				"dependency" => array('element' => 'team_show_separator', 'value' => "yes")
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Position", 'hudson' ),
				"param_name" => "team_position"
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Position font size(px)", 'hudson' ),
				"param_name" => "team_position_font_size",
				"dependency" => array('element' => 'team_position', 'not_empty' => true)
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Position color", 'hudson' ),
				"param_name" => "team_position_color",
				"dependency" => array('element' => 'team_position', 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Position font weight", 'hudson' ),
				"param_name" => "team_position_font_weight",
				"value" => $font_weight_array,
				"description" => "",
				"dependency" => array('element' => 'team_position', 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Position text transform", 'hudson' ),
				"param_name" => "team_position_text_transform",
				"value" => array(
					esc_html__( "Default", 'hudson' ) => "",
					esc_html__( "None", 'hudson' ) => "none",
					esc_html__( "Capitalize", 'hudson' ) => "capitalize",
					esc_html__( "Uppercase", 'hudson' ) => "uppercase",
					esc_html__( "Lowercase", 'hudson' ) => "lowercase"
				),
				"dependency" => array('element' => 'team_position', 'not_empty' => true)
			),
			array(
				"type" => "textarea",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Description", 'hudson' ),
				"param_name" => "team_description"
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Description color", 'hudson' ),
				"param_name" => "team_description_color",
				"dependency" => array('element' => 'team_description', 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text align", 'hudson' ),
				"param_name" => "text_align",
				"value" => array(
					esc_html__( "Default", 'hudson' ) => "",
					esc_html__( "Left", 'hudson' ) => "left_align",
					esc_html__( "Center", 'hudson' ) => "center_align",
					esc_html__( "Right", 'hudson' ) => "right_align"
				)
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Background Color", 'hudson' ),
				"param_name" => "background_color",
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Box Border", 'hudson' ),
				"param_name" => "box_border",
				"value" => array(
					esc_html__( "Default", 'hudson' ) => "",
					esc_html__( "No", 'hudson' ) => "no",
					esc_html__( "Yes", 'hudson' ) => "yes"
				),
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Box Border Width", 'hudson' ),
				"param_name" => "box_border_width",
				"value" => "",
				"description" => "",
				"dependency" => array('element' => "box_border", 'value' => array('yes'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Box Border Color", 'hudson' ),
				"param_name" => "box_border_color",
				"value" => "",
				"description" => "",
				"dependency" => array('element' => "box_border", 'value' => array('yes'))
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Social Icon Pack", 'hudson' ),
				"param_name" => "team_social_icon_pack",
				"value" => array_merge(array("" => ""),$hudson_edge_icon_collections->getIconCollectionsVCExclude('linea_icons'))
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Social Style", 'hudson' ),
				"param_name" => "team_social_style",
				"value" => array(
					esc_html__( "Between Image and Info", 'hudson' ) => "social_style_between",
					esc_html__( "In the center of the image", 'hudson' ) => "social_style_center",
					esc_html__( "On the bottom of the image", 'hudson' ) => "social_style_bottom"
				),
				"save_always" => true,
				"description" => esc_html__( "Social Style applies only when Main Info Below Image type is selected", 'hudson' ),
				"dependency" => array('element' => 'team_social_icon_pack', 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Social Icons Border color", 'hudson' ),
				"param_name" => "team_social_icon_holder_border_color",
				"description" => esc_html__( "Social Icons Background Color applies only when Social Style On the bottom of the image is selected", 'hudson' ),
				"dependency" => array('element' => 'team_social_icon_pack', 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Social Icons Background color", 'hudson' ),
				"param_name" => "team_social_icon_holder_back_color",
				"description" => esc_html__( "Social Icons Background Color applies only when Social Style On the bottom of the image is selected", 'hudson' ),
				"dependency" => array('element' => 'team_social_icon_pack', 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
			),			
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Social Icons Position", 'hudson' ),
				"param_name" => "social_icons_position",
				"value" => array(
					esc_html__( "Left", 'hudson' ) => "left",
					esc_html__( "Center", 'hudson' ) => "center",
					esc_html__( "Right", 'hudson' ) => "right"
				),
				"save_always" => true,
				"description" => esc_html__( "Social Icons Position applies only when Main Info Below Image type is selected", 'hudson' ),
				"dependency" => array('element' => 'team_social_style', 'value' => array("social_style_between"))
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Social Icons Type", 'hudson' ),
				"param_name" => "team_social_icon_type",
				"value" => array(
					esc_html__( "Normal", 'hudson' ) => "normal_social",
					esc_html__( "Circle", 'hudson' ) => "circle_social",
					esc_html__( "Square", 'hudson' ) => "square_social"
				),
				"save_always" => true,
				"dependency" => array('element' => 'team_social_icon_pack', 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Social Icons color", 'hudson' ),
				"param_name" => "team_social_icon_color",
				"dependency" => array('element' => 'team_social_icon_pack', 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Social Icons Background Color", 'hudson' ),
				"param_name" => "team_social_icon_background_color",
				"dependency" => array('element' => 'team_social_icon_type', 'value' => array('circle_social', 'square_social'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Social Icons Border Color", 'hudson' ),
				"param_name" => "team_social_icon_border_color",
				"dependency" => array('element' => 'team_social_icon_type', 'value' => array('circle_social', 'square_social'))
			)
		),
		$team_social_icons_array,
		array(
			array(
				"type" => "checkbox",
				"class" => "",
				"heading" => esc_html__( "Team Member Skills", 'hudson' ),
				"value" => array("Show Team Member Skills?" => "yes"),
				"param_name" => "show_skills",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Skills Title Size", 'hudson' ),
				"param_name" => "skills_title_size",
				"dependency" => array("element" => "show_skills", "value" => "yes")
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "First Skill Title", 'hudson' ),
				"param_name" => "skill_title_1",
				"description" => esc_html__( "For example Web design", 'hudson' ),
				"dependency" => array("element" => "show_skills", "value" => "yes")
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "First Skill Percentage", 'hudson' ),
				"param_name" => "skill_percentage_1",
				"description" => esc_html__( "Enter just number, without %", 'hudson' ),
				"dependency" => array("element" => "show_skills", "value" => "yes")
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Second Skill Title", 'hudson' ),
				"param_name" => "skill_title_2",
				"description" => esc_html__( "For example Web design", 'hudson' ),
				"dependency" => array("element" => "show_skills", "value" => "yes")
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Second Skill Percentage", 'hudson' ),
				"param_name" => "skill_percentage_2",
				"description" => esc_html__( "Enter just number, without %", 'hudson' ),
				"dependency" => array("element" => "show_skills", "value" => "yes")
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Third Skill Title", 'hudson' ),
				"param_name" => "skill_title_3",
				"description" => esc_html__( "For example Web design", 'hudson' ),
				"dependency" => array("element" => "show_skills", "value" => "yes")
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Third Skill Percentage", 'hudson' ),
				"param_name" => "skill_percentage_3",
				"description" => esc_html__( "Enter just number, without %", 'hudson' ),
				"dependency" => array("element" => "show_skills", "value" => "yes")
			)
		)
	)

) );


/*** Clients ***/

class WPBakeryShortCode_No_Clients  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" => esc_html__( "Edge Clients", 'hudson' ),
	"base" => "no_clients",
	"as_parent" => array('only' => 'no_client'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-clients extended-custom-icon",
	"show_settings_on_create" => true,
	"params" => array(
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Columns", 'hudson' ),
			"param_name" => "columns",
			"value" => array(
				esc_html__( "Two", 'hudson' ) => "two_columns",
				esc_html__( "Three", 'hudson' ) => "three_columns",
				esc_html__( "Four", 'hudson' ) => "four_columns",
				esc_html__( "Five", 'hudson' ) => "five_columns",
				esc_html__( "Six", 'hudson' ) => "six_columns"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show borders", 'hudson' ),
			"param_name" => "client_borders",
			"description" => "",
			"value" => array(
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Space between clients", 'hudson' ),
			"param_name" => "space_between_clients",
			"description" => esc_html__( "When yes, space will be 10px", 'hudson' ),
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true
		)
	),
	"js_view" => 'VcColumnView'
) );


/*** Client ***/

class WPBakeryShortCode_No_Client extends WPBakeryShortCode {}
vc_map( array(
	"name" => esc_html__( "Edge Client", 'hudson' ),
	"base" => "no_client",
	"content_element" => true,
	"icon" => "icon-wpb-client extended-custom-icon",
	"as_child" => array('only' => 'no_clients'),
	"params" => array(
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Image", 'hudson' ),
			"param_name" => "image"
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Link", 'hudson' ),
			"param_name" => "link"
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Link Target", 'hudson' ),
			"param_name" => "link_target",
			"value" => array(
				"" => "",
				esc_html__( "Self", 'hudson' ) => "_self",
				esc_html__( "Blank", 'hudson' ) => "_blank"
			)
		)
	)
) );


/*** Circles ***/

class WPBakeryShortCode_No_Circles  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" => esc_html__("Edge Process Holder", "hudson"),
	"base" => "no_circles",
	"as_parent" => array('only' => 'no_circle'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-circles extended-custom-icon",
	"show_settings_on_create" => true,
	"params" => array(
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Columns", 'hudson' ),
			"param_name" => "columns",
			"value" => array(
				esc_html__( "Three", 'hudson' ) => "three_columns",
				esc_html__( "Four", 'hudson' ) => "four_columns",
				esc_html__( "Five", 'hudson' ) => "five_columns",
				esc_html__( "Six", 'hudson' ) => "six_columns"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Items connector", 'hudson' ),
			"param_name" => "arrows_between",
			"description" => "",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Arrows", 'hudson' ) => "yes",
				esc_html__( "Lines", 'hudson' ) => "lines"
			),
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Line Color", 'hudson' ),
			"param_name" => "line_color",
			"description" => "",
			"dependency" => array('element' => "arrows_between", 'value' => array("lines"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Process Item Height (px)", 'hudson' ),
			"param_name" => "process_height",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Process Item Width (px)", 'hudson' ),
			"param_name" => "process_width",
			"description" => ""
		)
	),
	"js_view" => 'VcColumnView'
) );


/*** Circle ***/

class WPBakeryShortCode_No_Circle extends WPBakeryShortCode {}
vc_map( array(
	"name" => esc_html__("Edge Process", "hudson"),
	"base" => "no_circle",
	"content_element" => true,
	"icon" => "icon-wpb-circle extended-custom-icon",
	"as_child" => array('only' => 'no_circles'),
	"params" => array_merge(
		array(
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Type", 'hudson' ),
				"param_name" => "type",
				"value" => array(
					esc_html__( "Icon in Process", 'hudson' ) => "icon_type",
					esc_html__( "Image", 'hudson' ) => "image_type",
					esc_html__( "Text in Process", 'hudson' ) => "text_type",
					esc_html__( "Image with Text", 'hudson' ) => "image_with_text_type"
				),
				"save_always" => true
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Process Background Image", 'hudson' ),
				"param_name" => "background_image",
				"dependency" => array('element' => "type", 'value' => array("icon_type")),
				"description" => ""
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Process Pattern Image", 'hudson' ),
				"param_name" => "background_pattern",				
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Background Process Color", 'hudson' ),
				"param_name" => "background_color",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Background Process Transparency", 'hudson' ),
				"param_name" => "background_transparency",
				"description" => esc_html__( "Insert value between 0 and 1", 'hudson' )
			),
			array(
				"type" => "checkbox",
				"class" => "",
				"heading" => "",
				"value" => array("Without outer border?" => "yes"),
				"param_name" => "without_double_border",
				"description" => "",
				"dependency" => array('element' => "type", 'value' => array("icon_type","image_type","text_type"))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Process Color", 'hudson' ),
				"param_name" => "border_color",
				"description" => "",
				"dependency" => array('element' => "type", 'value' => array("icon_type","image_type","text_type"))
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Process Width", 'hudson' ),
				"param_name" => "border_width",
				"description" => "",
				"dependency" => array('element' => "type", 'value' => array("icon_type","image_type","text_type"))
			)
		),
		$hudson_edge_icon_collections->getVCParamsArray( array( 'element' => 'type', 'value' => array( 'icon_type' ) ) ),
		array(
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Size", 'hudson' ),
				"param_name" => "size",
				"description" => esc_html__( "Enter just number. Omit px", 'hudson' ),
				"dependency" => array('element' => "type", 'value' => array("icon_type"))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Color", 'hudson' ),
				"param_name" => "icon_color",
				"dependency" => array('element' => "type", 'value' => array("icon_type"))
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Image", 'hudson' ),
				"param_name" => "image",
				"dependency" => array('element' => "type", 'value' => array("image_type", "image_with_text_type"))
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text in Process", 'hudson' ),
				"param_name" => "text_in_circle",
				"dependency" => array('element' => "type", 'value' => array("text_type", "image_with_text_type"))
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Text in Process Tag", 'hudson' ),
				"param_name" => "text_in_circle_tag",
				"value" => array(
					""   => "",
					"h2" => "h2",
					"h3" => "h3",
					"h4" => "h4",
					"h5" => "h5",
					"h6" => "h6",
				),
				"description" => "",
				"dependency" => array('element' => "text_in_circle", 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text in Process Size (px)", 'hudson' ),
				"param_name" => "font_size",
				"dependency" => array('element' => "text_in_circle", 'not_empty' => true)
			),			
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text in Process Font Family", 'hudson' ),
				"param_name" => "font_family",
				"dependency" => array('element' => "text_in_circle", 'not_empty' => true)
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text in Process Color", 'hudson' ),
				"param_name" => "text_in_circle_color",
				"description" => "",
				"dependency" => array('element' => "text_in_circle", 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Link", 'hudson' ),
				"param_name" => "link",
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Link Target", 'hudson' ),
				"param_name" => "link_target",
				"value" => array(
					"" => "",
					esc_html__( "Self", 'hudson' ) => "_self",
					esc_html__( "Blank", 'hudson' ) => "_blank"
				),
				"description" => "",
				"dependency" => array('element' => "link", 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title", 'hudson' ),
				"param_name" => "title",
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Title Tag", 'hudson' ),
				"param_name" => "title_tag",
				"value" => array(
					""   => "",
					"h2" => "h2",
					"h3" => "h3",
					"h4" => "h4",
					"h5" => "h5",
					"h6" => "h6",
				),
				"description" => "",
				"dependency" => array('element' => "title", 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Font Size (px)", 'hudson' ),
				"param_name" => "title_font_size",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Color", 'hudson' ),
				"param_name" => "title_color",
				"description" => "",
				"dependency" => array('element' => "title", 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Title Alignment", 'hudson' ),
				"param_name" => "title_alignment",
				"value" => array(
					""   => "",
					esc_html__( "Left", 'hudson' ) => "title_left",
					esc_html__( "Center", 'hudson' ) => "title_center",
					esc_html__( "Right", 'hudson' ) => "title_right"
				),
				"description" => "",
				"dependency" => array('element' => "title", 'not_empty' => true)
			),
			array(
				"type" => "textarea",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text", 'hudson' ),
				"param_name" => "text",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text Color", 'hudson' ),
				"param_name" => "text_color",
				"description" => "",
				"dependency" => array('element' => "text", 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Text Alignment", 'hudson' ),
				"param_name" => "text_alignment",
				"value" => array(
					""   => "",
					esc_html__( "Left", 'hudson' ) => "text_left",
					esc_html__( "Center", 'hudson' ) => "text_center",
					esc_html__( "Right", 'hudson' ) => "text_right"
				),
				"description" => "",
				"dependency" => array('element' => "text", 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Space between circle and title", 'hudson' ),
				"param_name" => "title_margin_top",
				"description" => esc_html__( "Enter just number. Omit px (default value is 24)", 'hudson' )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Space between title and text", 'hudson' ),
				"param_name" => "text_margin_top",
				"description" => esc_html__( "Enter just number. Omit px (default value is 5)", 'hudson' )
			)
		)
	)
) );


/*** Pricing Tables ***/

class WPBakeryShortCode_No_Pricing_Tables  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" => esc_html__("Edge Pricing Tables", "hudson"),
	"base" => "no_pricing_tables",
	"as_parent" => array('only' => 'no_pricing_table'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-pricing-tables extended-custom-icon",
	"show_settings_on_create" => true,
	"params" => array(
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Columns", 'hudson' ),
			"param_name" => "columns",
			"value" => array(
				esc_html__( "Two", 'hudson' ) => "two_columns",
				esc_html__( "Three", 'hudson' ) => "three_columns",
				esc_html__( "Four", 'hudson' ) => "four_columns",
			),
			"save_always" => true,
			"description" => ""
		)
	),
	"js_view" => 'VcColumnView'
) );


/*** Pricing Table ***/

class WPBakeryShortCode_No_Pricing_Table  extends WPBakeryShortCode {}
vc_map( array(
	"name" => esc_html__( "Pricing Table", 'hudson' ),
	"base" => "no_pricing_table",
	"icon" => "icon-wpb-pricing-table extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"as_child" => array('only' => 'no_pricing_tables'),
	"params" => array(
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__("Type", 'hudson'),
			"param_name" => "type",
			"value" => array(
				esc_html__( "Price on top", 'hudson' ) => "price_on_top",
				esc_html__( "Title on top", 'hudson' ) => "title_on_top"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title", 'hudson' ),
			"param_name" => "title",
			"value" => esc_html__("Basic Plan", "hudson"),
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Color", 'hudson' ),
			"param_name" => "title_color",
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Background Color", 'hudson' ),
			"param_name" => "title_background_color",
			"description" => ""
		),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Title Background Image", 'hudson' ),
            "param_name" => "title_background_image",
            "description" => ""
        ),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Font Family", 'hudson' ),
			"param_name" => "title_font_family",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Small Separator", 'hudson' ),
			"param_name" => "title_separator",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array('element' => 'type', 'value' => 'price_on_top')
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Separator Color", 'hudson' ),
			"param_name" => "title_separator_color",
			"description" => "",
			"dependency" => array('element' => 'title_separator', 'value' => 'yes')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Border Bottom", 'hudson' ),
			"param_name" => "title_border_bottom",
			"value" => array(
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array('element' => 'type', 'value' => 'title_on_top')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Border Bottom Style", 'hudson' ),
			"param_name" => "title_border_bottom_style",
			"value" => array(
				esc_html__( "In grid", 'hudson' ) => "pricing_title_grid",
				esc_html__( "Full Width", 'hudson' ) => "pricing_title_full_width"
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array('element' => 'title_border_bottom', 'value' => 'yes')
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Border Bottom Color", 'hudson' ),
			"param_name" => "title_border_bottom_color",
			"description" => "",
			"dependency" => array('element' => 'title_border_bottom', 'value' => 'yes')
		),

		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border Around", 'hudson' ),
			"param_name" => "border_arround",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => ""
		),

		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border Around Color", 'hudson' ),
			"param_name" => "border_arround_color",
			"description" => "",
			"dependency" => array('element' => 'border_arround', 'value' => 'yes')
		),

		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Wide Border Top", 'hudson' ),
			"param_name" => "table_border_top",
			"value" => array(
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array('element' => 'type', 'value' => 'title_on_top')
		),

		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Wide Border Top Color", 'hudson' ),
			"param_name" => "pricing_table_border_top_color",
			"description" => "",
			"dependency" => array('element' => 'table_border_top', 'value' => 'yes')
		),

		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price", 'hudson' ),
			"param_name" => "price",
			"description" => esc_html__( "Default value is 100", 'hudson' )
		),
        array(
            "type" => "colorpicker",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Price Color", 'hudson' ),
            "param_name" => "price_color",
            "description" => ""
        ),
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Background Image", 'hudson' ),
			"param_name" => "price_bckg_image",
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Background Color", 'hudson' ),
			"param_name" => "price_background",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Border Bottom", 'hudson' ),
			"param_name" => "price_border_bottom",
			"value" => array(
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Border Bottom Color", 'hudson' ),
			"param_name" => "price_border_bottom_color",
			"description" => "",
			"dependency" => array('element' => 'price_border_bottom', 'value' => 'yes')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Font Weight", 'hudson' ),
			"param_name" => "price_font_weight",
			"value" => $font_weight_array,
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Currency", 'hudson' ),
			"param_name" => "currency",
			"description" => esc_html__( "Default mark is $", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Period", 'hudson' ),
			"param_name" => "price_period",
			"description" => esc_html__( "Default label is monthly", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Period Position", 'hudson' ),
			"param_name" => "price_period_position",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Next to Title", 'hudson' ) => "next_to_title",
				esc_html__( "Bellow Title", 'hudson' ) => "bellow_title"
			),
			"description" => "",
			"dependency" => array('element' => 'type', 'value' => 'price_on_top')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show Button", 'hudson' ),
			"param_name" => "show_button",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button Type", 'hudson' ),
			"param_name" => "pricing_button_type",
			"value" => array(
				esc_html__( "Standard Button", 'hudson' ) => "standard_button",
				esc_html__( "Button on Bottom", 'hudson' ) => "button_on_bottom"
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array('element' => 'show_button',  'value' => 'yes')
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button Text", 'hudson' ),
			"param_name" => "button_text",
            "description" => esc_html__( "Default text is button", 'hudson' ),
			"dependency" => array('element' => 'pricing_button_type',  'value' => 'standard_button')
		),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Button Font Size (px)", 'hudson' ),
            "param_name" => "button_font_size",
            "dependency" => array('element' => 'show_button',  'value' => 'yes')
        ),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button Size", 'hudson' ),
			"value" => array(
				esc_html__( "Full Width", 'hudson' ) => "full_width",
				esc_html__( "Normal", 'hudson' ) => "normal"
			),
			"save_always" => true,
			"param_name" => "button_size",
			"description" => esc_html__( "This options is only used for type Title on Top", 'hudson' ),
			"dependency" => array('element' => 'pricing_button_type',  'value' => 'standard_button')
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button Link", 'hudson' ),
			"param_name" => "link",
			"dependency" => array('element' => 'show_button',  'value' => 'yes')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button Target", 'hudson' ),
			"param_name" => "target",
			"value" => array(
				"" => "",
				esc_html__( "Self", 'hudson' ) => "_self",
				esc_html__( "Blank", 'hudson' ) => "_blank"
			),
			"dependency" => array('element' => 'link', 'not_empty' => true)
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button Font Family", 'hudson' ),
			"param_name" => "button_font_family",
			"dependency" => array('element' => 'show_button', 'value' => 'yes')
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button Color", 'hudson' ),
			"param_name" => "button_color",
			"dependency" => array('element' => 'show_button', 'value' => 'yes')
		),
        array(
            "type" => "colorpicker",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Button Hover Color", 'hudson' ),
            "param_name" => "button_hover_color",
            "dependency" => array('element' => 'show_button', 'value' => 'yes')
        ),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button Background Color", 'hudson' ),
			"param_name" => "button_background_color",
			"dependency" => array('element' => 'show_button', 'value' => 'yes')
		),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Button Background Image", 'hudson' ),
            "param_name" => "button_background_image",
            "description" => "",
            "dependency" => array('element' => 'pricing_button_type',  'value' => 'standard_button')
        ),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button Icon Size(px)", 'hudson' ),
			"param_name" => "button_icon_size",
			"dependency" => array('element' => 'pricing_button_type',  'value' => 'button_on_bottom')
		),

		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Button arrow", 'hudson' ),
			"param_name" => "button_arrow",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array('element' => 'button_text', 'not_empty' => true)
		),

		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Disable Button Top Border", 'hudson' ),
			"param_name" => "disable_button_border_top",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"description" => esc_html__( "This options is only used for type Title on Top", 'hudson' ),
			"dependency" => array('element' => 'button_text', 'not_empty' => true)
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Active", 'hudson' ),
			"param_name" => "active",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Active Style", 'hudson' ),
			"param_name" => "active_style",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Circle", 'hudson' ) => "circle",
				esc_html__( "Rectangle", 'hudson' ) => "rectangle",
			),
			"dependency" => array('element' => 'active', 'value' => 'yes')
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Active text", 'hudson' ),
			"param_name" => "active_text",
			"description" => esc_html__( "Best choice", 'hudson' ),
			"dependency" => array('element' => 'active', 'value' => 'yes')
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Active Text Color", 'hudson' ),
			"param_name" => "active_text_color",
			"dependency" => array('element' => 'active', 'value' => 'yes')
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Active Text Background Color", 'hudson' ),
			"param_name" => "active_text_background_color",
			"dependency" => array('element' => 'active', 'value' => 'yes')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Content Style", 'hudson' ),
			"param_name" => "content_style",
			"value" => array(
				esc_html__( "In Grid", 'hudson' ) => "pricing_content_grid",
				esc_html__( "Full Width ", 'hudson' ) => "pricing_content_full_width",
			),
			"save_always" => true
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Content Text Color", 'hudson' ),
			"param_name" => "content_text_color"
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Content Background Color", 'hudson' ),
			"param_name" => "content_background_color",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Set Different Background Color for Odd and Even Content Sections?", 'hudson' ),
			"param_name" => "different_odd_even_sections",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes",
			),
			"save_always" => true
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Even Sections Background Color", 'hudson' ),
			"param_name" => "even_back_color",
			"dependency" => array('element' => 'different_odd_even_sections', 'value' => 'yes')
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Odd Sections Background Color", 'hudson' ),
			"param_name" => "odd_back_color",
			"dependency" => array('element' => 'different_odd_even_sections', 'value' => 'yes')
		),
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Pricing Table Background Image", 'hudson' ),
			"param_name" => "content_background_image",
			"description" => ""
		),
		array(
			"type" => "textarea_html",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Content", 'hudson' ),
			"param_name" => "content",
			"value" => "<li>" . esc_html__( 'content content content', 'hudson' ) . "</li><li>" . esc_html__( 'content content content', 'hudson' ) . "</li><li>" . esc_html__( 'content content content', 'hudson' ) . "</li>",
			"description" => ""
		)
	)
) );


/*** Pricing List ***/

class WPBakeryShortCode_No_Pricing_List  extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" => esc_html__("Edge Pricing List", "hudson"),
	"base" => "no_pricing_list",
	"as_parent" => array('only' => 'no_pricing_list_item'),
	"content_element" => true,
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-pricing-list extended-custom-icon",
	"show_settings_on_create" => false,
	"js_view" => 'VcColumnView',
	"params" => array(
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Type", 'hudson' ),
			"param_name" => "type",
			"value" => array(
				esc_html__( "Leaders", 'hudson' ) => "with_leaders",
				esc_html__( "Background", 'hudson' ) => "with_background_image"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title", 'hudson' ),
			"param_name" => "title",
			"value" => "",
			"description" => ""
		),
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background image", 'hudson' ),
			"param_name" => "background_image",
			"dependency" => array('element' => "type", 'value' => array("with_background_image"))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background Color", 'hudson' ),
			"param_name" => "backgroundcolor"
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Leaders Type", 'hudson' ),
			"param_name" => "leaders_type",
			"value" => array(
				esc_html__( "Dotted", 'hudson' ) => "dotted",
				esc_html__( "Solid", 'hudson' ) => "solid",
				esc_html__( "Dashed", 'hudson' ) => "dashed"
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array('element' => "type", 'value' => array("with_leaders"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Padding", 'hudson' ),
			"param_name" => "item_padding",
			"value" => "",
			"description" =>  esc_html__("Please insert padding in format 0px 10px 0px 10px, default value is 0 0 0 0", 'hudson')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border", 'hudson' ),
			"param_name" => "border",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes",
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border Color", 'hudson' ),
			"param_name" => "border_color",
			"description" => "",
			"dependency" => array('element' => "border", 'value' => array("yes"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border Width (px)", 'hudson' ),
			"param_name" => "border_width",
			"description" => "",
			"dependency" => array('element' => "border", 'value' => array("yes"))
		)
	)
) );


/*** Pricing List Item ***/

class WPBakeryShortCode_No_Pricing_List_Item extends WPBakeryShortCode {}
vc_map( array(
	"name" => esc_html__("Edge Pricing List Item", "hudson"),
	"base" => "no_pricing_list_item",
	"content_element" => true,
	"icon" => "icon-wpb-pricing-list-item extended-custom-icon",
	"as_child" => array('only' => 'no_pricing_list'),
	"params" => array(
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background color", 'hudson' ),
			"param_name" => "backgroundcolor",
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title", 'hudson' ),
			"param_name" => "title",
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Color", 'hudson' ),
			"param_name" => "title_color",
			"dependency" => array('element' => "title", 'not_empty' => true)
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Font Size (px)", 'hudson' ),
			"param_name" => "title_font_size",
			"description" => esc_html__( "Enter just number. Omit unit, it is added automatically", 'hudson' ),
			"dependency" => array('element' => "title", 'not_empty' => true)
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Title Tag", 'hudson' ),
			"param_name" => "title_tag",
			"value" => array(
				""   => "",
				"h2" => "h2",
				"h3" => "h3",
				"h4" => "h4",
				"h5" => "h5",
				"h6" => "h6",
			),
			"description" => "",
			"dependency" => array('element' => "title", 'not_empty' => true)
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Font Family", 'hudson' ),
			"param_name" => "title_font_family",
			"value" => "",
			"description" => "",
			"dependency" => array('element' => "title", 'not_empty' => true)
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Font Weight", 'hudson' ),
			"param_name" => "title_font_weight",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Thin 100", 'hudson' ) => "100",
				esc_html__( "Extra-Light 200", 'hudson' ) => "200",
				esc_html__( "Light 300", 'hudson' ) => "300",
				esc_html__( "Regular 400", 'hudson' ) => "400",
				esc_html__( "Medium 500", 'hudson' ) => "500",
				esc_html__( "Semi-Bold 600", 'hudson' ) => "600",
				esc_html__( "Bold 700", 'hudson' ) => "700",
				esc_html__( "Extra-Bold 800", 'hudson' ) => "800",
				esc_html__( "Ultra-Bold 900", 'hudson' ) => "900"
			),
			"description" => "",
			"dependency" => array('element' => "title", 'not_empty' => true)
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text", 'hudson' ),
			"param_name" => "text",
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text Color", 'hudson' ),
			"param_name" => "text_color",
			"dependency" => array('element' => "text", 'not_empty' => true)
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text Font Size (px)", 'hudson' ),
			"param_name" => "text_font_size",
			"description" => esc_html__( "Enter just number. Omit unit, it is added automatically", 'hudson' ),
			"dependency" => array('element' => "text", 'not_empty' => true)
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price", 'hudson' ),
			"param_name" => "price",
			"description" => esc_html__( "You can append any unit that you want", 'hudson' )
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Color", 'hudson' ),
			"param_name" => "price_color",
			"dependency" => array('element' => "price", 'not_empty' => true)
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Font Family", 'hudson' ),
			"param_name" => "price_font_family",
			"value" => "",
			"description" => "",
			"dependency" => array('element' => "price", 'not_empty' => true)
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Font Size (px)", 'hudson' ),
			"param_name" => "price_font_size",
			"description" => esc_html__( "Enter just number. Omit unit, it is added automatically", 'hudson' ),
			"dependency" => array('element' => "price", 'not_empty' => true)
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Font Weight", 'hudson' ),
			"param_name" => "price_font_weight",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Thin 100", 'hudson' ) => "100",
				esc_html__( "Extra-Light 200", 'hudson' ) => "200",
				esc_html__( "Light 300", 'hudson' ) => "300",
				esc_html__( "Regular 400", 'hudson' ) => "400",
				esc_html__( "Medium 500", 'hudson' ) => "500",
				esc_html__( "Semi-Bold 600", 'hudson' ) => "600",
				esc_html__( "Bold 700", 'hudson' ) => "700",
				esc_html__( "Extra-Bold 800", 'hudson' ) => "800",
				esc_html__( "Ultra-Bold 900", 'hudson' ) => "900"
			),
			"description" => "",
			"dependency" => array('element' => "price", 'not_empty' => true)
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Price Font Style", 'hudson' ),
			"param_name" => "price_font_style",
			"value" => array(
				"" => "",
				esc_html__( "Normal", 'hudson' ) => "normal",
				esc_html__( "Italic", 'hudson' ) => "italic"
			),
			"description" => "",
			"dependency" => array('element' => "price", 'not_empty' => true)
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator", 'hudson' ),
			"param_name" => "separator",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes",
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Type", 'hudson' ),
			"param_name" => "separator_type",
			"value" => array(
				esc_html__( "Solid", 'hudson' ) => "solid",
				esc_html__( "Dotted", 'hudson' ) => "dotted",
				esc_html__( "Dashed", 'hudson' ) => "dashed"
			),
			"save_always" => true,
			"description" => "",
			"dependency" => array('element' => "separator", 'value' => array("yes"))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Color", 'hudson' ),
			"param_name" => "separator_color",
			"description" => "",
			"dependency" => array('element' => "separator", 'value' => array("yes"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Thickness (px)", 'hudson' ),
			"param_name" => "separator_width",
			"description" => "",
			"dependency" => array('element' => "separator", 'value' => array("yes"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Position Top (px)", 'hudson' ),
			"param_name" => "separator_position_top",
			"description" => "",
			"dependency" => array('element' => "separator", 'value' => array("yes"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Position Bottom (px)", 'hudson' ),
			"param_name" => "separator_position_bottom",
			"description" => "",
			"dependency" => array('element' => "separator", 'value' => array("yes"))
		),
		array(
			"type" => "checkbox",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "New Item", 'hudson' ),
			"param_name" => "enable_new_item",
			"value" => array("Set as new item?" => "enable_new_item"),
			"description" => esc_html__( "Only when pricing list is set to type Leaders", 'hudson' )
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "New Item Text Color", 'hudson' ),
			"param_name" => "new_item_text_color",
			"description" => "",
			"dependency" => array('element' => "enable_new_item", 'value' => array("enable_new_item"))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "New Item Icon Color", 'hudson' ),
			"param_name" => "new_item_icon_color",
			"description" => "",
			"dependency" => array('element' => "enable_new_item", 'value' => array("enable_new_item"))
		),
		array(
			"type" => "checkbox",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Highlighted Item", 'hudson' ),
			"param_name" => "enable_highlighted_item",
			"value" => array("Set as highlighted item?" => "enable_highlighted_item"),
			"description" => esc_html__( "Only when pricing list is set to type Leaders", 'hudson' )
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Highlighted Text", 'hudson' ),
			"param_name" => "highlighted_text",
			"description" => "",
			"dependency" => array('element' => "enable_highlighted_item", 'value' => array("enable_highlighted_item"))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Highlighted Text Color", 'hudson' ),
			"param_name" => "highlighted_text_color",
			"description" => "",
			"dependency" => array('element' => "enable_highlighted_item", 'value' => array("enable_highlighted_item"))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Highlighted Text Background Color", 'hudson' ),
			"param_name" => "highlighted_text_background_color",
			"description" => "",
			"dependency" => array('element' => "enable_highlighted_item", 'value' => array("enable_highlighted_item"))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Item Margin Bottom (px)", 'hudson' ),
			"param_name" => "margin_bottom_item",
			"description" => ""
		),
	)
) );


/*** Service table ***/

vc_map( array(
		"name" => esc_html__( "Service Table", 'hudson' ),
		"base" => "no_service_table",
		"icon" => "icon-wpb-service-table extended-custom-icon",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"allowed_container_element" => 'vc_row',
		"params" => array_merge(
			array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Type", 'hudson' ),
					"param_name" => "type",
					"value" => array(
						esc_html__( "Icon/Image on Top", 'hudson' ) => "icon_image_on_top",
						esc_html__( "Title on Top", 'hudson' ) => "title_on_top",
					),
					"save_always" => true,
					"description" => ""
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Title", 'hudson' ),
					"param_name" => "title",
					"value" => ""
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Title Tag", 'hudson' ),
					"param_name" => "title_tag",
					"value" => array(
						""   => "",
						"h2" => "h2",
						"h3" => "h3",
						"h4" => "h4",
						"h5" => "h5",
						"h6" => "h6",
					),
					"description" => ""
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Title Color", 'hudson' ),
					"param_name" => "title_color",
					"description" => ""
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Title Background Color", 'hudson' ),
					"param_name" => "title_background_color",
					"description" => ""
				),
				array(
					"type" => "attach_image",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Top Background Image", 'hudson' ),
					"param_name" => "top_background_image",
					"description" => "",
					"dependency" => array("element" => "type", "value" => array("icon_image_on_top"))
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Title Small Separator", 'hudson' ),
					"param_name" => "title_separator",
					"value" => array(
						esc_html__( "No", 'hudson' ) => "no",
						esc_html__( "Yes", 'hudson' ) => "yes"
					),
					"save_always" => true,
					"description" => "",
					"dependency" => array("element" => "type", "value" => array("icon_image_on_top"))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Separator Color", 'hudson' ),
					"param_name" => "title_separator_color",
					"description" => "",
					"dependency" => array("element" => "title_separator", "value" => array("yes"))
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Title Border Bottom", 'hudson' ),
					"param_name" => "title_border_bottom",
					"value" => array(
						esc_html__( "Yes", 'hudson' ) => "yes",
						esc_html__( "No", 'hudson' ) => "no"
					),
					"save_always" => true,
					"description" => "",
					"dependency" => array("element" => "type", "value" => array("title_on_top"))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Title Border Bottom color", 'hudson' ),
					"param_name" => "title_border_bottom_color",
					"description" => "",
					"dependency" => array("element" => "title_border_bottom", "value" => array("yes"))
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Wide Border Top", 'hudson' ),
					"param_name" => "border_top",
					"value" => array(
						esc_html__( "Yes", 'hudson' ) => "yes",
						esc_html__( "No", 'hudson' ) => "no"
					),
					"save_always" => true,
					"description" => "",
					"dependency" => array("element" => "type", "value" => array("title_on_top"))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Wide Border Top Color", 'hudson' ),
					"param_name" => "border_top_color",
					"description" => "",
					"dependency" => array("element" => "border_top", "value" => array("yes"))
				),

				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Show Icon/Image", 'hudson' ),
					"param_name" => "show_icon_image",
					"value" => array(
						esc_html__( "Yes", 'hudson' ) => "yes",
						esc_html__( "No", 'hudson' ) => "no"
					),
					"save_always" => true,
					"description" => ""
				),

				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => esc_html__( "Header type", 'hudson' ),
					"param_name" => "header_type",
					"value" => array(
						esc_html__( "With Icon", 'hudson' ) => "with_icon",
						esc_html__( "With Image", 'hudson' ) => "with_image"
					),
					"save_always" => true,
					"description" => "",
					"dependency" => array("element" => "show_icon_image", "value" => array("yes"))
				)
			),
			$hudson_edge_icon_collections->getVCParamsArray(array("element" => "header_type", "value" => array("with_icon"))),
			array(
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Icon Color", 'hudson' ),
					"param_name" => "icon_color",
					"description" => "",
					"dependency" => array("element" => "header_type", "value" => array("with_icon"))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Icon Holder Background Color", 'hudson' ),
					"param_name" => "icon_background_color",
					"description" => "",
					"dependency" => array("element" => "header_type", "value" => array("with_icon"))
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Icon/Image Holder Padding Top (px)", 'hudson' ),
					"param_name" => "icon_padding_top",
					"value" => "",
					"dependency" => array("element" => "show_icon_image", "value" => array("yes"))
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Icon/Image Holder Padding Bottom (px)", 'hudson' ),
					"param_name" => "icon_padding_bottom",
					"value" => "",
					"dependency" => array("element" => "show_icon_image", "value" => array("yes"))
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Custom Size (px)", 'hudson' ),
					"param_name" => "custom_size",
					"value" => "",
					"dependency" => array("element" => "header_type", "value" => array("with_icon"))
				),
				array(
					"type" => "attach_image",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Header Image", 'hudson' ),
					"param_name" => "header_image",
					"description" => "",
					"dependency" => array("element" => "header_type", "value" => array("with_image"))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Content Background Color", 'hudson' ),
					"param_name" => "content_background_color",
					"description" => ""
				),
				array(
					"type" => "attach_image",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Content Background Image", 'hudson' ),
					"param_name" => "content_background_image",
					"description" => ""
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Border Around", 'hudson' ),
					"param_name" => "border",
					"value" => array(
						esc_html__( "Default", 'hudson' ) => "",
						esc_html__( "No", 'hudson' ) => "no",
						esc_html__( "Yes", 'hudson' ) => "yes"
					),
					"description" => ""
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Border width (px)", 'hudson' ),
					"param_name" => "border_width",
					"value" => "",
					"dependency" => array('element' => "border", 'value' => array('yes'))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Border color", 'hudson' ),
					"param_name" => "border_color",
					"value" => "",
					"dependency" => array('element' => "border", 'value' => array('yes'))
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Active", 'hudson' ),
					"param_name" => "active",
					"value" => array(
						esc_html__( "No", 'hudson' ) => "no",
						esc_html__( "Yes", 'hudson' ) => "yes"
					),
					"save_always" => true,
					"description" => ""
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Active Style", 'hudson' ),
					"param_name" => "active_style",
					"value" => array(
						esc_html__( "Default", 'hudson' ) => "",
						esc_html__( "Circle", 'hudson' ) => "circle",
						esc_html__( "Rectangle", 'hudson' ) => "rectangle"
					),
					"description" => "",
					"dependency" => array('element' => "active", 'value' => array('yes'))
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Active text", 'hudson' ),
					"param_name" => "active_text",
					"description" => esc_html__( "Best choice", 'hudson' ),
					"dependency" => array('element' => 'active', 'value' => 'yes')
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Active Text Color", 'hudson' ),
					"param_name" => "active_text_color",
					"dependency" => array('element' => 'active', 'value' => 'yes')
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Active Text Background Color", 'hudson' ),
					"param_name" => "active_text_background_color",
					"dependency" => array('element' => 'active', 'value' => 'yes')
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Content Text Color", 'hudson' ),
					"param_name" => "content_text_color"
				),
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Content", 'hudson' ),
					"param_name" => "content",
					"value" => "<li>" . esc_html__( 'content content content', 'hudson' ) . "</li><li>" . esc_html__( 'content content content', 'hudson' ) . "</li><li>" . esc_html__( 'content content content', 'hudson' ) . "</li>",
					"description" => ""
				)
			)
		)
	)
);


/*** Call to action ***/

$call_to_action_button_icons_array = array();
$call_to_action_button_IconCollections = $hudson_edge_icon_collections->iconCollections;
foreach($call_to_action_button_IconCollections as $collection_key => $collection) {

    $call_to_action_button_icons_array[] = array(
        "type" => "dropdown",
        "class" => "",
        "heading" => esc_html__( "Button Icon", 'hudson' ),
        "param_name" => "button_".$collection->param,
        "value" => $collection->getIconsArray(),
        "dependency" => Array('element' => "button_icon_pack", 'value' => array($collection_key))
    );

}


vc_map( array(
		"name" => esc_html__( "Call to Action", 'hudson' ),
		"base" => "no_call_to_action",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"icon" => "icon-wpb-call-to-action extended-custom-icon",
		"allowed_container_element" => 'vc_row',
		"params" => array_merge(
			array(
				array(
					"type"          => "dropdown",
					"holder"        => "div",
					"class"         => "",
					"heading" => esc_html__( "Full Width", 'hudson' ),
					"param_name"    => "full_width",
					"value"         => array(
						esc_html__( "Yes", 'hudson' ) => "yes",
						esc_html__( "No", 'hudson' ) => "no"
					),
					"save_always" => true,
					"description"   => ""
				),
				array(
					"type"          => "dropdown",
					"holder"        => "div",
					"class"         => "",
					"heading" => esc_html__( "Content in grid", 'hudson' ),
					"param_name"    => "content_in_grid",
					"value"         => array(
						esc_html__( "Yes", 'hudson' ) => "yes",
						esc_html__( "No", 'hudson' ) => "no"
					),
					"save_always" => true,
					"description"   => "",
					"dependency"    => array("element" => "full_width", "value" => "yes")
				),
				array(
					"type"          => "dropdown",
					"holder"        => "div",
					"class"         => "",
					"heading" => esc_html__( "Grid size", 'hudson' ),
					"param_name"    => "grid_size",
					"value"         => array(
						"75/25"     => "75",
						"50/50"     => "50",
						"66/33"     => "66"
					),
					"save_always" => true,
					"description"   => "",
					"dependency"    => array("element" => "content_in_grid", "value" => "yes")
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Type", 'hudson' ),
					"param_name" => "type",
					"value" => array(
						esc_html__( "Normal", 'hudson' ) => "normal",
						esc_html__( "With Icon", 'hudson' ) => "with_icon",
						esc_html__( "With Custom Icon", 'hudson' ) => "with_custom_icon"
					),
					"save_always" => true,
					"description" => ""
				)
			),
			$hudson_edge_icon_collections->getVCParamsArray(array('element' => 'type', 'value' => array('with_icon'))),
			array(
				array(
					"type" => "attach_image",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Custom Icon", 'hudson' ),
					"param_name" => "custom_icon",
					"dependency" => Array('element' => "type", 'value' => array('with_custom_icon'))
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Icon Size (px)", 'hudson' ),
					"param_name" => "icon_size",
					"description" => "",
					"dependency" => Array('element' => "type", 'value' => array('with_icon'))
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Icon Position", 'hudson' ),
					"param_name" => "icon_position",
					"value" => array(
						esc_html__( "Default/Top", 'hudson' ) => "top",
						esc_html__( "Middle", 'hudson' ) => "middle",
						esc_html__( "Bottom", 'hudson' ) => "bottom"
					),
					"save_always" => true,
					"description" => "",
					"dependency" => array('element' => 'type', 'value' => array('with_icon','with_custom_icon'))
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => esc_html__( "Icon Color", 'hudson' ),
					"param_name" => "icon_color",
					"description" => "",
					"dependency" => Array('element' => "type", 'value' => array('with_icon'))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Background Color", 'hudson' ),
					"param_name" => "background_color",
					"description" => ""
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Border Color", 'hudson' ),
					"param_name" => "border_color",
					"description" => ""
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Box Padding (top right bottom left) px", 'hudson' ),
					"param_name" => "box_padding",
					"description" => esc_html__( "Default padding is 20px on all sides", 'hudson' )
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Default Text Font Size (px)", 'hudson' ),
					"param_name" => "text_size",
					"description" => esc_html__( "Font size for p tag", 'hudson' )
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Show Button", 'hudson' ),
					"param_name" => "show_button",
					"value" => array(
						esc_html__( "Yes", 'hudson' ) => "yes",
						esc_html__( "No", 'hudson' ) => "no"
					),
					"save_always" => true,
					"description" => ""
				),
				array(
                    "type" => "dropdown",
                    "holder" => "div",
                    "class" => "",
                    "heading" => esc_html__( "Hover Animation", 'hudson' ),
                    "param_name" => "button_hover_animation",
                    "value" => array(
                        esc_html__( "Default", 'hudson' ) => "default",
						esc_html__( "Disable Animation", 'hudson' ) => "disable_animation",
                        esc_html__( "Fill From Top", 'hudson' ) => "fill_from_top",
						esc_html__( "Fill From Left", 'hudson' ) => "fill_from_left",
						esc_html__( "Fill From Bottom", 'hudson' ) => "fill_from_bottom",
						esc_html__( "Fill Diagonal", 'hudson' ) => "fill_diagonal"
                    ),
					"save_always" => true,
                    "dependency" => array('element' => 'show_button', 'value' => 'yes')
                ),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Position", 'hudson' ),
					"param_name" => "button_position",
					"value" => array(
						esc_html__( "Default/right", 'hudson' ) => "",
						esc_html__( "Center", 'hudson' ) => "center",
						esc_html__( "Left", 'hudson' ) => "left"
					),
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Size", 'hudson' ),
					"param_name" => "button_size",
					"value" => array(
						esc_html__( "Default", 'hudson' ) => "",
						esc_html__( "Small", 'hudson' ) => "small",
						esc_html__( "Medium", 'hudson' ) => "medium",
						esc_html__( "Large", 'hudson' ) => "large",
						esc_html__( "Extra Large", 'hudson' ) => "big_large"
					),
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Text", 'hudson' ),
					"param_name" => "button_text",
					"description" => esc_html__( "Default text is button", 'hudson' ),
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Link", 'hudson' ),
					"param_name" => "button_link",
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Target", 'hudson' ),
					"param_name" => "button_target",
					"value" => array(
						"" => "",
						esc_html__( "Self", 'hudson' ) => "_self",
						esc_html__( "Blank", 'hudson' ) => "_blank"
					),
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Text Color", 'hudson' ),
					"param_name" => "button_text_color",
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Hover Text Color", 'hudson' ),
					"param_name" => "button_hover_text_color",
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Background Color", 'hudson' ),
					"param_name" => "button_background_color",
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				 array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Hover Background Color", 'hudson' ),
					"param_name" => "button_hover_background_color",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Border Color", 'hudson' ),
					"param_name" => "button_border_color",
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Hover Border Color", 'hudson' ),
					"param_name" => "button_hover_border_color",
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Button Border Width", 'hudson' ),
					"param_name" => "button_border_width",
					"description" => "",
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Border Radius px", 'hudson' ),
					"param_name" => "border_radius",
					"description" => esc_html__( "Border radius for button", 'hudson' ),
					"dependency" => array('element' => 'show_button', 'value' => array('yes'))
				),
                array(
                    "type" => "dropdown",
                    "holder" => "div",
                    "class" => "",
                    "heading" => esc_html__( "Button Icon Pack", 'hudson' ),
                    "param_name" => "button_icon_pack",
                    "value" => array_merge(array("No Icon" => ""),$hudson_edge_icon_collections->getIconCollectionsVC())
                )
            ),
            $call_to_action_button_icons_array,
            array(
                array(
                    "type" => "textfield",
                    "holder" => "div",
                    "class" => "",
                    "heading" => esc_html__( "Icon Size", 'hudson' ),
                    "param_name" => "button_icon_size",
                    "description" => "",
                    "dependency" => Array('element' => "button_icon_pack", 'not_empty' => true)
                ),
                array(
                    "type" => "colorpicker",
                    "class" => "",
                    "heading" => esc_html__( "Icon Color", 'hudson' ),
                    "param_name" => "button_icon_color",
                    "description" => "",
                    "dependency" => Array('element' => "button_icon_pack", 'not_empty' => true)
                ),
				array(
                    "type" => "colorpicker",
                    "class" => "",
                    "heading" => esc_html__( "Icon Hover Color", 'hudson' ),
                    "param_name" => "button_icon_hover_color",
                    "description" => "",
                    "dependency" => Array('element' => "button_icon_pack", 'not_empty' => true)
                ),
				array(
					"type" => "textarea_html",
					"holder" => "div",
					"class" => "",
					"heading" => esc_html__( "Content", 'hudson' ),
					"param_name" => "content",
					"value" => "<p>".esc_html__("I am test text for Call to action.", "hudson")."</p>",
					"description" => ""
				)
			)
			)
    )
);


/*** Message shortcode ***/

vc_map( array(
	"name" => esc_html__( "Message", 'hudson' ),
	"base" => "no_message",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-message extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
		array(
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Type", 'hudson' ),
				"param_name" => "type",
				"value" => array(
					esc_html__( "Normal", 'hudson' ) => "normal",
					esc_html__( "With Icon", 'hudson' ) => "with_icon",
					esc_html__( "With Custom Icon", 'hudson' ) => "with_custom_icon"
				),
				"save_always" => true
			)
		),
		$hudson_edge_icon_collections->getVCParamsArray(array('element' => "type", 'value' => array('with_icon'))),
		array(
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Icon Position", 'hudson' ),
				"param_name" => "icon_position",
				"value" => array(
					esc_html__( "Right", 'hudson' ) => "right",
					esc_html__( "Left", 'hudson' ) => "left"
				),
				"save_always" => true,
				"dependency" => Array('element' => $hudson_edge_icon_collections->iconPackParamName, 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Icon Position", 'hudson' ),
				"param_name" => "custom_icon_position",
				"value" => array(
					esc_html__( "Right", 'hudson' ) => "right",
					esc_html__( "Left", 'hudson' ) => "left"
				),
				"save_always" => true,
				"dependency" => Array('element' => 'type', 'value' => array('with_custom_icon'))
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Size", 'hudson' ),
				"param_name" => "icon_size",
				"value" => $hudson_edge_icon_collections->getIconSizesArray(),
				"save_always" => true,
				"description" => "",
				"dependency" => Array('element' => "type", 'value' => array('with_icon'))
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Custom Size (px)", 'hudson' ),
				"param_name" => "icon_custom_size",
				"value" => "",
				"dependency" => Array('element' => "type", 'value' => array('with_icon'))
			),
			array(
				"type" => "colorpicker",
				"class" => "",
				"heading" => esc_html__( "Icon Color", 'hudson' ),
				"param_name" => "icon_color",
				"description" => "",
				"dependency" => Array('element' => "type", 'value' => array('with_icon'))
			),
			array(
				"type" => "colorpicker",
				"class" => "",
				"heading" => esc_html__( "Icon Background Color", 'hudson' ),
				"param_name" => "icon_background_color",
				"description" => "",
				"dependency" => Array('element' => "type", 'value' => array('with_icon'))
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Custom Icon", 'hudson' ),
				"param_name" => "custom_icon",
				"dependency" => Array('element' => "type", 'value' => array('with_custom_icon'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Background Color", 'hudson' ),
				"param_name" => "background_color",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Color", 'hudson' ),
				"param_name" => "border_color",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Width (px)", 'hudson' ),
				"param_name" => "border_width",
				"description" => esc_html__( "Default value is 1", 'hudson' )
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Close Button Color", 'hudson' ),
				"param_name" => "close_button_color",
				"description" => esc_html__( "Default color is #fff", 'hudson' )
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Close Button Hover Color", 'hudson' ),
				"param_name" => "close_button_hover_color",
				"description" => esc_html__( "Default color is #279eef", 'hudson' )
			),
			array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Content", 'hudson' ),
				"param_name" => "content",
				"value" => "<p>".esc_html__("I am test text for Message shortcode.", "hudson")."</p>",
				"description" => ""
			)
		)
	)
) );


/*** Blockquote ***/

vc_map( array(
		"name" => esc_html__( "Blockquote", 'hudson' ),
		"base" => "no_blockquote",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"icon" => "icon-wpb-blockquote extended-custom-icon",
		"allowed_container_element" => 'vc_row',
		"params" => array(
			array(
				"type" => "textarea",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text", 'hudson' ),
				"param_name" => "text",
				"value" => esc_html__("Blockquote text", "hudson"),
				'save_always' => true
			),
            array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text Color", 'hudson' ),
				"param_name" => "text_color",
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title tag", 'hudson' ),
				"param_name" => "title_tag",
				"value" => array(
					""   => "",
					"h2" => "h2",
					"h3" => "h3",
					"h4" => "h4",
					"h5" => "h5",
					"h6" => "h6",
				),
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Width", 'hudson' ),
				"param_name" => "width",
				"description" => esc_html__( "Width (%)", 'hudson' )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Line Height", 'hudson' ),
				"param_name" => "line_height",
				"description" => esc_html__( "Line Height (px)", 'hudson' )
			),
            array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Background Color", 'hudson' ),
				"param_name" => "background_color",
				"description" => ""
			),
             array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Show Border", 'hudson' ),
                "param_name" => "show_border",
                "value" => array(
                    esc_html__( "Yes", 'hudson' ) => "yes",
                    esc_html__( "No", 'hudson' ) => "no"
                ),
				"save_always" => true,
                "description" => ""
            ),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Color", 'hudson' ),
				"param_name" => "border_color",
				"description" => "",
                "dependency" => array('element' => "show_border", 'value' => 'yes')
			),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Border width (px)", 'hudson' ),
                "param_name" => "border_width",
                "description" => "",
                "dependency" => array('element' => "show_border", 'value' => 'yes')
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Border Right Margin (px)", 'hudson' ),
                "param_name" => "border_right_margin",
                "description" => "",
                "dependency" => array('element' => "show_border", 'value' => 'yes')
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Show Quote Icon", 'hudson' ),
                "param_name" => "show_quote_icon",
                "value" => array(
                    esc_html__( "Yes", 'hudson' ) => "yes",
                    esc_html__( "No", 'hudson' ) => "no"
                ),
				"save_always" => true,
                "description" => ""
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Use Custom Icon or Font", 'hudson' ),
                "param_name" => "quote_icon_font",
                "value" => array(
                    esc_html__( "No", 'hudson' ) => "",
                    esc_html__( "Use Specific Font", 'hudson' ) => "font_family",
                    esc_html__( "Use Icon", 'hudson' ) => "with_icon"
                ),
                "description" => "",
                "dependency" => array('element' => "show_quote_icon", 'value' => 'yes')
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Quote Icon Font", 'hudson' ),
                "param_name" => "quote_font_family",
                "dependency" => Array('element' => "quote_icon_font", 'value' => 'font_family')
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Quote Icon Pack", 'hudson' ),
                "param_name" => "quote_icon_pack",
                "value" => array_merge(array("" => ""),$hudson_edge_icon_collections->getIconCollectionsVCExclude(array('linea_icons', 'dripicons', 'simple_line_icons'))),
                "dependency" => Array('element' => "quote_icon_font", 'value' => 'with_icon')
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Quote Icon Color", 'hudson' ),
                "param_name" => "quote_icon_color",
                "description" => "",
                "dependency" => array('element' => "show_quote_icon", 'value' => 'yes')
            ),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Quote Icon Size (px)", 'hudson' ),
				"param_name" => "quote_icon_size",
                "dependency" => array('element' => "show_quote_icon", 'value' => 'yes')
			)
		)
) );


/*** Custom Font ***/

vc_map( array(
	"name" => esc_html__( "Custom Font", 'hudson' ),
	"base" => "no_custom_font",
	"icon" => "icon-wpb-custom-font extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Font family", 'hudson' ),
			"param_name" => "font_family",
			"value" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Font size", 'hudson' ),
			"param_name" => "font_size",
			"value" => "",
			'save_always' => true
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Line height", 'hudson' ),
			"param_name" => "line_height",
			"value" => "",
			'save_always' => true
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Font Style", 'hudson' ),
			"param_name" => "font_style",
			"value" => array(
				esc_html__( "Normal", 'hudson' ) => "normal",
				esc_html__( "Italic", 'hudson' ) => "italic"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text Align", 'hudson' ),
			"param_name" => "text_align",
			"value" => array(
				esc_html__( "Left", 'hudson' ) => "left",
				esc_html__( "Center", 'hudson' ) => "center",
				esc_html__( "Right", 'hudson' ) => "right"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Font weight", 'hudson' ),
			"param_name" => "font_weight",
			"value" => "300",
			'save_always' => true
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Color", 'hudson' ),
			"param_name" => "color",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text decoration", 'hudson' ),
			"param_name" => "text_decoration",
			"value" => array(
				esc_html__( "None", 'hudson' ) => "none",
				esc_html__( "Underline", 'hudson' ) => "underline",
				esc_html__( "Overline", 'hudson' ) => "overline",
				esc_html__( "Line Through", 'hudson' ) => "line-through"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text transform", 'hudson' ),
			"param_name" => "text_transform",
			"value" => array(
				esc_html__( "None", 'hudson' ) => "none",
				esc_html__( "Uppercase", 'hudson' ) => "uppercase",
				esc_html__( "Lowercase", 'hudson' ) => "lowercase",
				esc_html__( "Capitalize", 'hudson' ) => "capitalize"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text shadow", 'hudson' ),
			"param_name" => "text_shadow",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Letter Spacing (px)", 'hudson' ),
			"param_name" => "letter_spacing",
			"value" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background Color", 'hudson' ),
			"param_name" => "background_color",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Padding", 'hudson' ),
			"param_name" => "padding",
			"value" => "0",
			"description" =>  esc_html__("Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson')
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Margin", 'hudson' ),
			"param_name" => "margin",
			"value" => "0",
			"description" =>  esc_html__("Please insert margin in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson')
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show in border box", 'hudson' ),
			"param_name" => "show_in_border_box",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "no",
				esc_html__( "Yes", 'hudson' ) => "yes"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border Color", 'hudson' ),
			"param_name" => "border_color",
			"description" => "",
			"dependency" => array('element' => 'show_in_border_box', 'value' => 'yes')
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border Thickness (px)", 'hudson' ),
			"param_name" => "border_width",
			"value" => "",
			"dependency" => array('element' => 'show_in_border_box', 'value' => 'yes')
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text background Color", 'hudson' ),
			"param_name" => "text_background_color",
			"value" => "",
			"dependency" => array('element' => 'show_in_border_box', 'value' => 'yes')
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text padding (px)", 'hudson' ),
			"param_name" => "text_padding",
			"value" => "",
			"description" =>  esc_html__("Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson'),
			"dependency" => array('element' => 'show_in_border_box', 'value' => 'yes')
		),
		array(
			"type" => "textarea_html",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Content", 'hudson' ),
			"param_name" => "content",
			"value" => "<p>" . esc_html__( 'content content content', 'hudson' ) . "</p>",
			"description" => ""
		)
	)
) );


/*** Button shortcode **/

vc_map( array(
		"name" => esc_html__( "Button", 'hudson' ),
		"base" => "no_button",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"icon" => "icon-wpb-button extended-custom-icon",
		"allowed_container_element" => 'vc_row',
		"params" => array_merge(
                    array(
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Size", 'hudson' ),
                            "param_name" => "size",
                            "value" => array(
                                esc_html__( "Default", 'hudson' ) => "",
                                esc_html__( "Small", 'hudson' ) => "small",
                                esc_html__( "Medium", 'hudson' ) => "medium",
                                esc_html__( "Large", 'hudson' ) => "large",
                                esc_html__( "Extra Large", 'hudson' ) => "big_large",
                                esc_html__( "Extra Large Full Width", 'hudson' ) => "big_large_full_width"
                            )
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Style", 'hudson' ),
                            "param_name" => "style",
                            "value" => array(
                                esc_html__( "Default", 'hudson' ) => "",
                                esc_html__( "White", 'hudson' ) => "white"
                            )
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Text", 'hudson' ),
                            "param_name" => "text",
                            "description" => esc_html__( "Default text is button", 'hudson' )
                        ),
						 array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Hover Animation", 'hudson' ),
                            "param_name" => "button_hover_animation",
                            "value" => array(
                                esc_html__( "Default", 'hudson' ) => "default",
								esc_html__( "Disable Animation", 'hudson' ) => "disable_animation",
                                esc_html__( "Fill From Top", 'hudson' ) => "fill_from_top",
								esc_html__( "Fill From Left", 'hudson' ) => "fill_from_left",
								esc_html__( "Fill From Bottom", 'hudson' ) => "fill_from_bottom",
								esc_html__( "Fill Diagonal", 'hudson' ) => "fill_diagonal"
                            ),
							"save_always" => true,
                            "dependency" => array('element' => 'style', 'value' => array("","white"))
                        )

                    ),
                    $hudson_edge_icon_collections->getVCParamsArray(array(), '', true),
                    array(
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Hover Animation", 'hudson' ),
                            "param_name" => "hover_animation",
                            "value" => array(
                                esc_html__( "Default", 'hudson' ) => "",
                                esc_html__( "Move Icon", 'hudson' ) => "move_icon"
                            ),
                            "dependency" => Array('element' => $hudson_edge_icon_collections->iconPackParamName, 'not_empty' => true)
                        ),

                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Button Width (px)", 'hudson' ),
                            "param_name" => "button_width",
                            "dependency" => array('element' => "hover_animation", 'value' => array('move_icon'))

                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Icon Position", 'hudson' ),
                            "param_name" => "icon_position",
                            "value" => array(
                                esc_html__( "Right", 'hudson' ) => "right",
                                esc_html__( "Left", 'hudson' ) => "left"
                            ),
							"save_always" => true,
                            "dependency" => Array('element' => $hudson_edge_icon_collections->iconPackParamName, 'not_empty' => true)
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Color", 'hudson' ),
                            "param_name" => "icon_color",
                            "dependency" => Array('element' =>$hudson_edge_icon_collections->iconPackParamName, 'not_empty' => true)
                        ),
						array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Hover Color", 'hudson' ),
                            "param_name" => "icon_hover_color",
                            "dependency" => Array('element' =>$hudson_edge_icon_collections->iconPackParamName, 'not_empty' => true)
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Background Color", 'hudson' ),
                            "param_name" => "icon_background_color",
                            "dependency" => Array('element' =>$hudson_edge_icon_collections->iconPackParamName, 'not_empty' => true)
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Background Hover Color", 'hudson' ),
                            "param_name" => "icon_background_hover_color",
                            "dependency" => Array('element' =>$hudson_edge_icon_collections->iconPackParamName, 'not_empty' => true)
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Link", 'hudson' ),
                            "param_name" => "link"
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Link Target", 'hudson' ),
                            "param_name" => "target",
                            "value" => array(
                                esc_html__( "Self", 'hudson' ) => "_self",
                                esc_html__( "Blank", 'hudson' ) => "_blank"
                            ),
							"save_always" => true
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Color", 'hudson' ),
                            "param_name" => "color"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Hover Color", 'hudson' ),
                            "param_name" => "hover_color"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Background Color", 'hudson' ),
                            "param_name" => "background_color"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Hover Background Color", 'hudson' ),
                            "param_name" => "hover_background_color"
                        ),
						array(
							"type" => "attach_image",
							"holder" => "div",
							"class" => "",
							"heading" => esc_html__( "Background Pattern", 'hudson' ),
							"param_name" => "background_pattern"
						),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Border Color", 'hudson' ),
                            "param_name" => "border_color"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Hover Border Color", 'hudson' ),
                            "param_name" => "hover_border_color"
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Border Width (px)", 'hudson' ),
                            "param_name" => "border_width"
                        ),
						array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Font Size (px)", 'hudson' ),
                            "param_name" => "font_size"                            
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Font Family", 'hudson' ),
                            "param_name" => "font_family",
                            "description" => ""
                        ),
						array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Line Height (px)", 'hudson' ),
                            "param_name" => "line_height"
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Font Style", 'hudson' ),
                            "param_name" => "font_style",
                            "value" => array(
                                "" => "",
                                esc_html__( "Normal", 'hudson' ) => "normal",
                                esc_html__( "Italic", 'hudson' ) => "italic"
                            )
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Font Weight", 'hudson' ),
                            "param_name" => "font_weight",
                            "value" => $font_weight_array
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Letter spacing (px)", 'hudson' ),
                            "param_name" => "letter_spacing"
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Text Transform", 'hudson' ),
                            "param_name" => "text_transform",
                            "value" => array(
                                esc_html__( "Default", 'hudson' ) => "",
                                esc_html__( "None", 'hudson' ) => "none",
                                esc_html__( "Capitalize", 'hudson' ) => "capitalize",
                                esc_html__( "Uppercase", 'hudson' ) => "uppercase",
                                esc_html__( "Lowercase", 'hudson' ) => "lowercase"
                            )
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Margin", 'hudson' ),
                            "param_name" => "margin",
                            "description" => esc_html__("Please insert margin in format: 0px 0px 1px 0px", 'hudson')
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Left/Right Padding (px)", 'hudson' ),
                            "param_name" => "padding",
                            "description" => ""
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Border radius", 'hudson' ),
                            "param_name" => "border_radius",
                            "description" => esc_html__("Please insert border radius(Rounded corners) in px. For example: 4 ", 'hudson')
                        )
                    )
                )
    )
);


/*** Counter ***/

vc_map( array(
	"name" => esc_html__( "Counter", 'hudson' ),
	"base" => "no_counter",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	'admin_enqueue_css' => array(hudson_edge_get_skin_uri().'/assets/css/edgtf-vc-extend.css'),
	"icon" => "icon-wpb-counter extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Type", 'hudson' ),
			"param_name" => "type",
			"value" => array(
				esc_html__( "Zero Counter", 'hudson' ) => "zero",
				esc_html__( "Random Counter", 'hudson' ) => "random"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Box", 'hudson' ),
			"param_name" => "box",
			"value" => array(
				"" => "",
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Box Border Color", 'hudson' ),
			"param_name" => "box_border_color",
			"description" => "",
			"dependency" => array('element' => "box", 'value' => array('yes'))
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Position", 'hudson' ),
			"param_name" => "position",
			"value" => array(
				esc_html__( "Left", 'hudson' ) => "left",
				esc_html__( "Right", 'hudson' ) => "right",
				esc_html__( "Center", 'hudson' ) => "center"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Digit", 'hudson' ),
			"param_name" => "digit",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Underline Digit", 'hudson' ),
			"param_name" => "underline_digit",
			"value" => array(
				"" => "",
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Digit Font Size (px)", 'hudson' ),
			"param_name" => "font_size",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Digit Font Weight", 'hudson' ),
			"param_name" => "font_weight",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Thin 100", 'hudson' ) => "100",
				esc_html__( "Extra-Light 200", 'hudson' ) => "200",
				esc_html__( "Light 300", 'hudson' ) => "300",
				esc_html__( "Regular 400", 'hudson' ) => "400",
				esc_html__( "Medium 500", 'hudson' ) => "500",
				esc_html__( "Semi-Bold 600", 'hudson' ) => "600",
				esc_html__( "Bold 700", 'hudson' ) => "700",
				esc_html__( "Extra-Bold 800", 'hudson' ) => "800",
				esc_html__( "Ultra-Bold 900", 'hudson' ) => "900"
			),
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Digit Letter Spacing (px)", 'hudson' ),
			"param_name" => "digit_letter_spacing",
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Digit Font Color", 'hudson' ),
			"param_name" => "font_color",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title", 'hudson' ),
			"param_name" => "title",
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Color", 'hudson' ),
			"param_name" => "title_color",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Tag", 'hudson' ),
			"param_name" => "title_tag",
			"value" => array(
				""   => "",
				"h2" => "h2",
				"h3" => "h3",
				"h4" => "h4",
				"h5" => "h5",
				"h6" => "h6",
			),
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Size (px)", 'hudson' ),
			"param_name" => "title_size",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Top Margin (px)", 'hudson' ),
			"param_name" => "title_margin_top",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text", 'hudson' ),
			"param_name" => "text",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text Size (px)", 'hudson' ),
			"param_name" => "text_size",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text Font Weight", 'hudson' ),
			"param_name" => "text_font_weight",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Thin 100", 'hudson' ) => "100",
				esc_html__( "Extra-Light 200", 'hudson' ) => "200",
				esc_html__( "Light 300", 'hudson' ) => "300",
				esc_html__( "Regular 400", 'hudson' ) => "400",
				esc_html__( "Medium 500", 'hudson' ) => "500",
				esc_html__( "Semi-Bold 600", 'hudson' ) => "600",
				esc_html__( "Bold 700", 'hudson' ) => "700",
				esc_html__( "Extra-Bold 800", 'hudson' ) => "800",
				esc_html__( "Ultra-Bold 900", 'hudson' ) => "900"
			)
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text Transform", 'hudson' ),
			"param_name" => "text_transform",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "None", 'hudson' ) => "none",
				esc_html__( "Capitalize", 'hudson' ) => "capitalize",
				esc_html__( "Uppercase", 'hudson' ) => "uppercase",
				esc_html__( "Lowercase", 'hudson' ) => "lowercase"
			),
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text Color", 'hudson' ),
			"param_name" => "text_color",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator", 'hudson' ),
			"param_name" => "separator",
			"value" => array(
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Position", 'hudson' ),
			"param_name" => "separator_position",
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Above Title", 'hudson' ) => "above_title",
				esc_html__( "Under Title", 'hudson' ) => "under_title",
			),
			"description" => "",
			"dependency" => array('element' => "separator", 'value' => array('yes'))
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Color", 'hudson' ),
			"param_name" => "separator_color",
			"description" => "",
			"dependency" => array('element' => "separator", 'value' => array('yes'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Thickness (px)", 'hudson' ),
			"param_name" => "separator_thickness",
			"description" => "",
			"dependency" => array('element' => "separator", 'value' => array('yes'))
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Separator Border Style", 'hudson' ),
			"param_name" => "separator_border_style",
			"value" => array(
				"" => "",
				esc_html__( "Dashed", 'hudson' ) => "dashed",
				esc_html__( "Solid", 'hudson' ) => "solid"
			),
			"description" => "",
			"dependency" => array('element' => "separator", 'value' => array('yes'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Padding Bottom(px)", 'hudson' ),
			"param_name" => "padding_bottom",
			"description" => ""
		),
	)
) );


/*** Countdown ***/

vc_map( array(
	"name" => esc_html__( "Countdown", 'hudson' ),
	"base" => "no_countdown",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-countdown extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Year", 'hudson' ),
			"param_name" => "year",
			"value" => array(
				"" => "",
				"2014" => "2014",
				"2015" => "2015",
				"2016" => "2016",
				"2017" => "2017",
				"2018" => "2018",
				"2019" => "2019",
				"2020" => "2020"
			),
            "save_always" => true
		),

		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Month", 'hudson' ),
			"param_name" => "month",
			"value" => array(
				"" => "",
				esc_html__( "January", 'hudson' ) => "1",
				esc_html__( "February", 'hudson' ) => "2",
				esc_html__( "March", 'hudson' ) => "3",
				esc_html__( "April", 'hudson' ) => "4",
				esc_html__( "May", 'hudson' ) => "5",
				esc_html__( "June", 'hudson' ) => "6",
				esc_html__( "July", 'hudson' ) => "7",
				esc_html__( "August", 'hudson' ) => "8",
				esc_html__( "September", 'hudson' ) => "9",
				esc_html__( "October", 'hudson' ) => "10",
				esc_html__( "November", 'hudson' ) => "11",
				esc_html__( "December", 'hudson' ) => "12"
			),
            "save_always" => true
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Day", 'hudson' ),
			"param_name" => "day",
			"value" => array(
				"" => "",
				"1" => "1",
				"2" => "2",
				"3" => "3",
				"4" => "4",
				"5" => "5",
				"6" => "6",
				"7" => "7",
				"8" => "8",
				"9" => "9",
				"10" => "10",
				"11" => "11",
				"12" => "12",
				"13" => "13",
				"14" => "14",
				"15" => "15",
				"16" => "16",
				"17" => "17",
				"18" => "18",
				"19" => "19",
				"20" => "20",
				"21" => "21",
				"22" => "22",
				"23" => "23",
				"24" => "24",
				"25" => "25",
				"26" => "26",
				"27" => "27",
				"28" => "28",
				"29" => "29",
				"30" => "30",
				"31" => "31",
			),
            "save_always" => true
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Hour", 'hudson' ),
			"param_name" => "hour",
			"value" => array(
				"" => "",
				"0" => "0",
				"1" => "1",
				"2" => "2",
				"3" => "3",
				"4" => "4",
				"5" => "5",
				"6" => "6",
				"7" => "7",
				"8" => "8",
				"9" => "9",
				"10" => "10",
				"11" => "11",
				"12" => "12",
				"13" => "13",
				"14" => "14",
				"15" => "15",
				"16" => "16",
				"17" => "17",
				"18" => "18",
				"19" => "19",
				"20" => "20",
				"21" => "21",
				"22" => "22",
				"23" => "23",
				"24" => "24"
			),
            "save_always" => true
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Minute", 'hudson' ),
			"param_name" => "minute",
			"value" => array(
				"" => "",
				"0" => "0",
				"1" => "1",
				"2" => "2",
				"3" => "3",
				"4" => "4",
				"5" => "5",
				"6" => "6",
				"7" => "7",
				"8" => "8",
				"9" => "9",
				"10" => "10",
				"11" => "11",
				"12" => "12",
				"13" => "13",
				"14" => "14",
				"15" => "15",
				"16" => "16",
				"17" => "17",
				"18" => "18",
				"19" => "19",
				"20" => "20",
				"21" => "21",
				"22" => "22",
				"23" => "23",
				"24" => "24",
				"25" => "25",
				"26" => "26",
				"27" => "27",
				"28" => "28",
				"29" => "29",
				"30" => "30",
				"31" => "31",
				"32" => "32",
				"33" => "33",
				"34" => "34",
				"35" => "35",
				"36" => "36",
				"37" => "37",
				"38" => "38",
				"39" => "39",
				"40" => "40",
				"41" => "41",
				"42" => "42",
				"43" => "43",
				"44" => "44",
				"45" => "45",
				"46" => "46",
				"47" => "47",
				"48" => "48",
				"49" => "49",
				"50" => "50",
				"51" => "51",
				"52" => "52",
				"53" => "53",
				"54" => "54",
				"55" => "55",
				"56" => "56",
				"57" => "57",
				"58" => "58",
				"59" => "59",
				"60" => "60",
			),
            "save_always" => true
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Month Label", 'hudson' ),
			"param_name" => "month_label",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Day Label", 'hudson' ),
			"param_name" => "day_label",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Hour Label", 'hudson' ),
			"param_name" => "hour_label",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Minute Label", 'hudson' ),
			"param_name" => "minute_label",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Second Label", 'hudson' ),
			"param_name" => "second_label",
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Color", 'hudson' ),
			"param_name" => "color",
			"description" => esc_html__( "For digits, labels and separators", 'hudson' ),
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Digit Font Size (px)", 'hudson' ),
			"param_name" => "digit_font_size",
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Label Font Size (px)", 'hudson' ),
			"param_name" => "label_font_size",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Font Weight", 'hudson' ),
			"param_name" => "font_weight",
			"description" => esc_html__( "For both digits and labels", 'hudson' ),
			"value" => array(
				esc_html__( "Default", 'hudson' ) => "",
				esc_html__( "Thin 100", 'hudson' ) => "100",
				esc_html__( "Extra-Light 200", 'hudson' ) => "200",
				esc_html__( "Light 300", 'hudson' ) => "300",
				esc_html__( "Regular 400", 'hudson' ) => "400",
				esc_html__( "Medium 500", 'hudson' ) => "500",
				esc_html__( "Semi-Bold 600", 'hudson' ) => "600",
				esc_html__( "Bold 700", 'hudson' ) => "700",
				esc_html__( "Extra-Bold 800", 'hudson' ) => "800",
				esc_html__( "Ultra-Bold 900", 'hudson' ) => "900"
			)
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Show separator", 'hudson' ),
			"param_name" => "show_separator",
			"value" => array(
				esc_html__( "No", 'hudson' ) => "hide_separator",
				esc_html__( "Yes", 'hudson' ) => "show_separator"
			),
			"save_always" => true
		),
	)
) );


/*** Pie Chart ***/

vc_map( array(
		"name" => esc_html__( "Pie Chart", 'hudson' ),
		"base" => "no_pie_chart",
		"icon" => "icon-wpb-pie-chart extended-custom-icon",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"allowed_container_element" => 'vc_row',
		"params" => array(
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Size(px)", 'hudson' ),
                "param_name" => "size",
                "description" => ""
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__( "Type of Central text", 'hudson' ),
                "param_name" => "type_of_central_text",
                "value" => array(
                    esc_html__( "Title", 'hudson' ) => "title",
                    esc_html__( "Percent", 'hudson' ) => "percent"
                ),
            ),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage", 'hudson' ),
				"param_name" => "percent",
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Show Percentage Mark", 'hudson' ),
				"param_name" => "show_percent_mark",
				"value" => array(
					esc_html__( "Yes", 'hudson' ) => "with_mark",
					esc_html__( "No", 'hudson' ) => "without_mark"
				),
				"save_always" => true,
				"dependency" => Array('element' => "percent", 'not_empty' => true)
            ),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage Color", 'hudson' ),
				"param_name" => "percentage_color",
				"dependency" => Array('element' => "percent", 'not_empty' => true)
			),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Percentage Font", 'hudson' ),
                "param_name" => "percent_font_family",
                "dependency" => Array('element' => "percent", 'not_empty' => true)
            ),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage Font Size", 'hudson' ),
				"param_name" => "percent_font_size",
				"dependency" => Array('element' => "percent", 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage Font weight", 'hudson' ),
				"param_name" => "percent_font_weight",
				"value" => array(
					esc_html__( "Default", 'hudson' ) => "",
					esc_html__( "Thin 100", 'hudson' ) => "100",
					esc_html__( "Extra-Light 200", 'hudson' ) => "200",
					esc_html__( "Light 300", 'hudson' ) => "300",
					esc_html__( "Regular 400", 'hudson' ) => "400",
					esc_html__( "Medium 500", 'hudson' ) => "500",
					esc_html__( "Semi-Bold 600", 'hudson' ) => "600",
					esc_html__( "Bold 700", 'hudson' ) => "700",
					esc_html__( "Extra-Bold 800", 'hudson' ) => "800",
					esc_html__( "Ultra-Bold 900", 'hudson' ) => "900"
				),
				"dependency" => Array('element' => "percent", 'not_empty' => true)
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Bar Active Color", 'hudson' ),
				"param_name" => "active_color",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Bar Inactive Color", 'hudson' ),
				"param_name" => "noactive_color",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Pie Chart Line Width (px)", 'hudson' ),
				"param_name" => "line_width",
				"description" => ""
			),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__( "Chart Alignment", 'hudson' ),
                "param_name" => "chart_alignment",
                "value" => array(
                    esc_html__( "Center", 'hudson' ) => "",
                    esc_html__( "Left", 'hudson' ) => "left",
                    esc_html__( "Right", 'hudson' ) => "right"
                ),
                "description" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Margin below chart (px)", 'hudson' ),
                "param_name" => "margin_below_chart",
                "description" => ""
            ),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title", 'hudson' ),
				"param_name" => "title",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Color", 'hudson' ),
				"param_name" => "title_color",
				"description" => ""
			),
            array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Title Tag", 'hudson' ),
				"param_name" => "title_tag",
				"value" => array(
                    ""   => "",
					"h2" => "h2",
					"h3" => "h3",
					"h4" => "h4",	
					"h5" => "h5",	
					"h6" => "h6",	
				),
				"description" => ""
            ),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text", 'hudson' ),
				"param_name" => "text",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text Color", 'hudson' ),
				"param_name" => "text_color",
				"description" => ""
			),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Separator", 'hudson' ),
                "param_name" => "separator",
                "value" => array(
                    esc_html__( "Yes", 'hudson' ) => "yes",
                    esc_html__( "No", 'hudson' ) => "no"
                ),
				"save_always" => true,
                "description" => ""
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Separator Color", 'hudson' ),
                "param_name" => "separator_color",
                "description" => "",
                "dependency" => array('element' => "separator", 'value' => array('yes'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Separator Border Style", 'hudson' ),
                "param_name" => "separator_border_style",
                "value" => array(
                    "" => "",
                    esc_html__( "Dashed", 'hudson' ) => "dashed",
                    esc_html__( "Solid", 'hudson' ) => "solid"
                ),
                "description" => "",
                "dependency" => array('element' => "separator", 'value' => array('yes'))
            )
		)
) );


/*** Pie Chart 2 (Pie) ***/

vc_map( array(
		"name" => esc_html__( "Pie Chart 2 (Pie)", 'hudson' ),
		"base" => "no_pie_chart2",
		"icon" => "icon-wpb-pie-chart2 extended-custom-icon",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"allowed_container_element" => 'vc_row',
		"params" => array(
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Width", 'hudson' ),
				"param_name" => "width",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Height", 'hudson' ),
				"param_name" => "height",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Legend Text Color", 'hudson' ),
				"param_name" => "color",
				"description" => ""
			),
			array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Content", 'hudson' ),
				"param_name" => "content",
				"value" => "15,#D2B5A0,Legend One; 35,#C09678,Legend Two; 50,#B48360,Legend Three",
				"description" => ""
			)

		)
) );


/*** Pie Chart 3 (Doughnut) ***/

vc_map( array(
		"name" => esc_html__( "Pie Chart 3 (Doughnut)", 'hudson' ),
		"base" => "no_pie_chart3",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"icon" => "icon-wpb-pie-chart3 extended-custom-icon",
		"allowed_container_element" => 'vc_row',
		"params" => array(
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Width", 'hudson' ),
				"param_name" => "width",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Height", 'hudson' ),
				"param_name" => "height",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Legend Text Color", 'hudson' ),
				"param_name" => "color",
				"description" => ""
			),
			array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Content", 'hudson' ),
				"param_name" => "content",
				"value" => "15,#C09678,Legend One; 35,#D2B5A0,Legend Two; 50,#B48360,Legend Three",
				"description" => ""
			)

		)
) );


/*** Pie Chart With Icon ***/

vc_map( array(
	"name" => esc_html__( "Pie Chart With Icon", 'hudson' ),
	"base" => "no_pie_chart_with_icon",
	"icon" => "icon-wpb-pie-chart-with-icon extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
		array(
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Size(px)", 'hudson' ),
				"param_name" => "size",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage", 'hudson' ),
				"param_name" => "percent",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Bar Active Color", 'hudson' ),
				"param_name" => "active_color",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Bar Inactive Color", 'hudson' ),
				"param_name" => "noactive_color",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Pie Chart Line Width (px)", 'hudson' ),
				"param_name" => "line_width",
				"description" => ""
			),
			array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Margin below chart (px)", 'hudson' ),
                "param_name" => "margin_below_chart",
                "description" => ""
            ),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title", 'hudson' ),
				"param_name" => "title",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Color", 'hudson' ),
				"param_name" => "title_color",
				"dependency" => array('element' => "title", 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Title Tag", 'hudson' ),
				"param_name" => "title_tag",
				"value" => array(
					""   => "",
					"h2" => "h2",
					"h3" => "h3",
					"h4" => "h4",
					"h5" => "h5",
					"h6" => "h6",
				),
				"dependency" => array('element' => "title", 'not_empty' => true)
			),
		),
		$hudson_edge_icon_collections->getVCParamsArray(),
		array(
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Color", 'hudson' ),
				"param_name" => "icon_color",
				"dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Custom Icon Size (px)", 'hudson' ),
				"param_name" => "icon_custom_size",
				"dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Size", 'hudson' ),
				"param_name" => "icon_size",
				"value" => $hudson_edge_icon_collections->getIconSizesArray(),
				"save_always" => true,
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text", 'hudson' ),
				"param_name" => "text",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text Color", 'hudson' ),
				"param_name" => "text_color",
				"dependency" => array('element' => "text", 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Separator", 'hudson' ),
				"param_name" => "separator",
				"value" => array(
					esc_html__( "Yes", 'hudson' ) => "yes",
					esc_html__( "No", 'hudson' ) => "no"
				),
				"save_always" => true,
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Separator Color", 'hudson' ),
				"param_name" => "separator_color",
				"description" => "",
				"dependency" => array('element' => "separator", 'value' => array('yes'))
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Separator Border Style", 'hudson' ),
				"param_name" => "separator_border_style",
				"value" => array(
					"" => "",
					esc_html__( "Dashed", 'hudson' ) => "dashed",
					esc_html__( "Solid", 'hudson' ) => "solid"
				),
				"description" => "",
				"dependency" => array('element' => "separator", 'value' => array('yes'))
			)
		)
	)

) );


/** Horizontal progress bar shortcode ***/

vc_map( array(
		"name" => esc_html__( "Progress Bar - Horizontal", 'hudson' ),
		"base" => "no_progress_bar",
		"icon" => "icon-wpb-progress-bar extended-custom-icon",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"allowed_container_element" => 'vc_row',
		"params" => array(
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title", 'hudson' ),
				"param_name" => "title",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Color", 'hudson' ),
				"param_name" => "title_color",
				"description" => ""
			),
            array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Title Tag", 'hudson' ),
				"param_name" => "title_tag",
				"value" => array(
                    ""   => "",
					"h2" => "h2",
					"h3" => "h3",
					"h4" => "h4",	
					"h5" => "h5",	
					"h6" => "h6",	
				),
				"description" => ""
            ),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Custom Size (px)", 'hudson' ),
				"param_name" => "title_custom_size",
				"description" => ""
			),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title Padding Bottom(px)", 'hudson' ),
                "param_name" => "title_padding_bottom",
                "description" => ""
            ),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage", 'hudson' ),
				"param_name" => "percent",
				"description" => ""
			),			
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__( "Show Percentage Number", 'hudson' ),
                "param_name" => "show_percent_number",
                "value" => array(
                    esc_html__( "Yes", 'hudson' ) => "yes",
                    esc_html__( "No", 'hudson' ) => "no"
                ),
				"save_always" => true,
                "dependency" => Array('element' => "percent", 'not_empty' => true)
            ),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Show Percentage Mark", 'hudson' ),
				"param_name" => "show_percent_mark",
				"value" => array(
					esc_html__( "Yes", 'hudson' ) => "with_mark",
					esc_html__( "No", 'hudson' ) => "without_mark"
				),
				"save_always" => true,
				"dependency" => Array('element' => "percent", 'not_empty' => true)
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__( "Percentage Type", 'hudson' ),
                "param_name" => "percentage_type",
                "value" => array(
                    esc_html__( "Floating", 'hudson' ) => "floating",
                    esc_html__( "Static", 'hudson' ) => "static"
                ),
				"save_always" => true,
                "dependency" => Array('element' => "percent", 'not_empty' => true)
            ),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__( "Percentage Bar Margin Bottom (px)", 'hudson' ),
				"param_name" => "percentage_bar_margin_bottom",
				"dependency" => array('element' => "percent", 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__( "Percentage Bar Height (px)", 'hudson' ),
				"param_name" => "percentage_bar_height",
				"dependency" => array('element' => "percentage_type", 'value' => array('floating'))
			),			
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Floating Type", 'hudson' ),
				"param_name" => "floating_type",
				"value" => array(
					esc_html__( "Outside Floating", 'hudson' ) => "floating_outside",
					esc_html__( "Inside Floating", 'hudson' ) => "floating_inside"
				),
				"save_always" => true,
				"dependency" => array('element' => "percentage_type", 'value' => array('floating'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage Color", 'hudson' ),
				"param_name" => "percent_color",
				"dependency" => Array('element' => "percent", 'not_empty' => true)
			),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Percentage Background Color", 'hudson' ),
                "param_name" => "percent_background_color",
                "dependency" => Array('element' => "percent", 'not_empty' => true)
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Percentage Border Radius (px)", 'hudson' ),
                "param_name" => "percent_border_radius",
                "dependency" => Array('element' => "percent", 'not_empty' => true)
            ),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage Font Size", 'hudson' ),
				"param_name" => "percent_font_size",
				"dependency" => Array('element' => "percent", 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage Font weight", 'hudson' ),
				"param_name" => "percent_font_weight",
				"value" => array(
					esc_html__( "Default", 'hudson' ) => "",
					esc_html__( "Thin 100", 'hudson' ) => "100",
					esc_html__( "Extra-Light 200", 'hudson' ) => "200",
					esc_html__( "Light 300", 'hudson' ) => "300",
					esc_html__( "Regular 400", 'hudson' ) => "400",
					esc_html__( "Medium 500", 'hudson' ) => "500",
					esc_html__( "Semi-Bold 600", 'hudson' ) => "600",
					esc_html__( "Bold 700", 'hudson' ) => "700",
					esc_html__( "Extra-Bold 800", 'hudson' ) => "800",
					esc_html__( "Ultra-Bold 900", 'hudson' ) => "900"
				),
				"dependency" => Array('element' => "percent", 'not_empty' => true)
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Active Background Color", 'hudson' ),
				"param_name" => "active_background_color",
				"description" => ""
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Active Background Pattern", 'hudson' ),
				"param_name" => "active_background_pattern",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Active Border Color", 'hudson' ),
				"param_name" => "active_border_color",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Inactive Background Color", 'hudson' ),
				"param_name" => "noactive_background_color",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Progress Bar Height (px)", 'hudson' ),
				"param_name" => "height",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Progress Bar Border Radius)", 'hudson' ),
				"param_name" => "border_radius",
				"description" => ""
			)
		)
) );


/*** Vertical progress bar shortcode ***/

vc_map( array(
		"name" => esc_html__( "Progress Bar - Vertical", 'hudson' ),
		"base" => "no_progress_bar_vertical",
		"icon" => "icon-wpb-vertical-progress-bar extended-custom-icon",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"allowed_container_element" => 'vc_row',
		"params" => array(
            array (
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title", 'hudson' ),
				"param_name" => "title",
				"description" => ""
			),
            array (
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Color", 'hudson' ),
				"param_name" => "title_color",
				"description" => ""
			),
            array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Title Tag", 'hudson' ),
				"param_name" => "title_tag",
				"value" => array(
                    ""   => "",
					"h2" => "h2",
					"h3" => "h3",
					"h4" => "h4",	
					"h5" => "h5",	
					"h6" => "h6",	
				),
				"description" => ""
            ),
            array (
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Size", 'hudson' ),
				"param_name" => "title_size",
				"description" => ""
			),
			 array (
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Progress Bar Height(px)", 'hudson' ),
				"param_name" => "bar_content_height",
				"description" => esc_html__( "Default value is 190px", 'hudson' )
			),
            array (
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Bar Color", 'hudson' ),
                "param_name" => "bar_color",
                "description" => ""
            ),
            array (
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Bar Border Color", 'hudson' ),
                "param_name" => "bar_border_color",
                "description" => ""
            ),
			array (
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Background Color", 'hudson' ),
				"param_name" => "background_color",
				"description" => ""
			),
			array (
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Top Border Radius", 'hudson' ),
				"param_name" => "border_radius",
				"description" => ""
			),
            array (
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percent", 'hudson' ),
				"param_name" => "percent",
				"description" => ""
			),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__( "Show Percentage Number", 'hudson' ),
                "param_name" => "show_percent_number",
                "value" => array(
                    esc_html__( "Yes", 'hudson' ) => "yes",
                    esc_html__( "No", 'hudson' ) => "no"
                ),
				"save_always" => true,
                "dependency" => Array('element' => "percent", 'not_empty' => true)
            ),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Show Percentage Mark", 'hudson' ),
				"param_name" => "show_percent_mark",
				"value" => array(
					esc_html__( "Yes", 'hudson' ) => "with_mark",
					esc_html__( "No", 'hudson' ) => "without_mark"
				),
				"save_always" => true,
				"dependency" => Array('element' => "percent", 'not_empty' => true)
            ),
            array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage Text Size", 'hudson' ),
				"param_name" => "percentage_text_size",
				"dependency" => Array('element' => "percent", 'not_empty' => true)
			),
            array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Percentage Color", 'hudson' ),
				"param_name" => "percent_color",
				"dependency" => Array('element' => "percent", 'not_empty' => true)
			),
            array(
				"type" => "textarea",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Text", 'hudson' ),
				"param_name" => "text",
				"value" => "",
				"description" => ""
			),
            array (
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Text Color", 'hudson' ),
                "param_name" => "text_color",
                "description" => "",
                "dependency" => Array('element' => "text", 'not_empty' => true)
            )
		)
) );


/*** Progress Bar Icon ***/

vc_map( array(
	"name" => esc_html__( "Progress Bar - Icon", 'hudson' ),
	"base" => "no_progress_bar_icon",
	"icon" => "icon-wpb-progress-bar-icon extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
                array(
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Number of Icons", 'hudson' ),
                        "param_name" => "icons_number",
                        "description" => ""
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Number of Active Icons", 'hudson' ),
                        "param_name" => "active_number",
                        "description" => ""
                    )
                ),
                $hudson_edge_icon_collections->getVCParamsArray(),
                array(
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Size", 'hudson' ),
                        "param_name" => "size",
                        "value" => array(
                            esc_html__( "Tiny", 'hudson' ) => "tiny",
                            esc_html__( "Small", 'hudson' ) => "small",
                            esc_html__( "Medium", 'hudson' ) => "medium",
                            esc_html__( "Large", 'hudson' ) => "large",
                            esc_html__( "Very Large", 'hudson' ) => "very_large",
                            esc_html__( "Custom", 'hudson' ) => "custom"
                        ),
						"save_always" => true,
                        "description" => "",
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Custom Size (px)", 'hudson' ),
                        "param_name" => "custom_size",
                        "value" => "",
                        "description" => "",
                        "dependency" => array('element' => 'size', 'value' => array('custom'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Type", 'hudson' ),
                        "param_name" => "type",
                        "value" => array(
                            esc_html__( "Normal", 'hudson' ) => "normal",
                            esc_html__( "Circle", 'hudson' ) => "circle",
                            esc_html__( "Square", 'hudson' ) => "square"
                        ),
						"save_always" => true,
                        "description" => "",
                        "dependency" => array('element' => 'size', 'value' => array('tiny','small','medium','large','very_large'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Color", 'hudson' ),
                        "param_name" => "icon_color",
                        "description" => ""
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Active Color", 'hudson' ),
                        "param_name" => "icon_active_color",
                        "description" => ""
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Background Color", 'hudson' ),
                        "param_name" => "background_color",
                        "description" => "",
                        "dependency" => array('element' => "type", 'value' => array('square', 'circle')) 
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Background Active Color", 'hudson' ),
                        "param_name" => "background_active_color",
                        "description" => "",
                        "dependency" => array('element' => "type", 'value' => array('square', 'circle'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Border Color", 'hudson' ),
                        "param_name" => "border_color",
                        "description" => esc_html__( "Only for Square and Circle type", 'hudson' ),
                        "dependency" => array('element' => "type", 'value' => array('square', 'circle'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Border Active Color", 'hudson' ),
                        "param_name" => "border_active_color",
                        "description" => esc_html__( "Only for Square and Circle type", 'hudson' ),
                        "dependency" => array('element' => "type", 'value' => array('square', 'circle'))
                    )
                )
            )
) );


/*** Line Graph shortcode ***/

vc_map( array(
		"name" => esc_html__( "Line Graph", 'hudson' ),
		"base" => "no_line_graph",
		"icon" => "icon-wpb-line-graph extended-custom-icon",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"allowed_container_element" => 'vc_row',
		"params" => array(
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Type", 'hudson' ),
				"param_name" => "type",
				"value" => array(
					"" => "",
					esc_html__( "Rounded edges", 'hudson' ) => "rounded",
					esc_html__( "Sharp edges", 'hudson' ) => "sharp"
				),
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Width", 'hudson' ),
				"param_name" => "width",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Height", 'hudson' ),
				"param_name" => "height",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Custom Color", 'hudson' ),
				"param_name" => "custom_color",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Scale steps", 'hudson' ),
				"param_name" => "scale_steps",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Scale step width", 'hudson' ),
				"param_name" => "scale_step_width",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Labels", 'hudson' ),
				"param_name" => "labels",
				"value" => esc_html__("Label 1, Label 2, Label 3", "hudson")
			),
			array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Content", 'hudson' ),
				"param_name" => "content",
				"value" => "#B48360,Legend One,1,5,10;#C09678,Legend Two,3,7,20;#D2B5A0,Legend Three,10,2,34"
			)
		)
) );


/*** Ordered List ***/

vc_map( array(
		"name" => esc_html__( "List - Ordered", 'hudson' ),
		"base" => "no_ordered_list",
		"icon" => "icon-wpb-ordered-list extended-custom-icon",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"allowed_container_element" => 'vc_row',
		"params" => array(
			array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Content", 'hudson' ),
				"param_name" => "content",
				"value" => "<ol><li>" . esc_html__( 'Lorem Ipsum', 'hudson' ) . "</li><li>" . esc_html__( 'Lorem Ipsum', 'hudson' ) . "</li><li>" . esc_html__( 'Lorem Ipsum', 'hudson' ) . "</li></ol>",
				"description" => ""
			)

		)
) );


/*** Unordered List ***/

vc_map( array(
		"name" => esc_html__( "List - Unordered", 'hudson' ),
		"base" => "no_unordered_list",
		"icon" => "icon-wpb-unordered-list extended-custom-icon",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"allowed_container_element" => 'vc_row',
		"params" => array(
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Style", 'hudson' ),
				"param_name" => "style",
				"value" => array(
					esc_html__( "Circle", 'hudson' ) => "circle",
					esc_html__( "Number", 'hudson' ) => "number",
					esc_html__( "Line", 'hudson' ) => "line"
				),
				"save_always" => true,
				"description" => ""
			),
            array(
                "type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Number Type", 'hudson' ),
				"param_name" => "number_type",
				"value" => array(
					esc_html__( "Circle", 'hudson' ) => "circle_number",
					esc_html__( "Transparent", 'hudson' ) => "transparent_number"
				),
				"save_always" => true,
				"description" => "",
                "dependency" => array('element' => "style", 'value' => array('number'))
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Animate List", 'hudson' ),
				"param_name" => "animate",
				"value" => array(
					esc_html__( "No", 'hudson' ) => "no",
					esc_html__( "Yes", 'hudson' ) => "yes"
				),
				"save_always" => true,
				"description" => ""
			),
            array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Font Weight", 'hudson' ),
				"param_name" => "font_weight",
				"value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
					esc_html__( "Light", 'hudson' ) => "light",
					esc_html__( "Normal", 'hudson' ) => "normal",
                    esc_html__( "Bold", 'hudson' ) => "bold"
				),
				"description" => ""
			),
			array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Content", 'hudson' ),
				"param_name" => "content",
				"value" => "<ul><li>" . esc_html__( 'Lorem Ipsum', 'hudson' ) . "</li><li>" . esc_html__( 'Lorem Ipsum', 'hudson' ) . "</li><li>" . esc_html__( 'Lorem Ipsum', 'hudson' ) . "</li></ul>",
				"description" => ""
			)
		)
) );

/*** Bordered Content Box***/
class WPBakeryShortCode_No_Bordered_Content_Box extends WPBakeryShortCodesContainer {}
vc_map( array(
		"name" => esc_html__( "Bordered Content Box", 'hudson' ),
		"base" => "no_bordered_content_box",
		"icon" => "icon-wpb-bordered-content-box extended-custom-icon",
		"as_parent" => array('except' => 'vc_row'),
		"content_element" => true,
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"js_view" => 'VcColumnView',	
		"params" => array_merge(
			$hudson_edge_icon_collections->getVCParamsArray(),
				array(
					array(
						"type" => "dropdown",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Size", 'hudson' ),
						"param_name" => 'icon_fa_size',
						"value" => $hudson_edge_icon_collections->getIconSizesArray(),
						"save_always" => true,
						"description" => ""
					),
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Custom Size (px)", 'hudson' ),
						"param_name" => "icon_custom_size",
						"value" => ""
					),
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Shape Size (px)", 'hudson' ),
						"param_name" => 'icon_shape_size',
						"value" => "",
						"description" => ""
					),
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Shape Border radius(px)", 'hudson' ),
						"param_name" => "icon_border_radius",
						"description" => esc_html__("Please insert border radius(Rounded corners) in px. For example: 4 ", 'hudson'),
						"dependency" => Array('element' => "type", 'value' => array('circle','square'))
					),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Icon Color", 'hudson' ),
						"param_name" => "icon_color",
						"description" => ""
					),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Hover Icon Color", 'hudson' ),
						"param_name" => "hover_icon_color",
						"description" => ""
					),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Icon Background Color", 'hudson' ),
						"param_name" => "icon_background_color",
						"description" => ""
					),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Icon Background Hover Color", 'hudson' ),
						"param_name" => "icon_background_hover_color",
						"description" => ""
					),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Icon Shape Border Color", 'hudson' ),
						"param_name" => "icon_shape_border_color",
						"description" => ""
					),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Icon Shape Border Hover Color", 'hudson' ),
						"param_name" => "icon_shape_border_hover_color",
						"description" => ""
					),
					array(
						"type" => "colorpicker",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Box Background Color", 'hudson' ),
						"param_name" => "box_background_color",
						"description" => ""
					),
					array(
						"type" => "textfield",
						"holder" => "div",
						"class" => "",
						"heading" => esc_html__( "Box Padding", 'hudson' ),
						"param_name" => "box_padding",
						"description" => esc_html__( "Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson' )
					)
			)
		)
) );

/*** Icon List Item ***/

vc_map( array(
	"name" => esc_html__( "Icon List Item", 'hudson' ),
	"base" => "no_icon_list_item",
	"icon" => "icon-wpb-icon-list-item extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"params" => array_merge(
		$hudson_edge_icon_collections->getVCParamsArray(),
		array(
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Icon Type", 'hudson' ),
				"param_name" => "icon_type",
				"value" => array(
					esc_html__( "Normal", 'hudson' ) => "normal_icon_list",
					esc_html__( "Small", 'hudson' ) => "small_icon_list"
				),
				"save_always" => true,
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "With Background Color ?", 'hudson' ),
				"param_name" => "background_color_yesno",
				"value" => array(
					esc_html__( "No", 'hudson' ) => "no",
					esc_html__( "Yes", 'hudson' ) => "yes"
				),
				"save_always" => true,
				"description" => "",
			),
			array(
				"type" => "colorpicker",
				"class" => "",
				"heading" => esc_html__( "Background Color", 'hudson' ),
				"param_name" => "background_color",
				"description" => "",
				"dependency" => Array('element' => "background_color_yesno", 'value' => 'yes')
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__( "Background Border Radius (px)", 'hudson' ),
				"param_name" => "background_border_radius",
				"description" => "",
				"dependency" => Array('element' => "background_color_yesno", 'value' => 'yes')
			),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Icon Size (px)", 'hudson' ),
                "param_name" => "icon_size",
                "description" => ""
            ),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Color", 'hudson' ),
				"param_name" => "icon_color",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Margin Right (px)", 'hudson' ),
				"param_name" => "icon_margin_right",
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__( "Border Type", 'hudson' ),
				"param_name" => "border_type",
				"value" => array(
					"" => "",
					esc_html__( "Circle", 'hudson' ) => "circle",
					esc_html__( "Square", 'hudson' ) => "square"
				),
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Color", 'hudson' ),
				"param_name" => "border_color",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title", 'hudson' ),
				"param_name" => "title",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Color", 'hudson' ),
				"param_name" => "title_color",
				"description" => "",
                "dependency" => Array('element' => "title", 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title size (px)", 'hudson' ),
				"param_name" => "title_size",
				"description" => "",
                "dependency" => Array('element' => "title", 'not_empty' => true)
			),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title Font Family", 'hudson' ),
                "param_name" => "title_font_family",
                "description" => "",
                "dependency" => Array('element' => "title", 'not_empty' => true)
            ),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Title Font Weight (px)", 'hudson' ),
				"param_name" => "title_font_weight",
				"value" => $font_weight_array,
				"description" => "",
                "dependency" => Array('element' => "title", 'not_empty' => true)
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Bottom Margin (px)", 'hudson' ),
				"param_name" => "bottom_margin",
				"description" => ""
			)
		)
	)
) );


/*** Icon Shortcode ***/

vc_map( array(
	"name" => esc_html__( "Icon", 'hudson' ),
	"base" => "no_icons",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-icons extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
		$hudson_edge_icon_collections->getVCParamsArray(),
		array(
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Size", 'hudson' ),
				"param_name" => 'fa_size',
				"value" => $hudson_edge_icon_collections->getIconSizesArray(),
				"save_always" => true,
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Custom Size (px)", 'hudson' ),
				"param_name" => "custom_size",
				"value" => ""
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Type", 'hudson' ),
				"param_name" => "type",
				"value" => array(
					esc_html__( "Normal", 'hudson' ) => "normal",
					esc_html__( "Circle", 'hudson' ) => "circle",
					esc_html__( "Square", 'hudson' ) => "square"
				),
				"save_always" => true,
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Rotated Shape", 'hudson' ),
				"param_name" => "rotated_shape",
				"value" => array(
					esc_html__( "No", 'hudson' ) => "no",
					esc_html__( "Yes", 'hudson' ) => "yes"
				),
				"save_always" => true,
				"description" => "",
				"dependency" => Array('element' => "type", 'value' => "square")
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border radius", 'hudson' ),
				"param_name" => "border_radius",
				"description" => esc_html__("Please insert border radius(Rounded corners) in px. For example: 4 ", 'hudson'),
				"dependency" => Array('element' => "type", 'value' => array('circle','square'))
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Shape Size (px)", 'hudson' ),
				"param_name" => 'shape_size',
				"value" => "",
				"description" => "",
				"dependency" => Array('element' => "type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Color", 'hudson' ),
				"param_name" => "icon_color",
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Position", 'hudson' ),
				"param_name" => "position",
				"value" => array(
					esc_html__( "Normal", 'hudson' ) => "",
					esc_html__( "Left", 'hudson' ) => "left",
					esc_html__( "Center", 'hudson' ) => "center",
					esc_html__( "Right", 'hudson' ) => "right"
				),
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Color", 'hudson' ),
				"param_name" => "border_color",
				"dependency" => Array('element' => "type", 'value' => array('circle','square')),
				"description" => esc_html__( "Same color for Inner Border if enabled", 'hudson' )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Width", 'hudson' ),
				"param_name" => "border_width",
				"description" => esc_html__( "Default value is 1. Enter just number. Omit pixels", 'hudson' ),
				"dependency" => Array('element' => "type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Background Color", 'hudson' ),
				"param_name" => "background_color",
				"description" => "",
				"dependency" => Array('element' => "type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Hover Icon Color", 'hudson' ),
				"param_name" => "hover_icon_color",
				"description" => ""
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Hover Border Color", 'hudson' ),
				"param_name" => "hover_border_color",
				"dependency" => Array('element' => "type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Hover Background Color", 'hudson' ),
				"param_name" => "hover_background_color",
				"description" => "",
				"dependency" => Array('element' => "type", 'value' => array('circle','square'))
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Shadow", 'hudson' ),
				"param_name" => "icon_shadow",
				"value" => array(
					esc_html__( "No", 'hudson' ) => "no",
					esc_html__( "Yes", 'hudson' ) => "yes"
				),
				"save_always" => true,
				"description" => "",
				"dependency" => Array('element' => "type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Shadow Color", 'hudson' ),
				"param_name" => "shadow_color",
				"description" => "",
				"dependency" => Array('element' => "icon_shadow", 'value' => 'yes')
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Hover Shadow Color", 'hudson' ),
				"param_name" => "hover_shadow_color",
				"description" => "",
				"dependency" => Array('element' => "icon_shadow", 'value' => 'yes')
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Inner Border", 'hudson' ),
				"param_name" => "inner_border",
				"value" => array(
					esc_html__( "No", 'hudson' ) => "no",
					esc_html__( "Yes", 'hudson' ) => "yes"
				),
				"save_always" => true,
				"description" => "",
				"dependency" => Array('element' => "type", 'value' => array('circle','square'))
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Margin", 'hudson' ),
				"param_name" => "margin",
				"description" => esc_html__( "Margin (top right bottom left)", 'hudson' )
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Animation", 'hudson' ),
				"param_name" => "icon_animation",
				"value" => array(
					esc_html__( "No", 'hudson' ) => "",
					esc_html__( "Yes", 'hudson' ) => "edgt_icon_animation"
				),
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Animation Delay (ms)", 'hudson' ),
				"param_name" => "icon_animation_delay",
				"value" => "",
				"description" => "",
				"dependency" => Array('element' => "icon_animation", 'value' => 'edgt_icon_animation')
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Hover Animation", 'hudson' ),
				"param_name" => "icon_hover_animation",
				"value" => array(
					esc_html__( "No Animation", 'hudson' ) => "",
					esc_html__( "Outline Scale Out", 'hudson' ) => "animation_border_out"
				),
				"description" => "",
				"dependency" => array('element' => "type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Outline Color", 'hudson' ),
				"param_name" => "outline_color",
				"value" => "",
				"description" => "",
				"dependency" => array('element' => "icon_hover_animation", 'value' => array('animation_border_out'))
			),
			array(
				"type" => "checkbox",
				"class" => "",
				"heading" => esc_html__( "Use For Back To Top", 'hudson' ),
				"value" => array("Use this icon as Back to Top button?" => "yes"),
				"param_name" => "back_to_top_icon",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Link", 'hudson' ),
				"param_name" => "link",
				"value" => ""
			),
			array(
				"type" => "checkbox",
				"class" => "",
				"heading" => esc_html__( "Use Link as Anchor", 'hudson' ),
				"value" => array("Use this icon as Anchor?" => "yes"),
				"param_name" => "anchor_icon",
				"description" => esc_html__( "Check this box to use icon as anchor link (eg. #contact)", 'hudson' ),
				"dependency" => Array('element' => "link", 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Target", 'hudson' ),
				"param_name" => "target",
				"value" => array(
					esc_html__( "Self", 'hudson' ) => "_self",
					esc_html__( "Blank", 'hudson' ) => "_blank"
				),
				"save_always" => true,
				"description" => "",
				"dependency" => Array('element' => "link", 'not_empty' => true)
		))
	)
) );


/*** Social icon ***/

vc_map( array(
	"name" => esc_html__( "Social Icons", 'hudson' ),
	"base" => "no_social_icons",
	"icon" => "icon-wpb-social-icons extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
		array(
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Type", 'hudson' ),
				"param_name" => "type",
				"value" => array(
					esc_html__( "Normal", 'hudson' ) => "normal_social",
					esc_html__( "Circle", 'hudson' ) => "circle_social",
					esc_html__( "Square", 'hudson' ) => "square_social"
				),
				"save_always" => true,
				"description" => ""
			)
		),
		$hudson_edge_icon_collections->getSocialVCParamsArray(array(), '', false, array('linea_icons', 'simple_line_icons', 'dripicons')),
		array(
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Size", 'hudson' ),
				"param_name" => "size",
				"value" => array(
					esc_html__( "Tiny", 'hudson' ) => "tiny",
					esc_html__( "Small", 'hudson' ) => "small",
					esc_html__( "Medium", 'hudson' ) => "medium",
					esc_html__( "Large", 'hudson' ) => "large",
					esc_html__( "Huge", 'hudson' ) => "huge"
				),
				"save_always" => true,
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Link", 'hudson' ),
				"param_name" => "link",
				"value" => ""
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Target", 'hudson' ),
				"param_name" => "target",
				"value" => array(
					esc_html__( "Self", 'hudson' ) => "_self",
					esc_html__( "Blank", 'hudson' ) => "_blank"
				),
				"save_always" => true,
				"dependency" => Array('element' => "link", 'not_empty' => true)
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Color", 'hudson' ),
				"param_name" => "icon_color"
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Background Color", 'hudson' ),
				"param_name" => "background_color",
				"description" =>"",
				"dependency" => Array('element' => "type", 'value' => array('circle_social', 'square_social'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Color", 'hudson' ),
				"param_name" => "border_color",
				"description" =>"",
				"dependency" => Array('element' => "type", 'value' => array('circle_social', 'square_social'))
			),
			array(
				"type"              => "colorpicker",
				"holder"            => "div",
				"class"             => "",
				"heading" => esc_html__( "Icon Hover Color", 'hudson' ),
				"param_name"        => "icon_hover_color",
				"description"       => ""
			),
			array(
				"type"              => "colorpicker",
				"holder"            => "div",
				"class"             => "",
				"heading" => esc_html__( "Background Hover Color", 'hudson' ),
				"param_name"        => "background_hover_color",
				"dependency" => Array('element' => "type", 'value' => array('circle_social', 'square_social'))
			),
			array(
				"type"              => "colorpicker",
				"holder"            => "div",
				"class"             => "",
				"heading" => esc_html__( "Border Hover Color", 'hudson' ),
				"param_name"        => "border_hover_color",
				"dependency" => Array('element' => "type", 'value' => array('circle_social', 'square_social'))
			)
		)
	)
) );


/*** Icon with Text ***/

vc_map( array(
	"name" => esc_html__( "Icon With Text", 'hudson' ),
	"base" => "no_icon_text",
	"icon" => "icon-wpb-icon-with-text extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
                array(
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Box type", 'hudson' ),
                        "param_name" => "box_type",
                        "value" => array(
                            esc_html__( "Normal", 'hudson' ) => "normal",
                            esc_html__( "Icon in a box", 'hudson' ) => "icon_in_a_box"
                        ),
						"save_always" => true,
                        "description" => ""
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Box Border Color", 'hudson' ),
                        "param_name" => "box_border_color",
                        "description" => "",
                        "dependency" => Array('element' => "box_type", 'value' => array('icon_in_a_box'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Box Background Color", 'hudson' ),
                        "param_name" => "box_background_color",
                        "description" => "",
                        "dependency" => Array('element' => "box_type", 'value' => array('icon_in_a_box'))
                    )
                ),
                $hudson_edge_icon_collections->getVCParamsArray(),
                array(
                    array(
                        "type" => "attach_image",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Custom Icon", 'hudson' ),
                        "param_name" => "custom_icon"
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Type", 'hudson' ),
                        "param_name" => "icon_type",
                        "value" => array(
                            esc_html__( "Normal", 'hudson' ) => "normal",
                            esc_html__( "Circle", 'hudson' ) => "circle",
                            esc_html__( "Square", 'hudson' ) => "square"
                        ),
						"save_always" => true,
                        "description" => esc_html__( "This attribute does not work when Icon Position is Top. In This case Icon Type is Normal", 'hudson' ),
                    ),
                    array(
                        "type" => "textfield",
                        "class" => "",
                        "heading" => esc_html__( "Icon border width (px)", 'hudson' ),
                        "param_name" => "icon_border_width",
                        "description" => esc_html__( "Enter just number, omit pixels", 'hudson' ),
                        "dependency" => array('element' => 'icon_type' , 'value' => array('circle', 'square'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Size / Icon Space From Text", 'hudson' ),
                        "param_name" => "icon_size",
                        "value" => $hudson_edge_icon_collections->getIconSizesArray(),
						"save_always" => true,
                        "description" => esc_html__( "This attribute does not work when Icon Position is Top", 'hudson' )
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Custom Icon Size (px)", 'hudson' ),
                        "param_name" => "custom_icon_size",
                        "description" => esc_html__( "Default value is 30", 'hudson' ),
                        "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Animation", 'hudson' ),
                        "param_name" => "icon_animation",
                        "value" => array(
                            esc_html__( "No", 'hudson' ) => "",
                            esc_html__( "Yes", 'hudson' ) => "edgt_icon_animation"
                        ),
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Animation Delay (ms)", 'hudson' ),
                        "param_name" => "icon_animation_delay",
                        "value" => "",
                        "description" => "",
                        "dependency" => Array('element' => "icon_animation", 'value' => array('edgt_icon_animation'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Animation on Hover", 'hudson' ),
                        "param_name" => "icon_animation_hover",
                        "value" => array(
                            esc_html__( "No", 'hudson' ) => "no",
                            esc_html__( "Zoom Icon", 'hudson' ) => "zoom"
                        ),
						"save_always" => true
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Position", 'hudson' ),
                        "param_name" => "icon_position",
                        "value" => array(
                            esc_html__( "Top", 'hudson' ) => "top",
                            esc_html__( "Left", 'hudson' ) => "left",
                            esc_html__( "Left From Title", 'hudson' ) => "left_from_title",
                            esc_html__( "Right", 'hudson' ) => "right"
                        ),
						"save_always" => true,
                        "description" => esc_html__( "Icon Position (only for normal box type)", 'hudson' ),
                        "dependency" => Array('element' => "box_type", 'value' => array('normal'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Margin", 'hudson' ),
                        "param_name" => "icon_margin",
                        "value" => "",
                        "description" => esc_html__( "Margin should be set in a top right bottom left format", 'hudson' ),
                        "dependency" => array('element' => "box_type", 'value' => array('normal'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Text Left Padding (px)", 'hudson' ),
                        "param_name" => "text_left_padding",
                        "description" => esc_html__( "Default value is 86. Only when Icon Position is Left", 'hudson' ),
                        "dependency" => Array('element' => "icon_position", 'value' => array('left'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Text Right Padding (px)", 'hudson' ),
                        "param_name" => "text_right_padding",
                        "description" => esc_html__( "Default value is 86. Only when Icon Position is Right", 'hudson' ),
                        "dependency" => Array('element' => "icon_position", 'value' => array('right'))
                    ),
					array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Shape Size (px)", 'hudson' ),
                        "param_name" => "shape_size",
                        "description" => ""
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Border Color", 'hudson' ),
                        "param_name" => "icon_border_color",
                        "description" => esc_html__( "Only for Square and Circle type", 'hudson' ),
                        "dependency" => Array('element' => "icon_type", 'value' => array('square','circle'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Border Hover Color", 'hudson' ),
                        "param_name" => "icon_border_hover_color",
                        "description" => esc_html__( "Only for Square and Circle type", 'hudson' ),
                        "dependency" => Array('element' => "icon_type", 'value' => array('square','circle'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Color", 'hudson' ),
                        "param_name" => "icon_color",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Hover Color", 'hudson' ),
                        "param_name" => "icon_hover_color",
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Background Color", 'hudson' ),
                        "param_name" => "icon_background_color",
                        "description" => esc_html__( "Icon Background Color (only for square and circle icon type)", 'hudson' ),
                        "dependency" => Array('element' => "icon_type", 'value' => array('square','circle'))
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Hover Background Color", 'hudson' ),
                        "param_name" => "icon_hover_background_color",
                        "description" => esc_html__( "Icon Hover Background Color (only for square and circle icon type)", 'hudson' ),
                        "dependency" => Array('element' => "icon_type", 'value' => array('square','circle'))
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Separator", 'hudson' ),
                        "param_name" => "separator",
                        "value" => array(
                            esc_html__( "No", 'hudson' ) => "no",
                            esc_html__( "Yes", 'hudson' ) => "yes",
                        ),
						"save_always" => true,
                        "description" => ""
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Separator Color", 'hudson' ),
                        "param_name" => "separator_color",
                        "description" => "",
                        "dependency" => array('element' => "separator", 'value' => array("yes"))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Separator Thickness (px)", 'hudson' ),
                        "param_name" => "separator_thickness",
                        "description" => "",
                        "dependency" => array('element' => "separator", 'value' => array("yes"))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Separator Size (px)", 'hudson' ),
                        "param_name" => "separator_width",
                        "description" => "",
                        "dependency" => array('element' => "separator", 'value' => array("yes"))
                    ),
                    array(
                        "type" => "dropdown",
                        "class" => "",
                        "heading" => esc_html__( "Separator Alignment", 'hudson' ),
                        "param_name" => "separator_alignment",
                        "value" => array(
                            esc_html__( "Center", 'hudson' ) => "none",
                            esc_html__( "Left", 'hudson' ) => "left",
                            esc_html__( "Right", 'hudson' ) => "right",
                        ),
						"save_always" => true,
                        "dependency" => array('element' => "separator", 'value' => array("yes"))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Title", 'hudson' ),
                        "param_name" => "title",
                        "value" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "class" => "",
                        "heading" => esc_html__( "Title Tag", 'hudson' ),
                        "param_name" => "title_tag",
                        "value" => array(
                            ""   => "",
                            "h2" => "h2",
                            "h3" => "h3",
                            "h4" => "h4",
                            "h5" => "h5",
                            "h6" => "h6",
                        ),
                        "dependency" => Array('element' => "title", 'not_empty' => true)
                    ),
					array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Title Font Size (px)", 'hudson' ),
                        "param_name" => "title_font_size",
                        "value" => "",
                        "description" => "",
                        "dependency" => Array('element' => "title", 'not_empty' => true)
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Title Color", 'hudson' ),
                        "param_name" => "title_color",
                        "dependency" => Array('element' => "title", 'not_empty' => true)
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Space Between title and text (px)", 'hudson' ),
                        "param_name" => "title_margin",
                        "value" => "",
                        "description" => "",
                        "dependency" => Array('element' => "title", 'not_empty' => true)
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Title Top Padding (px)", 'hudson' ),
                        "param_name" => "title_padding",
                        "value" => "",
                        "description" => esc_html__( "This attribute is used for boxed type", 'hudson' ),
                        "dependency" => Array('element' => "box_type", 'value' => array('icon_in_a_box'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Text", 'hudson' ),
                        "param_name" => "text",
                        "value" => ""
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Text Color", 'hudson' ),
                        "param_name" => "text_color",
                        "dependency" => Array('element' => "text", 'not_empty' => true)
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Link", 'hudson' ),
                        "param_name" => "link",
                        "value" => "",
                        "dependency" => Array('element' => "box_type", 'value' => array('normal'))
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Link Text", 'hudson' ),
                        "param_name" => "link_text",
                        "description" => esc_html__( "Default value is READ MORE", 'hudson' ),
                        "dependency" => Array('element' => "link", 'not_empty' => true)
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Button Link Text Color", 'hudson' ),
                        "param_name" => "link_color",
                        "description" => "",
                        "dependency" => Array('element' => "link_text", 'not_empty' => true)
                    ),
                    array(
                        "type" => "dropdown",
                        "class" => "",
                        "heading" => esc_html__( "Target", 'hudson' ),
                        "param_name" => "target",
                        "value" => array(
                            ""   => "",
                            esc_html__( "Self", 'hudson' ) => "_self",
                            esc_html__( "Blank", 'hudson' ) => "_blank"
                        ),
                        "dependency" => Array('element' => "link", 'not_empty' => true)
                    )
                )
            )
) );

/*** Separator with Icon ***/

vc_map( array(
	"name" => esc_html__( "Separator with Icon", 'hudson' ),
	"base" => "no_separator_with_icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-separator-with-icon extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
		array(
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Separator Line Style", 'hudson' ),
				"param_name" => "border_style",
				"value" => array(
					esc_html__( "Solid", 'hudson' ) => "solid",
					esc_html__( "Dashed", 'hudson' ) => "dashed",
					esc_html__( "Dotted", 'hudson' ) => "dotted",
					esc_html__( "Transparent", 'hudson' ) => "transparent"
				),
				"save_always" => true,
				"description" => esc_html__( "Choose a style for the separator line", 'hudson' )
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Line Color", 'hudson' ),
				"param_name" => "color",
				"value" => "",
				"description" => esc_html__( "Choose a color for the separator line", 'hudson' )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Line Width (px)", 'hudson' ),
				"param_name" => "width",
				"value" => "",
				"description" => esc_html__( "Insert width for the separator line", 'hudson' )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Line Thickness (px)", 'hudson' ),
				"param_name" => "thickness",
				"value" => "",
				"description" => esc_html__( "Insert thickness for the separator line", 'hudson' )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Top Margin (px)", 'hudson' ),
				"param_name" => "up",
				"value" => "",
				"description" => esc_html__( "Insert top margin for the separator", 'hudson' )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Bottom Margin (px)", 'hudson' ),
				"param_name" => "down",
				"value" => "",
				"description" => esc_html__( "Insert bottom margin for the separator", 'hudson' )
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Type", 'hudson' ),
				"param_name" => "type",
				"value" => array(
					esc_html__( "Default Icon", 'hudson' ) => "with_icon",
					esc_html__( "Custom Icon", 'hudson' ) => "with_custom_icon"
				),
				"save_always" => true,
				"description" => esc_html__( "Choose a style for the separator line", 'hudson' )
			),
		),
		$hudson_edge_icon_collections->getVCParamsArray(array('element' => "type", 'value' => array('with_icon'))),
		array(
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Custom Size (px)", 'hudson' ),
				"param_name" => "icon_custom_size",
				"value" => "",
				"description" => esc_html__( "Insert size for the icon (default value is 20)", 'hudson' ),
				"dependency" => Array('element' => "type", 'value' => array('with_icon'))
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Type", 'hudson' ),
				"param_name" => "icon_type",
				"value" => array(
					esc_html__( "Normal", 'hudson' ) => "normal",
					esc_html__( "Circle", 'hudson' ) => "circle",
					esc_html__( "Square", 'hudson' ) => "square"
				),
				"save_always" => true,
				"description" => esc_html__( "Choose icon type", 'hudson' ),
				"dependency" => Array('element' => "type", 'value' => array('with_icon'))
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Custom Icon", 'hudson' ),
				"param_name" => "custom_icon",
				"dependency" => Array('element' => "type", 'value' => array('with_custom_icon'))
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Position", 'hudson' ),
				"param_name" => "separator_icon_position",
				"value" => array(
					esc_html__( "Center", 'hudson' ) => "center",
					esc_html__( "Left", 'hudson' ) => "left",
					esc_html__( "Right", 'hudson' ) => "right"
				),
				"save_always" => true,
				"description" => esc_html__( "Choose position of the icon", 'hudson' )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Margins", 'hudson' ),
				"param_name" => "icon_margin",
				"description" => esc_html__( "Insert left and right icon margins", 'hudson' )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Border radius", 'hudson' ),
				"param_name" => "icon_border_radius",
				"description" => esc_html__("Insert border radius(Rounded corners) in px. For example: 4. Leave empty for default. ", 'hudson'),
				"dependency" => Array('element' => "icon_type", 'value' => array('circle','square'))
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Shape Size (px)", 'hudson' ),
				"param_name" => 'icon_shape_size',
				"value" => "",
				"description" => esc_html__( "Insert size for a shape around the icon", 'hudson' ),
				"dependency" => Array('element' => "icon_type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Color", 'hudson' ),
				"param_name" => "icon_color",
				"description" => esc_html__( "Choose a color for the icon", 'hudson' ),
				"dependency" => Array('element' => "type", 'value' => array('with_icon'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Border Color", 'hudson' ),
				"param_name" => "icon_border_color",
				"description" => esc_html__( "Choose a color for the border around the icon shape", 'hudson' ),
				"dependency" => Array('element' => "icon_type", 'value' => array('circle','square'))
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Border Width", 'hudson' ),
				"param_name" => "icon_border_width",
				"description" => esc_html__( "Insert border width (just number, omit pixels)", 'hudson' ),
				"dependency" => Array('element' => "icon_type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Background Color", 'hudson' ),
				"param_name" => "icon_background_color",
				"description" => esc_html__( "Choose a background color for the icon shape", 'hudson' ),
				"dependency" => Array('element' => "icon_type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Hover Icon Color", 'hudson' ),
				"param_name" => "hover_icon_color",
				"description" => esc_html__( "Choose a hover color for the icon", 'hudson' ),
				"dependency" => Array('element' => "type", 'value' => array('with_icon'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Hover Border Color", 'hudson' ),
				"param_name" => "hover_icon_border_color",
				"description" => esc_html__( "Choose a hover color for the border around the icon shape", 'hudson' ),
				"dependency" => Array('element' => "icon_type", 'value' => array('circle','square'))
			),
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Icon Hover Background Color", 'hudson' ),
				"param_name" => "hover_icon_background_color",
				"description" => esc_html__( "Choose a background hover color for the icon shape", 'hudson' ),
				"dependency" => Array('element' => "icon_type", 'value' => array('circle','square'))
			),array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Link", 'hudson' ),
			"param_name" => "link",
			"description" => ""
		),
			array(
				"type" => "checkbox",
				"class" => "",
				"heading" => esc_html__( "Use Link as Anchor", 'hudson' ),
				"value" => array("Use this icon as Anchor?" => "yes"),
				"param_name" => "icon_anchor",
				"description" => esc_html__( "Check this box to use icon as anchor link (eg. #contact)", 'hudson' ),
				"dependency" => Array('element' => "link", 'not_empty' => true)
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Target", 'hudson' ),
				"param_name" => "target",
				"value" => array(
					esc_html__( "Self", 'hudson' ) => "_self",
					esc_html__( "Blank", 'hudson' ) => "_blank"
				),
				"save_always" => true,
				"description" => "",
				"dependency" => Array('element' => "link", 'not_empty' => true)
			)
		)
	)

) );



/*** Social Share ***/

vc_map( array(
	"name" => esc_html__( "Social Share", 'hudson' ),
	"base" => "no_social_share",
	"icon" => "icon-wpb-social-share extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"show_settings_on_create" => false
) );


/*** Cover Boxes ***/

$cover_boxes_icons_array = array(array());
for ($x = 1; $x<4; $x++) {
    $coverBoxesCollections = $hudson_edge_icon_collections->iconCollections;
    foreach($coverBoxesCollections as $collection_key => $collection) {

        $cover_boxes_icons_array[$x][] = array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__( "Button Icon ", 'hudson' ).$x,
            "param_name" => "cover_social_".$collection->param."_".$x,
            "value" => $collection->getIconsArray(),
            "dependency" => Array('element' => "cover_boxes_icon_pack", 'value' => array($collection_key))
        );

    }
}

vc_map( array(
	"name" => esc_html__( "Cover Boxes", 'hudson' ),
	"base" => "no_cover_boxes",
	"icon" => "icon-wpb-cover-boxes extended-custom-icon",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"allowed_container_element" => 'vc_row',
	"params" => array_merge(
        array(
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Active element", 'hudson' ),
                "param_name" => "active_element",
                "value" => ""
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title tag", 'hudson' ),
                "param_name" => "title_tag",
                "value" => array(
                    ""   => "",
                    "h2" => "h2",
                    "h3" => "h3",
                    "h4" => "h4",
                    "h5" => "h5",
                    "h6" => "h6",
                ),
                "description" => esc_html__( "Choose with heading tag to display for titles", 'hudson' )
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Number of items", 'hudson' ),
                "param_name" => "number_of_items",
                "value" => array(
                    "" => "",
                    "2"   => "2",
                    "3" => "3"
                ),
                "description" => esc_html__( "Choose the number of items shown", 'hudson' )
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Icon Pack", 'hudson' ),
                "param_name" => "cover_boxes_icon_pack",
                "value" => array_merge(array("No Icon" => ""),$hudson_edge_icon_collections->getIconCollectionsVC())
            ),
            array(
                "type" => "attach_image",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Image 1", 'hudson' ),
                "param_name" => "image1"
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title 1", 'hudson' ),
                "param_name" => "title1",
                "value" => ""
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title Color 1", 'hudson' ),
                "param_name" => "title_color1",
                "description" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Text 1", 'hudson' ),
                "param_name" => "text1",
                "value" => ""
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Text Color 1", 'hudson' ),
                "param_name" => "text_color1",
                "description" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Link 1", 'hudson' ),
                "param_name" => "link1",
                "value" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Link label 1", 'hudson' ),
                "param_name" => "link_label1",
                "value" => ""
            )
        ),
        $cover_boxes_icons_array['1'],
        array(
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Target 1", 'hudson' ),
                "param_name" => "target1",
                "value" => array(
                    esc_html__( "Self", 'hudson' ) => "_self",
                    esc_html__( "Blank", 'hudson' ) => "_blank"
                ),
				"save_always" => true,
                "description" => ""
            ),
            array(
                "type" => "attach_image",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Image 2", 'hudson' ),
                "param_name" => "image2"
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title 2", 'hudson' ),
                "param_name" => "title2",
                "value" => ""
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title Color 2", 'hudson' ),
                "param_name" => "title_color2",
                "description" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Text 2", 'hudson' ),
                "param_name" => "text2",
                "value" => ""
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Text Color 2", 'hudson' ),
                "param_name" => "text_color2",
                "description" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Link 2", 'hudson' ),
                "param_name" => "link2",
                "value" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Link label 2", 'hudson' ),
                "param_name" => "link_label2",
                "value" => ""
            )
        ),
        $cover_boxes_icons_array['2'],
        array(
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Target 2", 'hudson' ),
                "param_name" => "target2",
                "value" => array(
                    esc_html__( "Self", 'hudson' ) => "_self",
                    esc_html__( "Blank", 'hudson' ) => "_blank"
                ),
				"save_always" => true,
                "description" => ""
            ),
            array(
                "type" => "attach_image",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Image 3", 'hudson' ),
                "param_name" => "image3",
                "dependency" => array('element' => 'number_of_items', 'value' => array('','3'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title 3", 'hudson' ),
                "param_name" => "title3",
                "value" => "",
                "dependency" => array('element' => 'number_of_items', 'value' => array('','3'))
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Title Color 3", 'hudson' ),
                "param_name" => "title_color3",
                "description" => "",
                "dependency" => array('element' => 'number_of_items', 'value' => array('','3'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Text 3", 'hudson' ),
                "param_name" => "text3",
                "value" => "",
                "dependency" => array('element' => 'number_of_items', 'value' => array('','3'))
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Text Color 3", 'hudson' ),
                "param_name" => "text_color3",
                "description" => "",
                "dependency" => array('element' => 'number_of_items', 'value' => array('','3'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Link 3", 'hudson' ),
                "param_name" => "link3",
                "value" => "",
                "dependency" => array('element' => 'number_of_items', 'value' => array('','3'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Link label 3", 'hudson' ),
                "param_name" => "link_label3",
                "value" => "",
                "dependency" => array('element' => 'number_of_items', 'value' => array('','3'))
            )
        ),
        $cover_boxes_icons_array['3'],
        array(
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Target 3", 'hudson' ),
                "param_name" => "target3",
                "value" => array(
                    esc_html__( "Self", 'hudson' ) => "_self",
                    esc_html__( "Blank", 'hudson' ) => "_blank"
                ),
				"save_always" => true,
                "description" => "",
                "dependency" => array('element' => 'number_of_items', 'value' => array('','3'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Show Link as Default Button", 'hudson' ),
                "param_name" => "read_more_button_style",
                "value" => array(
                    esc_html__( "Default", 'hudson' ) => "",
                    esc_html__( "No", 'hudson' ) => "no",
                    esc_html__( "Yes", 'hudson' ) => "yes"
                ),
                "description" => ""
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Separator", 'hudson' ),
                "param_name" => "separator",
                "value" => array(
                    esc_html__( "Yes", 'hudson' ) => "yes",
                    esc_html__( "No", 'hudson' ) => "no"
                ),
				"save_always" => true,
                "description" => ""
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Separator Thicknes (px)", 'hudson' ),
                "param_name" => "separator_thickness",
                "description" => "",
                "dependency" => array('element' => "separator", 'value' => array('yes'))
            ),
            array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Separator Color", 'hudson' ),
                "param_name" => "separator_color",
                "description" => "",
                "dependency" => array('element' => "separator", 'value' => array('yes'))
            ),
            array(
                "type" => "dropdown",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Separator Border Style", 'hudson' ),
                "param_name" => "separator_border_style",
                "value" => array(
                    "" => "",
                    esc_html__( "Dashed", 'hudson' ) => "dashed",
                    esc_html__( "Solid", 'hudson' ) => "solid"
                ),
                "description" => "",
                "dependency" => array('element' => "separator", 'value' => array('yes'))
            ),
            array(
                "type" => "textfield",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Button Icon Size (px)", 'hudson' ),
                "param_name" => "button_icon_size",
                "description" => "",
                "dependency" => Array('element' => "cover_boxes_icon_pack", 'not_empty' => true)
            ),
            array(
                "type" => "colorpicker",
                "class" => "",
                "heading" => esc_html__( "Button Icon Color", 'hudson' ),
                "param_name" => "button_icon_color",
                "description" => "",
                "dependency" => Array('element' => "cover_boxes_icon_pack", 'not_empty' => true)
            ),
        )
    )
) );


/*** Interactive Banners ***/

vc_map( array(
		"name" => esc_html__( "Interactive Banners", 'hudson' ),
		"base" => "no_interactive_banners",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"icon" => "icon-wpb-interactive-banners extended-custom-icon",
		"allowed_container_element" => 'vc_row',
		"params" => array_merge(
                    array(
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Width", 'hudson' ),
                            "param_name" => "layout_width",
                            "value" => array(
                                ""   => "",
                                "1/2" => "one_half",
                                "1/3" => "one_third",
                                "1/4" => "one_fourth",
                            ),
                            "description" => ""
                        ),
                        array(
                            "type" => "attach_image",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Image", 'hudson' ),
                            "param_name" => "image"
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Image Color Overlay", 'hudson' ),
                            "param_name" => "overlay_color",
                            "value" => "",
                            "description" => "",
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Image Hover Color Overlay", 'hudson' ),
                            "param_name" => "overlay_color_hover",
                            "value" => "",
                            "description" => "",
                        ),
						array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__( "Image Zoom on Hover", 'hudson' ),
							"param_name" => "image_animate",
							"value" => array(
								esc_html__( "No", 'hudson' ) => "no",
								esc_html__( "Yes", 'hudson' ) => "yes"
							),
							"save_always" => true,
							"description" => "",
							"dependency" => Array('element' => "image", 'not_empty' => true)
						),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Show Image Inner Border", 'hudson' ),
                            "param_name" => "show_border",
                            "value" => array(
                                esc_html__( "Always", 'hudson' ) => "always",
								esc_html__( "Only On Hover", 'hudson' ) => "on_hover",
								esc_html__( "Never", 'hudson' ) => "never"
                            ),
							"save_always" => true,
                            "description" => ""
                        ),
                        array(
                            "type" => "colorpicker",
                            "class" => "",
                            "heading" => esc_html__( "Image Inner Border Color", 'hudson' ),
                            "param_name" => "border_color",
                            "description" => "",
                            "dependency" => Array('element' => "show_border", 'value' => array('always','on_hover'))
                        ),                                               
                        array(
						    "type" => "dropdown",
						    "class" => "",
						    "heading" => esc_html__( "Border Animation", 'hudson' ),
						    "admin_label" => true,
						    "param_name" => "border_hover_animation",
						    "value" => array(
						    	esc_html__( "No Animation", 'hudson' ) => "",
						    	esc_html__( "Scale Line", 'hudson' ) => "edgt_box_scale_line",
						        esc_html__( "Simultaneous Line", 'hudson' ) => "edgt_box_simultaneous_line",
						        esc_html__( "Continue Line", 'hudson' ) => "edgt_box_continue_line",
						        esc_html__( "Corner Line", 'hudson' ) => "edgt_box_corner_line",
						    ),
						    "description" => esc_html__( 'Choose Animation for Border Hover', 'hudson' ),
						    "dependency" => array('element' => "show_border", 'value' => 'on_hover')
						    ),
                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__( "Image Inner Border Offset (%)", 'hudson' ),
                            "param_name" => "border_offset",
                            "description" => "",
                            "dependency" => Array('element' => "show_border", 'value' =>'on_hover')
                        ),
                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__( "Image Inner Border Offset (px)", 'hudson' ),
                            "param_name" => "inner_border_offset_px",
                            "description" => "",
                            "dependency" => Array('element' => "show_border", 'value' =>'always')
                        ),	
						array(
							"type" => "dropdown",
							"class" => "",
							"heading" => esc_html__( "Show Icon", 'hudson' ),
							"param_name" => "show_icon",
							"value" => array(
								esc_html__( "Always", 'hudson' ) => "always",
								esc_html__( "Only On Hover", 'hudson' ) => "on_hover",
								esc_html__( "Never", 'hudson' ) => "never"
							),
							"save_always" => true,
							"description" => "",
						),
                    ),
                    $hudson_edge_icon_collections->getVCParamsArray((array('element' => "show_icon", 'value' => array('always', 'on_hover'))), '', true),
                    array(
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Type", 'hudson' ),
                            "param_name" => "icon_type",
                            "value" => array(
                                esc_html__( "Normal", 'hudson' ) => "normal",
                                esc_html__( "Circle", 'hudson' ) => "circle",
                                esc_html__( "Square", 'hudson' ) => "square"
                            ),
							"save_always" => true,
                            "description" => "",
                            "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Size (px)", 'hudson' ),
                            "param_name" => "icon_custom_size",
                            "value" => "",
                            "description" => esc_html__( "Default value is 20", 'hudson' ),
                            "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Color", 'hudson' ),
                            "param_name" => "icon_color",
                            "description" => "",
                            "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                        ),
                        array(
                            "type" => "dropdown",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Icon Zoom on Hover", 'hudson' ),
                            "param_name" => "icon_zoom",
                            "value" => array(
                                esc_html__( "No", 'hudson' ) => "no",
                                esc_html__( "Yes", 'hudson' ) => "yes"
                            ),
							"save_always" => true,
                            "description" => "",
                            "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Show Title", 'hudson' ),
                            "param_name" => "show_title",
                            "value" => array(
                                esc_html__( "Always", 'hudson' ) => "always",
                                esc_html__( "Only On Hover", 'hudson' ) => "on_hover",
                                esc_html__( "Only Before Hover", 'hudson' ) => "before_hover",
                                esc_html__( "Never", 'hudson' ) => "never"
                            ),
							"save_always" => true,
                            "description" => "",
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Title Text", 'hudson' ),
                            "param_name" => "title",
                            "description" => "",
                            "dependency" => Array('element' => "show_title", 'value' => array('always','on_hover','before_hover'))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Title Color", 'hudson' ),
                            "param_name" => "title_color",
                            "dependency" => Array('element' => "title", 'not_empty' => true),
                            "dependency" => Array('element' => "show_title", 'value' => array('always','on_hover','before_hover'))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Title Size (px)", 'hudson' ),
                            "param_name" => "title_size",
                            "description" => esc_html__( "Default value is 17", 'hudson' ),
                            "dependency" => Array('element' => "title", 'not_empty' => true),
                            "dependency" => Array('element' => "show_title", 'value' => array('always','on_hover','before_hover'))
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Title Tag", 'hudson' ),
                            "param_name" => "title_tag",
                            "value" => array(
                                ""   => "",
                                "h2" => "h2",
                                "h3" => "h3",
                                "h4" => "h4",	
                                "h5" => "h5",	
                                "h6" => "h6",	
                            ),
                            "dependency" => Array('element' => "title", 'not_empty' => true)
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Show Button", 'hudson' ),
                            "param_name" => "show_button",
                            "value" => array(
                                esc_html__( "Always", 'hudson' ) => "always",
                                esc_html__( "Only On Hover", 'hudson' ) => "on_hover",
                                esc_html__( "Never", 'hudson' ) => "never"
                            ),
							"save_always" => true,
                            "description" => "",
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Button Height", 'hudson' ),
                            "param_name" => "button_size",
                            "description" => esc_html__( "It uses small button options (px)", 'hudson' ),
                            "dependency" => Array('element' => "show_button", 'value' => array("on_hover","always"))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Button Left and Right Padding", 'hudson' ),
                            "param_name" => "button_padding",
                            "description" => esc_html__( "It uses small button options (px)", 'hudson' ),
                            "dependency" => Array('element' => "show_button", 'value' => array("on_hover","always"))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Button Text", 'hudson' ),
                            "param_name" => "link_text",
                            "description" => "",
                            "dependency" => Array('element' => "show_button", 'value' => array("on_hover","always"))
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Link Button to following URL", 'hudson' ),
                            "param_name" => "button_link",
                            "description" => "",
                            "dependency" => Array('element' => "show_button", 'value' => array("on_hover","always"))
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Link Target", 'hudson' ),
                            "param_name" => "target",
                            "value" => array(
                                esc_html__( "Self", 'hudson' ) => "_self",
                                esc_html__( "Blank", 'hudson' ) => "_blank"
                            ),
							"save_always" => true,
                            "description" => "",
                            "dependency" => Array('element' => "show_button", 'value' => array("on_hover","always"))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Button Text Color", 'hudson' ),
                            "param_name" => "link_color",
                            "description" => "",
                            "dependency" => Array('element' => "show_button", 'value' => array("on_hover","always"))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Button Border Color", 'hudson' ),
                            "param_name" => "link_border_color",
                            "description" => "",
                            "dependency" => Array('element' => "show_button", 'value' => array("on_hover","always"))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Button Background Color", 'hudson' ),
                            "param_name" => "link_background_color",
                            "description" => "",
                            "dependency" => Array('element' => "show_button", 'value' => array("on_hover","always"))
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Add Link Over Banner Content", 'hudson' ),
                            "param_name" => "link_over_content",
                            "value" => array(
                                esc_html__( "No", 'hudson' ) => "no",
                                esc_html__( "Yes", 'hudson' ) => "yes"
                            ),
							"save_always" => true,
                            "description" => "",
                            "dependency" => Array('element' => "show_button", 'value' => "never")
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Link Banner Content to following URL", 'hudson' ),
                            "param_name" => "content_link",
                            "description" => "",
                            "dependency" => Array('element' => "link_over_content", 'value' => 'yes')
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Show Separator under Title", 'hudson' ),
                            "param_name" => "separator",
                            "value" => array(
                                esc_html__( "Never", 'hudson' ) => "no",
                                esc_html__( "Always", 'hudson' ) => "yes",
                                esc_html__( "Only On Hover", 'hudson' ) => "on_hover"
                            ),
							"save_always" => true,
                            "description" => ""
                        ),
                        array(
                            "type" => "textfield",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Separator Thickness (px)", 'hudson' ),
                            "param_name" => "separator_thickness",
                            "description" => "",
                            "dependency" => Array('element' => "separator", 'value' => array("yes","on_hover"))
                        ),
                        array(
                            "type" => "colorpicker",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Separator Color", 'hudson' ),
                            "param_name" => "separator_color",
                            "description" => "",
                            "dependency" => Array('element' => "separator", 'value' => array("yes","on_hover"))
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Separator Animation", 'hudson' ),
                            "param_name" => "separator_animate",
                            "value" => array(
                                esc_html__( "Yes", 'hudson' ) => "yes",
                                esc_html__( "No", 'hudson' ) => "no",
                            ),
							"save_always" => true,
                            "description" => "",
                            "dependency" => Array('element' => "separator", 'value' => array("yes","on_hover"))
                        ),
                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__( "Show Content", 'hudson' ),
                            "param_name" => "show_content",
                            "value" => array(
                                esc_html__( "Always", 'hudson' ) => "always",
                                esc_html__( "Only On Hover", 'hudson' ) => "on_hover",
                                esc_html__( "Never", 'hudson' ) => "never"
                            ),
							"save_always" => true,
                            "description" => "",
                        ),
                        array(
                            "type" => "textarea_html",
                            "holder" => "div",
                            "class" => "",
                            "heading" => esc_html__( "Content", 'hudson' ),
                            "param_name" => "content",
                            "value" => "<p>".esc_html__("I am test text for 'Interactive Banner' shortcode.", "hudson")."</p>",
                            "description" => ""
                        )
                    )
                )
    )
);


/*** Image with Text and Icon ***/

vc_map( array(
    "name" => esc_html__( "Image with text and Icon", 'hudson' ),
    "base" => "no_image_with_text_and_icon",
    "icon" => "icon-wpb-image-with-text-and-icon extended-custom-icon",
    "category" => esc_html__( 'by EDGE', 'hudson' ),
    "allowed_container_element" => 'vc_row',
    "params" => array_merge(
                array(
                    array(
                        "type" => "attach_image",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Image", 'hudson' ),
                        "param_name" => "image"
                    )
                ),
                $hudson_edge_icon_collections->getVCParamsArray(array(), '', true),
                array(
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Type", 'hudson' ),
                        "param_name" => "icon_type",
                        "value" => array(
                            esc_html__( "Circle", 'hudson' ) => "circle",
                            esc_html__( "Square", 'hudson' ) => "square"
                        ),
						"save_always" => true,
                        "description" => "",
                        "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Custom Size (px)", 'hudson' ),
                        "param_name" => "icon_custom_size",
                        "value" => "",
                        "description" => esc_html__( "Default value is 25", 'hudson' ),
                        "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Custom Shape Size (px)", 'hudson' ),
                        "param_name" => "icon_shape_size",
                        "value" => "",
                        "description" => esc_html__( "Default value is 100", 'hudson' ),
                        "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Color", 'hudson' ),
                        "param_name" => "icon_color",
                        "description" => "",
                        "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Icon Background Color", 'hudson' ),
                        "param_name" => "icon_background_color",
                        "description" => "",
                        "dependency" => Array('element' => "icon_pack", 'value' => $hudson_edge_icon_collections->getIconCollectionsKeys())
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Link", 'hudson' ),
                        "param_name" => "link",
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Link Target", 'hudson' ),
                        "param_name" => "target",
                        "value" => array(
                            "" => "",
                            esc_html__( "Self", 'hudson' ) => "_self",
                            esc_html__( "Blank", 'hudson' ) => "_blank"
                        ),
                        "description" => ""
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Title", 'hudson' ),
                        "param_name" => "title",
                        "description" => ""
                    ),
                    array(
                        "type" => "dropdown",
                        "class" => "",
                        "heading" => esc_html__( "Title Tag", 'hudson' ),
                        "param_name" => "title_tag",
                        "value" => array(
                            ""   => "",
                            "h2" => "h2",
                            "h3" => "h3",
                            "h4" => "h4",
                            "h5" => "h5",
                            "h6" => "h6",
                        ),
                        "description" => esc_html__( "Default value is h4", 'hudson' ),
                        "dependency" => Array('element' => "title", 'not_empty' => true)
                    ),
                    array(
                        "type" => "colorpicker",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Title Color", 'hudson' ),
                        "param_name" => "title_color",
                        "description" => "",
                        "dependency" => Array('element' => "title", 'not_empty' => true)
                    ),
                    array(
                        "type" => "textarea_html",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Content", 'hudson' ),
                        "param_name" => "content",
                        "value" => "<p>".esc_html__("I am test text for Image With Text and Icon shortcode.", "hudson")."</p>",
                        "description" => ""
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => esc_html__( "Top Margin", 'hudson' ),
                        "param_name" => "position_top",
                        "description" => esc_html__( "Select top position of title from image. Default value is 75", 'hudson' )
                    )
                )
            )

) );


/*** Image with text ***/

vc_map( array(
	"name" => esc_html__( "Image With Text", 'hudson' ),
	"base" => "no_image_with_text",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-image-with-text extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Image", 'hudson' ),
			"param_name" => "image"
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Alignment", 'hudson' ),
			"param_name" => "alignment",
			"value" => array(
				esc_html__( "Center", 'hudson' ) => "center",
				esc_html__( "Left", 'hudson' ) => "left",
				esc_html__( "Right", 'hudson' ) => "right"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title", 'hudson' ),
			"param_name" => "title",
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Title Color", 'hudson' ),
			"param_name" => "title_color",
			"description" => ""
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => esc_html__( "Title Tag", 'hudson' ),
			"param_name" => "title_tag",
			"value" => array(
				""   => "",
				"h2" => "h2",
				"h3" => "h3",
				"h4" => "h4",
				"h5" => "h5",
				"h6" => "h6",
			),
			"description" => ""
		),
		array(
			"type" => "textarea_html",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Content", 'hudson' ),
			"param_name" => "content",
			"value" => "<p>".esc_html__("I am test text for Interactive Banners shortcode.", "hudson")."</p>",
			"description" => ""
		)
	)
) );


/*** Image hover ***/

vc_map( array(
		"name" => esc_html__( "Image Hover", 'hudson' ),
		"base" => "no_image_hover",
		"category" => esc_html__( 'by EDGE', 'hudson' ),
		"icon" => "icon-wpb-image-hover extended-custom-icon",
		"allowed_container_element" => 'vc_row',
		"params" => array(
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Image", 'hudson' ),
				"param_name" => "image"
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Hover Image", 'hudson' ),
				"param_name" => "hover_image"
			),
            array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Link", 'hudson' ),
				"param_name" => "link",
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Target", 'hudson' ),
				"param_name" => "target",
				"description" => "",
                "value" => array(
                    esc_html__( "Self", 'hudson' ) => "_self",
                    esc_html__( "Blank", 'hudson' ) => "_blank"
                ),
				"save_always" => true,
			),
            array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Animation", 'hudson' ),
				"param_name" => "animation",
				"description" => "",
                "value" => array(
                    "" => "",
                    esc_html__( "Yes", 'hudson' ) => "yes",
                    esc_html__( "No", 'hudson' ) => "no"
                )
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Animation speed (In seconds)", 'hudson' ),
				"param_name" => "animation_speed",
				"dependency" => array('element' => "animation", 'value' => array("yes"))
			),
            array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( "Transition delay", 'hudson' ),
				"param_name" => "transition_delay",
				"description" => "",
                "dependency" => array('element' => "animation", 'value' => array("yes"))
			)
		)
) );

/*** Shrinking Image ***/
vc_map( array(
    "name" => esc_html__( "Shrinking Image", 'hudson' ),
    "base" => "no_shrinking_image",
    "category" => esc_html__( 'by EDGE', 'hudson' ),
    "icon" => "icon-wpb-shrinking-image extended-custom-icon",
    "allowed_container_element" => 'vc_row',
    "params" => array(
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "value" => "",
            "heading" => esc_html__( "Central Image", 'hudson' ),
            "param_name" => "central_image",
            "description" => "",
        ),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "value" => "",
            "heading" => esc_html__( "Left Image", 'hudson' ),
            "param_name" => "left_image",
            "description" => "",
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Left Offset (px)", 'hudson' ),
            "param_name" => "left_image_left",
            "description" => "",
            "dependency" => array('element' => 'left_image', 'not_empty' => true),
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Top Offset (%)", 'hudson' ),
            "param_name" => "left_image_top",
            "description" => "",
            "dependency" => array('element' => 'left_image', 'not_empty' => true),
        ),
        array(
            "type" => "attach_image",
            "holder" => "div",
            "class" => "",
            "value" => "",
            "heading" => esc_html__( "Right Image", 'hudson' ),
            "param_name" => "right_image",
            "description" => "",
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Right Offset (px)", 'hudson' ),
            "param_name" => "right_image_right",
            "description" => "",
            "dependency" => array('element' => 'right_image', 'not_empty' => true),
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Top Offset (%)", 'hudson' ),
            "param_name" => "right_image_top",
            "description" => "",
            "dependency" => array('element' => 'right_image', 'not_empty' => true),
        ),
    )
) );


/*** Vertical Marquee ***/

class WPBakeryShortCode_No_Vertical_Marquee extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" => esc_html__( "Vertical Marquee", 'hudson' ),
	"base" => "no_vertical_marquee",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"as_parent" => array('only' => 'no_vertical_marquee_item'),
	"content_element" => true,
	"icon" => "icon-wpb-vertical-marquee extended-custom-icon",
	"description" => esc_html__( "Scrolling text next to a fixed monitor.", 'hudson' ),
	"js_view" => 'VcColumnView',
	"show_settings_on_create" => false,
	"params" => array()
) );

class WPBakeryShortCode_No_Vertical_Marquee_Item extends WPBakeryShortCode {}
vc_map( array(
	"name" => esc_html__( "Vertical Marquee Item", 'hudson' ),
	"base" => "no_vertical_marquee_item",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"as_child" => array('only' => 'no_vertical_marquee'),
	"icon" => "icon-wpb-vertical-marquee-item extended-custom-icon",
	"params" => array(
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"value" => "",
			"heading" => esc_html__( "Image", 'hudson' ),
			"param_name" => "image",
			"description" => esc_html__( "Choose portrait images for additional scrolling effect.", 'hudson' ),
		),
		array(
			"type" => "textarea_html",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Text", 'hudson' ),
			"param_name" => "content",
		),
	)
) );

/*** Numbered image ***/

vc_map( array(
	"name" => esc_html__( "Numbered Image", 'hudson' ),
	"base" => "no_numbered_image",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	"icon" => "icon-wpb-numbered-image extended-custom-icon",
	"allowed_container_element" => 'vc_row',
	"params" => array(
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Image", 'hudson' ),
			"param_name" => "image"
		),		
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Number", 'hudson' ),
			"param_name" => "number",
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Number Color", 'hudson' ),
			"param_name" => "number_color",
			"description" => ""
		),
		array(
			"type" => "colorpicker",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Stripe Color", 'hudson' ),
			"param_name" => "stripe_color",
			"description" => ""
		),	
	)
) );

/*** Background-Revealing Holder ***/

class WPBakeryShortCode_No_Background_Revealing_Holder extends WPBakeryShortCodesContainer {}
vc_map( array(
	"name" => esc_html__( "Background-Revealing Holder", 'hudson' ),
	"base" => "no_background_revealing_holder",
	"category" => esc_html__( 'by EDGE', 'hudson' ),
	'as_parent' => array('except' => 'vc_row'),
	"content_element" => true,
	"icon" => "icon-wpb-hover-revealing-background extended-custom-icon",
	"description" => esc_html__( "Background reveals or conceals on hover.", 'hudson' ),
	"js_view" => 'VcColumnView',
	"params" => array(
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Background Image", 'hudson' ),
			"param_name" => "bgnd_image",
		),
		array(
			'type' => 'colorpicker',
			'holder' => 'div',
			'class' => '',
			'heading' => esc_html__( 'Background Color', 'hudson' ),
			'param_name' => 'bgnd_color',
			'value' => '',
			'description' => esc_html__( 'The color that interactively covers the background image.', 'hudson' )
		),
		array(
			'type' => "dropdown",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Enable Border Pattern", 'hudson' ),
			"param_name" => "enable_border_pattern",
			"value" => array(
				esc_html__( "Yes", 'hudson' ) => "yes",
				esc_html__( "No", 'hudson' ) => "no"
			),
			"save_always" => true,
			"description" => ""
		),
		array(
			"type" => "attach_image",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Border Pattern", 'hudson' ),
			"param_name" => "border_pattern",
			"value" => "",
			"description" => "",
			"dependency" => array('element' => 'enable_border_pattern', 'value' => array('yes'))
		),
		array(
			"type" => "textfield",
			"holder" => "div",
			"class" => "",
			"heading" => esc_html__( "Padding", 'hudson' ),
			"param_name" => "padding",
			"value" => "",
			"description" => esc_html__( "Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson' )
		),
		array(
			"type" => "dropdown",
			"holder" => "div",
			"class" => "",
			"value" => array(
				esc_html__( "Reveal image", 'hudson' ) => "reveal",
				esc_html__( "Conceal image", 'hudson' ) => "conceal",
			),
			"save_always" => true,
			"heading" => esc_html__( "Hover Action", 'hudson' ),
			"param_name" => "action",
			"description" => esc_html__( "Choose what happens when the mouse is over the holder.", 'hudson' ),
		),
	)
) );

/*** Contact Form 7 ***/

if(hudson_edge_contact_form_7_installed()){
	vc_add_param("contact-form-7", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => esc_html__( "Style", 'hudson' ),
		"param_name" => "html_class",
		"value" => array(
			esc_html__( "Default", 'hudson' ) => "default",
			esc_html__( "Custom Style 1", 'hudson' ) => "cf7_custom_style_1",
			esc_html__( "Custom Style 2", 'hudson' ) => "cf7_custom_style_2",
			esc_html__( "Custom Style 3", 'hudson' ) => "cf7_custom_style_3"
		),
		"description" => esc_html__( "You can style each form element individually in Edge Options > Contact Form 7", 'hudson' )
	));
}

/*** Restore Tabs&Accordion from Deprecated category ***/

$vc_map_deprecated_settings = array (
	'deprecated' => false,
	'category' => esc_html__( 'Content', 'hudson' )
);
vc_map_update( 'vc_accordion', $vc_map_deprecated_settings );
vc_map_update( 'vc_tabs', $vc_map_deprecated_settings );
vc_map_update( 'vc_tab', array('deprecated' => false) );
vc_map_update( 'vc_accordion_tab', array('deprecated' => false) );

?>